#include <allegro.h>
#include "placehld.h"
#include "boulder.h"
#include "globals.h"
#include "utils.h"
#include "man.h"

boulder::boulder()
    : dobj(dobj::BOULDER)
{
    // don't do anything as of yet
}

boulder::~boulder()
{
    // don't do anything as of yet
}

// return free direction
// -1 on failure
int boulder::find_free_dir() const
{
//    warning("boulder::find_free_dir");
    
    dobj *bottom;

    // no free space below if we're at the bottom
    if (y > 0)
    {
	// can we go down?
	if (!(bottom = gr->get(x, y - 1)))
	{
	    return D;
	}
	else
	{
	    // if we're on a man, and our speed is high enough,
	    // kill him.
	    if (bottom->type() == MAN)
	    {
		if (speed > 0 && speed < BOULDER_SMASH_SPEED)
		{
		    kill_man((man *)bottom);

		    // do not assume grid is empty now, stop and wait
		    return -1;
		}
	    }
	    
	    // if we're on another bolder, roll off if possible
	    if (bottom->type() == BOULDER)
	    {
		// don't look left if you're at the edge
		if (x > 0)
		{
		    // left, then down?
		    if (!gr->get(x - 1, y - 1)
			&&
			!gr->get(x - 1, y))
		    {
			return L;
		    }
		}   

		// don't look right if you're at the edge
		if (x < gr->get_w() - 1)
		{
		    // right, then down?
		    if (!gr->get(x + 1, y - 1)
			&&
			!gr->get(x + 1, y))
		    {
			return R;
		    }	
		}
	    }
	}
    }
	    
    return -1;
}


// the big one: what does this boulder want to do
int boulder::go()
{
    int dir;
    
    // this is only called when we're not sleeping (I hope)
    ASSERT(am_awake);
    
    // check below, on the left and on the right to see if we can move
    // if so, start moving there.

    if (move_state == STILL)
    {
	if ((dir = find_free_dir()) > -1)
	{
//	    warning("boulder <%d,%d> : new free dir 1: %d", x, y, dir);
	    
	    from_x = x;
	    from_y = y;
	    to_x = x + dirs[dir][0];
	    to_y = y + dirs[dir][1];

	    fraction = 0;
	    speed = BOULDER_SPEED;
	    move_state = MOVING;
	    
	    // occupy next square before we actually go there,
	    // so noone else occupies it.

	    // if we're going sideways, claim 2 places (also below target)
	    // otherwise just one

	    if (dir == L || dir == R)
		claim_space(to_x, to_y, to_x, to_y - 1);
	    else
		claim_space(to_x, to_y);
	    
	    return WAKE;
	}
	else
	{
	    return SLEEP;
	}
    }
    else if (move_state == MOVING)
    {
	// move
	fraction++;

	if (fraction == speed)
	{
	    return arrive();
	}
	else
	{
	    return WAKE;
	}
    }
    else
    {
	fatal("boulder::go : invalid move_state %d", move_state);
    }

    return SLEEP;
}

int boulder::arrive()
{
    // we've arrived. either stop, continue moving,
    // or fall faster

    int dir;

    ASSERT(plch);
    
    // remove placeholder from the grid
    if (plch)
    {
//	warning("arrive: x = %d, y = %d, plch->x = %d, plch->y = %d",
//		x, y, plch->x, plch->y);

	ASSERT(plch->x == to_x && plch->y == to_y);
	gr->set(plch->x, plch->y, 0);
	
	delete plch;
	plch = 0;
    }

    ASSERT(!plch);
    
    // remove us from the grid and replace at new position
    gr->set(from_x, from_y, 0);
    gr->set(to_x, to_y, this);

    // warn all surrounding objects
    wake_all(from_x, from_y, to_x, to_y);

//    readkey();
    
    // we've arrived, reset move parameters
    fraction = 0;
    
    // check if we continue moving

    // either we still have a placeholder, or we find a new direction
    if (plch2)
    {
	plch = plch2;
	plch2 = 0;
    }
    else
    {
	if ((dir = find_free_dir()) > -1)
	{
//	    warning("new free dir 2: %d", dir);

	    int tx, ty;
	    
	    // claim new space
	    tx = x + dirs[dir][0];
	    ty = y + dirs[dir][1];

	    if (dir == L || dir == R)
		claim_space(tx, ty, tx, ty - 1);
	    else
		claim_space(tx, ty);
	}
    }

    // if plch is set, we continue moving
    if (plch)
    {
	from_x = x;
	from_y = y;
	to_x = plch->x;
	to_y = plch->y;
	
	// keep moving
	move_state = MOVING;
	
	// if we were moving vertically and stay that way, increase speed
	if (to_x == from_x && dir == D)
	{
//	    warning("old speed: %d", speed);
	    speed -= BOULDER_ACCEL;
	    if (speed < BOULDER_MAX_SPEED)
		speed = BOULDER_MAX_SPEED;
//	    warning("new speed: %d", speed);
	}
	else
	{
	    // in all other cases, reset speed
	    speed = BOULDER_SPEED;
	}
	
	return WAKE;
    }
    else
    {
	// no more ways to go? stop moving and sleep
	speed = 0;
	move_state = STILL;
	return SLEEP;
    }
}
