#include <allegro.h>
#include "placehld.h"
#include "utils.h"
#include "man.h"
#include "globals.h"
#include "draw.h"

int kill_man(man *m)
{
    // penalise for dying

    // do not remove from grid, unsafe! (go may still be called for m
//    gr->set(m->x, m->y, 0);
    m->please_destroy = 1;
    
    // set game_over flag
    game_over = 1;

    return 0;
}

man::man()
    : dobj(MAN)
{

}

man::~man()
{

}

int man::find_dir()
{
    int dir = -1;

    if (key[KEY_LEFT])
	dir = L;
    if (key[KEY_RIGHT])
	dir = R;
    if (key[KEY_UP])
	dir = U;
    if (key[KEY_DOWN])
	dir = D;

    if (dir > -1)
    {
	dobj *dto;
	int tx, ty;
	
	// do not check outside of the grid
	tx = x + dirs[dir][0];
	ty = y + dirs[dir][1];

	if (tx < 0 || tx >= gr->get_w() ||
	    ty < 0 || ty >= gr->get_h())
	    return -1;
	
	dto = gr->get(tx, ty);

	if (!dto)
	    return dir;
	
	if (dto->type() == SAND)
	{
	    gr->set(tx, ty, 0);
	    delete dto;
	    return dir;
	}
    }
    
    return -1;
}

int man::go()
{
    int dir;
    
    // this is only called when we're not sleeping (I hope)
    ASSERT(am_awake);
    
    // check below, on the left and on the right to see if we can move
    // if so, start moving there.
    if (move_state == STILL)
    {
	if ((dir = find_dir()) > -1)
	{
	    from_x = x;
	    from_y = y;
	    to_x = x + dirs[dir][0];
	    to_y = y + dirs[dir][1];

	    fraction = 0;
	    speed = MAN_SPEED;
	    move_state = MOVING;
	    
	    // occupy next square before we actually go there,
	    // so noone else occupies it.

	    claim_space(to_x, to_y);
	}
    }
    else if (move_state == MOVING)
    {
	// move
	fraction++;

	if (fraction == speed)
	{
	    arrive();
	}
    }
    else
    {
	fatal("man::go : invalid move_state %d", move_state);
    }

    // man never sleeps
    return WAKE;
}

int man::arrive()
{
    // we've arrived. either stop or continue moving,
    int dir;

    ASSERT(plch);
    
    // remove placeholder from the grid
    if (plch)
    {
	ASSERT(plch->x == to_x && plch->y == to_y);
	gr->set(plch->x, plch->y, 0);
	
	delete plch;
	plch = 0;
    }

    ASSERT(!plch);
    ASSERT(!plch2);
    
    // remove us from the grid and replace at new position
    gr->set(from_x, from_y, 0);
    gr->set(to_x, to_y, this);

    // warn all surrounding objects
    wake_all(from_x, from_y, to_x, to_y);

    // we've arrived, reset move parameters
    fraction = 0;
    
    // check if we continue moving
    if ((dir = find_dir()) > -1)
    {
	int tx, ty;
	
	// claim new space
	tx = x + dirs[dir][0];
	ty = y + dirs[dir][1];
	claim_space(tx, ty);
    }

    // if plch is set, we continue moving
    if (plch)
    {
	from_x = x;
	from_y = y;
	to_x = plch->x;
	to_y = plch->y;
	
	// keep moving
	move_state = MOVING;
	speed = MAN_SPEED;
    }
    else
    {
	// no more ways to go? stop moving and stay awake
	speed = 0;
	move_state = STILL;
    }

    // compute new y offset if necessary
    // scroll by 1/3 screen
    if (y_offset < y - LINES * 2 / 3)
	y_offset += LINES / 4;
    if (y_offset > y - LINES / 3)
	y_offset -= LINES / 4;
    if (y_offset < 0)
	y_offset = 0;
        
    return WAKE;
}
