#include <allegro.h>
#include "dash.h"
#include "globals.h"
#include "boulder.h"
#include "wall.h"
#include "gameloop.h"
#include "draw.h"
#include "highscor.h"

#define MAX_LEVEL 1

char const *levels[MAX_LEVEL] =
{
    "level1.map",
};

int main(int argc, char **argv)
{
    progname = argv[0];

    if (!init())
	return 1;

    datafile = load_datafile("dash.dat");
    
    init_graphics();
    load_high_scores();
    
    int l = 0;

    while (l < MAX_LEVEL)
    {
	int ret = level_loop(levels[l]);

	if (ret == LOOP_GAME_OVER)
	{
	    continue;
	}
	if (ret == LOOP_NEW_LEVEL)
	{
	    l++;
	    l = l % MAX_LEVEL;
	    continue;
	}

	break;
    }

    add_high_score(score);

    print_high_scores();
    
    warning("main: exiting");

    write_high_scores();
    shutdown_graphics();

    unload_datafile(datafile);
    
    allegro_exit();
    
    return 0;
}

END_OF_MAIN();
