#include <stdio.h>
#include <string.h>
#include "highscor.h"
#include "utils.h"
#include "draw.h"

int high_scores_available = 0;
high_score_entry high_scores[MAX_HIGH_SCORES];

char const *filename = "highscor.dat";

char new_name[80];

void add_high_score(int score)
{
    int where;

    warning("adding highscore %d", score);
    
    for (where = 0; where < MAX_HIGH_SCORES; where++)
    {
	warning("new score: %d, old score %d: %d", score, where, high_scores[where].score);
	
	if (score > high_scores[where].score)
	{
	    break;
	}
    }

    warning("where: %d, MAX_HIGH %d, score %d", where, MAX_HIGH_SCORES, score);
    
    if (where >= MAX_HIGH_SCORES)
    {
	warning("score not high enough");
	return;
    }
    
    // if we're still in range, put us in and shift everything else down
    for (int i = MAX_HIGH_SCORES - 1; i > where; i--)
    {
	high_scores[i].score = high_scores[i-1].score;
	strcpy(high_scores[i].name, high_scores[i-1].name);
    }

    high_scores[where].score = score;

    // read name : tricky part
    read_new_name(new_name, 80);
    strcpy(high_scores[where].name, new_name);
}

void load_high_scores()
{
    int i;
    
    FILE *fp = fopen(filename, "r");
    if (!fp)
    {
	warning("Could not open '%s', highscores not available", filename);
	return;
    }

    for (i = 0; i < MAX_HIGH_SCORES && !feof(fp); i++)
    {
	fscanf(fp, "%d %s |\n",
	       &(high_scores[i].score),
	       high_scores[i].name);
    }

    if (i < MAX_HIGH_SCORES)
    {
	warning("Error reading '%s', highscores not available", filename);
    }

    fclose(fp);
    high_scores_available = 1;

    warning("High score file succesfully loaded");
}

void write_high_scores()
{
    // open high score file
    FILE *fp = fopen(filename, "w");
    if (!fp)
    {
	warning("Could not open '%s', cannot save highscores.", filename);
    }
    
    for (int i = 0; i < MAX_HIGH_SCORES; i++)
    {
	fprintf(fp, "%d %s |\n", high_scores[i].score, high_scores[i].name);
    }

    fclose(fp);

    warning("High score file succesfully written");
}

void print_high_scores()
{
    int textcol = makecol(100, 100, 255);

    clear_to_color(screen, makecol(20, 20, 50));

    textout_centre(screen, font, "HIGH SCORES", SCREEN_W / 2, SCREEN_H / 10, textcol);
    
    for (int i = 0; i < MAX_HIGH_SCORES; i++)
    {
	char buf[200];
	sprintf(buf, "%s    %d.%d", high_scores[i].name, high_scores[i].score / 100, high_scores[i].score % 100);
	
	textout_centre(screen, font, buf, SCREEN_W / 2, SCREEN_H / 5 + 2 * i * text_height(font), textcol);
    }

    textout_centre(screen, font, "press a key to exit", SCREEN_W / 2, SCREEN_H * 9 / 10, textcol);

    while(keypressed())
	readkey();
    readkey();
}

    
