#include <allegro.h>
#include "grid.h"
#include "utils.h"
#include "wall.h"
#include "boulder.h"
#include "man.h"
#include "target.h"
#include "sand.h"
#include "globals.h"

grid::grid()
{
    w = 0;
    h = 0;
    contents = 0;
}

grid::grid(int _w, int _h)
{
    allocate(_w, _h);
}

void grid::allocate(int _w, int _h)
{
    ASSERT(!contents);

    w = _w;
    h = _h;
    
    contents = new (dobj **)[w];
    for (int x = 0; x < w; x++)
    {
	contents[x] = new (dobj *)[h];
	for (int y = 0; y < h; y++)
	{
	    contents[x][y] = 0;
	}
    }
}

grid::~grid()
{
    if (contents)
    {
	for (int x = 0; x < w; x++)
	{
	    for (int y = 0; y < h; y++)
	    {
		// delete the object if there is one
		if (contents[x][y])
		    delete contents[x][y];
	    }

	    // delete the vertical row
	    delete [] contents[x];
	}

	// delete the horizontal row
	delete [] contents;
    }
}

dobj *grid::get(int x, int y) const
{
    ASSERT (x >= 0 && x < w && y >= 0 && y < h && contents);
    
    // make sure this is in range
    if (x >= 0 && x < w && y >= 0 && y < h && contents)
    {
//	warning("get(%d, %d) = %p", x, y, contents[x][y]);
	return contents[x][y];
    }
    else
    {
	return 0;
    }
}

void grid::set(int x, int y, dobj *what)
{
    // make sure this is in range
    ASSERT(x >= 0 && x < w && y >= 0 && y < h);

    // overwrite without asking
    // has to be possible to set 0
    contents[x][y] = what;

    if (what)
    {
	what->x = x;
	what->y = y;
    }
}

int grid::load(FILE *fp)
{
    char c;
    int n = 0;
    
    // first countdown
    fscanf(fp, "countdown: %d\n", &countdown);
    warning("countdown : %d seconds\n", countdown);
    countdown *= 100;

    // width, height
    fscanf(fp, "width: %d\n", &w);
    fscanf(fp, "height: %d\n", &h);

    warning("grid::load : level size <%d, %d>", w, h);
    allocate(w, h);
    
    while (n < w * h) 
    {
	if (feof(fp))
	{
	    warning("grid::load : end of file encountered at <%d, %d>",
		    n % w, n / w);
	    return 0;
	}

	c = fgetc(fp);

//	warning("read character '%c'", c);
	
	switch (c)
	{
	    case '.':       // empty room
		n++;
		break;
	    case '#':       // wall
		set(n % w, h - 1 - (n / w), new wall());
		n++;
		break;
	    case 'O':       // boulder
		set(n % w, h - 1 - (n / w), new boulder());
		n++;
		break;
	    case 'M':       // man
		set(n % w, h - 1 - (n / w), new man());
		n++;
		break;
	    case 'T':
		set(n % w, h - 1 - (n / w), new target());
		n++;
		break;
	    case 'S':
	    case ':':
		set(n % w, h - 1 - (n / w), new sand());
		n++;
		break;
	    default:
		// all others (space, newline, etc) ignored
		if (c != '\n' && c != '\r')
		    warning("unknown character '%c' at <%d, %d>",
			    c, n % w, h - (n / w));
		break;
	}
    }

    warning("grid::load : level loaded succesfully");
    
    return 1;
}

int grid::get_w() const
{
    return w;
}

int grid::get_h() const
{
    return h;
}

void grid::wake_all()
{
    // 'touch' all objects
    for (int x = 0; x < w; x++)
    {
	for (int y = 0; y < h; y++)
	{
	    dobj *dtmp;
	    if ((dtmp = contents[x][y]))
		dtmp->wakeup();
	}
    }
}
