#include "globals.h"
#include "draw.h"
#include "utils.h"

grid *gr;

dobj *active_list;
dobj *add_list;

int y_offset;
int game_over;
int finished;
int targets;
int countdown;
int score;
int startcount;

gun *guns[2];
dobj *bulls;

DATAFILE *datafile;

int dirs[DIR_LAST][2] =
{
    {0, 1},
    {-1, 0},
    {1, 0},
    {0, -1},
    {-1, -1},
    {1, -1},
    {-1, 1},
    {1, 1}
};

void init_globals()
{
    gr = new grid();
    active_list = 0;
    add_list = 0;
    y_offset = 0;
    guns[0] = new gun(SCREEN_W / 8, SCREEN_H * 9 / 10, 45);
    guns[1] = new gun(SCREEN_W * 7 / 8, SCREEN_H * 9 / 10, -45);
    game_over = 0;
    finished = 0;
    targets = 0;
    bulls = 0;
    countdown = 0;
//    score = 0;      // don't reset score!
    startcount = 300;
}

void shutdown_globals()
{
    warning("shutdown_globals");
    
    // clean up grid and all objects in it
    delete gr;
    gr = 0;
    
    // delete active objects somewhere else! (in grid)
    active_list = 0;
    add_list = 0;

    // delete guns
    delete guns[0];
    delete guns[1];
    guns[0] = guns[1] = 0;

    dobj *tb = bulls;
    while (tb)
    {
	dobj *tbd = tb;
	tb = tb->next;
	delete tbd;
    }

    warning("shutdown_globals done");
}
