#ifndef _DOBJ_H_
#define _DOBJ_H_

class place_holder;

// dobj: basic object to put in the grid

class dobj
{
public:
    enum actions
    {
	SLEEP = 0,
	WAKE,
    };

    enum dobjs
    {
	NOTHING = 0,
	WALL,
	BOULDER,
	TARGET,
	MAN,
	PLACE_HOLDER,
	SAND,
	BULLET,
	DOBJ_LAST
    };

    enum states
    {
	STILL = 0,
	MOVING,
    };
    
    dobj(int _type);
    virtual ~dobj();

    int type() const;
    int awake() const;
    virtual int wakeup();
    int sleep();
    virtual int go();
    int state() const;
    void wake_all(int x1, int y1, int x2, int y2);
    void claim_space(int x, int y);
    void claim_space(int x, int y, int x2, int y2);
    
    int x, y;
    dobj *next;
    dobj *prev;
    place_holder
        *plch,
	*plch2;
    
    int from_x, from_y;               // move origin
    int to_x, to_y;                   // move destination
    int fraction;                     // time frames on the move
    int speed;                        // time frames to cross one square

    int please_delete;
    int please_destroy;
    
protected:
    int dobj_type;
    int am_awake;
    int move_state;
};

void kill_dobj(dobj *d);

#endif
