#include <stdlib.h>
#include <string.h>
#include "banner.h"
#include "draw.h"

int banner_index = -1;
int banner_pos = 0;
int banner_length = 0;

char const *banners[MAX_BANNER] =
{
    "                                                       "
    "Troubled by headaches?        Fear of boulders?        "
    "Headhunter helmets     --    Your Personal HeadCareWare",
    "                                                       "
    "Sparticle Systems     --    For All Your SPEED and "
    "PARTICLE Needs . . . ",
    "                                                       "
    "Transportation troubles?         Stubborn vehicles in your way?       "
    "Visit http://www.donkey.now/donkey-sale.html for the latest price "
    "information on first class Donkeys."
};

// call this periodically
void show_banner()
{
    static int interval = INTERVAL;
    static int pause = 0;

    if (pause)
    {
	--pause;
	return;
    }
    
    if (--interval > 0)
	return;

    interval = INTERVAL;

    // do something
    if (banner_index == -1)
    {
	// choose and initialise a banner

	banner_index = rand() % MAX_BANNER;
	banner_pos = 0;
	banner_length = strlen(banners[banner_index]);
    }

    // print the current string at current position
    draw_banner_string(banners[banner_index] + banner_pos);
    banner_pos++;

    // check if we're at the end
    if (banner_pos == banner_length)
    {
	// reset variables
	banner_length = 0;
	banner_index = -1;
	banner_pos = 0;

	pause = BANNER_PAUSE;
    }
}
