#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include <string.h>

#include "list.h"
#include "block.h"
#include "sound.h"
#include "timers.h"
#include "map.h"
#include "globals.h"

int gameloop();
int init_graphics();
int init_globals();
int shutdown_graphics();
int shutdown_globals();

int res_x;
int res_y;
int color_depth;

void usage(char **argv)
{
    printf("usage: %s [options]\n\n"
           "options:\n"
	   "-r <w> <h>   : set screen resolution to (<w>, <h>)\n"
	   "-d <depth>   : set color depth to <depth>\n"
	   "-reverse\n"
	   "-richard     : reverse controls\n"
	   "-diff <n>    : set difficulty to n (n >= 0)\n"
	   "               n > 10 is for maniacs only, default = 2\n"
	   "-l <n>       : set initial level to n (1 <= n <= %d)\n" 
	   "-2p          : 2 player mode\n",
	   argv[0], MAX_LEVEL);

    exit(1);
}

void args(int argc, char **argv)
{
    richard = 1;
    res_x = 800;
    res_y = 600;
    color_depth = 16;

    if (argc == 1)
	return;

    for (int i = 1; i < argc; i++)
    {
	// option -richard || -reverse :
	// reverse controls
	if (!strcmp(argv[i], "-richard") || !strcmp(argv[i], "-reverse"))
	{
	    richard = -1;
	    continue;
	}

	if (!strcmp(argv[i], "-r"))
	{
	    if (argc < i + 3)
		usage(argv);

	    // read width and height
	    res_x = atoi(argv[i + 1]);
	    res_y = atoi(argv[i + 2]);

	    // skip next two arguments
	    i += 2;
	    
	    continue;
	}

	if (!strcmp(argv[i], "-d"))
	{
	    if (argc < i + 2)
		usage(argv);

	    // read color depth
	    color_depth = atoi(argv[i + 1]);

	    // skip the next argument
	    i++;

	    continue;
	}

	
	if (!strcmp(argv[i], "-diff"))
	{
	    int diff;
	    
	    if (argc < i + 2)
		usage(argv);

	    // read difficulty
	    diff = atoi(argv[i+1]);
	    if (diff < 0)
		usage(argv);

	    // set difficulty
	    difficulty = start_difficulty = diff;
	    
	    // skip the next argument
	    i++;

	    continue;
	}

	if (!strcmp(argv[i], "-l"))
	{
	    int lev;
	    
	    if (argc < i + 2)
		usage(argv);

	    // read difficulty
	    lev = atoi(argv[i+1]);
	    if (lev < 1 || lev > MAX_LEVEL)
		usage(argv);

	    // set start level
	    level = startlevel = lev - 1;
	    
	    // skip the next argument
	    i++;

	    continue;
	}
	
	if (!strcmp(argv[i], "-2p"))
	{
	    // 2 player mode
	    players = 2;
	    continue;
	}
	
	// unrecognized options:
	usage(argv);
    }
}

void eight_bit_stuff()
{
    generate_332_palette(desktop_palette);

    // swap entries 227 and 254: ugly pink and black
    // restore entry 254 to what it should be
    RGB tmp = desktop_palette[227];
    desktop_palette[227] = desktop_palette[254];
    desktop_palette[254].r = 63;
    desktop_palette[254].g = 63;
    desktop_palette[254].b = 42;

    // add some gray scales, this doesn't help since
    // the color conversion routines seem to take colors only
    // from the beginning of the palette. putting this array
    // of grays at index 1 doesn't work properly either though,
    // so the color conversion code seems to be broken.
    for (int i = 200; i <= 221; i++)
    {
	desktop_palette[i].r = (i - 200) * 3;
	desktop_palette[i].g = (i - 200) * 3;
	desktop_palette[i].b = (i - 200) * 3;
    }
	
    set_palette(desktop_palette);
    clear_to_color(screen, makecol(0, 0, 0));

    /*
    for (int i = 0; i < 256; i++)
    {
	if (desktop_palette[i].r == 63 &&
	    desktop_palette[i].b == 63 &&
	    desktop_palette[i].g == 0)
	{
	    printf("palette[%d] : ugly pink\n", i);
	}
	
	if (desktop_palette[i].r == 0 &&
	    desktop_palette[i].g == 0 &&
	    desktop_palette[i].b == 0)
	{
	    printf("palette[%d] : black\n", i);
	}


	printf("index: %d\tr: %d\tg: %d\tb: %d\n",
	       i,
	       desktop_palette[i].r,
	       desktop_palette[i].g,
	       desktop_palette[i].b);
	
	    // draw palette
	rectfill(screen, i * 4, 0, (i + 1) * 4, 100, i);
	
    }

    readkey();
    */
}

int main(int argc, char **argv)
{
    allegro_init();
    install_timer();
    install_mouse();
    install_keyboard();
    
    // process commandline arguments
    args(argc, argv);
    
    set_color_depth(color_depth);
    if (set_gfx_mode(GFX_AUTODETECT, res_x, res_y, res_x, res_y) < 0)
    {
	printf("error setting graphics mode %dx%dx%d\n",
	       res_x, res_y, color_depth);
	return 1;
    }

    if (color_depth == 8)
    {
	eight_bit_stuff();
    }
    
    if (init_timers() < 0)
    {
	printf("error installing the game timer\n");
	return 1;
    }

    if (init_globals() < 0)
    {
	printf("error initialising globals\n");
	return 1;
    }
    
    if (init_graphics() < 0)
    {
	printf("error initialising graphics\n");
	return 1;
    }

    if (init_sound() < 0)
    {
	printf("error initialising sound\n");
	return 1;
    }
    
    while (gameloop());

    shutdown_graphics();
    shutdown_sound();
    shutdown_globals();
    allegro_exit();
    
    return 0;
}



END_OF_MAIN();
