/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#ifndef _list_h_
#define _list_h_

// general linked List class to store objects in
#include "object.h"

class List_element
{
public:
    List_element();
    virtual ~List_element();

    void set_data(Object *other);

    List_element *next;
    List_element *prev;
    Object *data;
};


class List : public Object
{
public:
    List();
    virtual ~List();

    void clear();                // empties the List (do not deleting objects)
    void destroy();              // deletes all objects and empties the List
    
    void reset();                        // reset current to head
    void reset_tail();                   // reset current to tail
    Object *get_head();                  // get the first element
    Object *get_tail();                  // get the last element

    int next();                          // move to the next element
    int prev();                          // move to the previous element
    Object *get();                       // get the current element
//    Object *get_next();                  // get the next element
//    Object *get_prev();                  // get the previous element
    Object *pop();                       // get and remove the first element
    Object *pop_tail();                  // get and remove the last element
    Object *pop(Object *remove);   // get and remove specified element
    void push(Object *other);      // add a new element at the head
    void push_tail(Object *other); // add a new element at the tail
    void insert(Object *other);    // insert an element *before* current
//    void insert_before(Object *other);   // insert an element after current
    
    Object *find(Object const *search);  // NULL = not found
    int size() const;                    // count elements in the List

    // find an Object in the List. if you can't find it, push
    // the Object into the List
    void ifnotfoundpush(Object *other);  

    // passes all objects in the List to the callback function
    // and if that returns >0 for an Object the Object is moved to
    // the 'to' List, if it returns <0 it is copied  to 'to
    // and if it returns 0 it is leeet alone

    // filter can also be used as a for_all function, byt selecting a
    // null 'to' List and letting the criterium return FILER_LEAVE for everything
    enum
    {
      FILTER_COPY = -1,
      FILTER_LEAVE = 0,
      FILTER_MOVE = 1
    } FILTER_TYPES;
    void filter(int (*criterium)(Object *), List *to);

    // copy functions
    void copy(List *target);      // push this List (reversed) onto target
    void clearcopy(List *target); // clear target and push this List (reversed)
    
    // free List functions
    static void cleanup_freelist();

    #ifdef LISTDEBUG
     int double_push_allowed;
    #endif
    
protected:                               // derived classes need access
    List_element *head;
    List_element *tail;
    List_element *current;

private:    
    // free List functions
    List_element *new_list_element();
    void del_list_element(List_element *le);
    static List_element *recycled;
};

#endif
