#include "init.h"
#include "globals.h"

// ball positions are multiplied with SCREEN_W and SCREEN_H, respectively
// ball speeds are multiplied with a speedfactor
// paddle pos is angle in radians
// paddle color is an index in the block_colors array
double player_data[MAX_PLAYERS][6] =
{
    // xpos, ypos, xspeed, yspeed, paddle_pos, paddle_color
    {-0.48, -0.48, 1.0, 1.0, 1.0, 4},
    {0.48, -0.48,  -1.0, 1.0, 2.0, 2}
};

int init_moving_globals()
{
//    Block *mbl;
    Ball *b;
    int paddle_scale_width;
    int paddle_width;
    int paddle_factor;
    int speed_factor;

//    printf("init_moving_globals: difficulty = %d\n", difficulty);
    
    paddle_scale_width = 150 * SCREEN_H / 600;  // 150 on 800x600 screen
    paddle_factor = 100 - 6 * min(difficulty, 10); // don't go < 40%
    paddle_width = paddle_scale_width * paddle_factor / 100; 

    // set block size
    // 20*20 field takes up approximately 50% of the screen
    size = SCREEN_H / 40;

    // new: flat paddles
    // adapt paddle for difficulty: smaller
    for (int i = 0; i < MAX_PLAYERS; i++)
    {
	if (i < players)
	{
	    int ci = (int)player_data[i][5];
	    
	    pad[i] = new Paddle(paddle_width, player_data[i][4],
				SCREEN_H * 11 / 24 + 2 * i, 1);
	    
	    pad[i]->color = makecol(block_colors[ci][0],
				    block_colors[ci][1],
				    block_colors[ci][2]);
	}
	else
	{
	    pad[i] = 0;
	}
    }
    
    //    pad = new Paddle(100, 4.0, SCREEN_H * 11 / 24, 1);  
    
    // old: round paddles
    //    pad = new Paddle(0.5, 1.0, SCREEN_H * 11 / 24, 1);
    //    pad = new Paddle(0.5, -0.1, SCREEN_H * 11 / 24, 1);

    // ball is about as large as a block
    ball_size = 3 * size / 2;

    // compute ball speed relative to screen size
    vx = SCREEN_H / 500.0;
    vy = SCREEN_H / 500.0;

    speed_factor = 100 + 10 * difficulty;         // +20% speed per step

    vx = vx * speed_factor / 100;
    vy = vy * speed_factor / 100;

//    vx = vy = 0.0;

    for (int i = 0; i < MAX_PLAYERS; i++)
    {
	if (i < players)
	{
	    
	    b = new Ball(SCREEN_W * player_data[i][0],     // xpos
			 SCREEN_H * player_data[i][1],     // ypos
			 ball_size / 2.0,                  // radius
			 vx * player_data[i][2],           // xspeed
			 vy * player_data[i][3],           // yspeed
			 0.0);

	    // b = new Ball(SCREEN_W/5.0, 0.1, ball_size / 2.0, vx, 0.0, 0.0);

	    balls.push(b);
	}
    }
	
    return 0;
}

int init_globals()
{
    // initialise all moving globals (pad, balls, etcetera)
    init_moving_globals();

    // load a map
    load_map(map[level % MAX_LEVEL]);    // wrap around when at max

    return 0;
}

int shutdown_moving_globals()
{
    balls.destroy();

    for (int i = 0; i < players; i++)
    {
	delete pad[i];
	pad[i] = 0;
    }

    return 0;
}

int reset_graphics()
{
    garbage_dirty();
    clear_to_color(back, black);
    clear_to_color(screen, black);

    return 0;
}

int shutdown_globals()
{
    // clean up pad, balls, etc
    shutdown_moving_globals();

    // clean up the grid
    gr.clear();

    return 0;
}

int init_graphics()
{
    white = makecol(255, 255, 255);
    blue = makecol(0, 0, 255);
    red = makecol(255, 0, 0);
    green = makecol(0, 255, 0);
    yellow = makecol(255, 255, 0);
    black = makecol(0, 0, 0);

    // for 8 bit mode: get rid of the beautiful pink screen
    clear_to_color(screen, black);

    back = create_bitmap(SCREEN_W, SCREEN_H);
    if (!back)
	return -1;
    clear_to_color(back, black);
    
    score_bmp = create_bitmap((ball_size + 5) * (MAX_LIVES + 2) +
			      text_length(font, "score: 12345678901"),
			      ball_size + 10);
    if (!score_bmp)
	return -1;
    clear_to_color(score_bmp, black);
    
    scaleball = load_bitmap("ball.tga", 0);
//    printf("colordepth of ball: %d\n", bitmap_color_depth(scaleball));
    
    ball = create_bitmap(ball_size, ball_size);
    if (!ball || !scaleball)
	return -1;
    clear_to_color(ball, black);
    
    stretch_blit(scaleball, ball,
		 0, 0, scaleball->w, scaleball->h,
		 0, 0, ball->w, ball->h);

//    rect(ball, 0, 0, ball->w - 1, ball->h - 1, red);
    
    for (int i = 0; i < MAX_BLOCKS; i++)
    {
	int col1, col2;
	
	blocks[i] = create_bitmap(size, size);
	if (!blocks[i])
	    return -1;
	clear_to_color(blocks[i], black);
	
	// main color
	col1 = makecol(block_colors[i][0],
		       block_colors[i][1],
		       block_colors[i][2]);

	// dark edge
	col2 = makecol(block_colors[i][0] / 2,
		       block_colors[i][1] / 2,
		       block_colors[i][2] / 2);
	
	// fill with appropriate colors
	rect(blocks[i], 0, 0, size - 1, size - 1, col2);
	rectfill(blocks[i], 1, 1, size - 2, size - 2, col1);
    }

    xo = SCREEN_W / 2;
    yo = SCREEN_H / 2;

    return 0;
}

int shutdown_graphics()
{
    destroy_bitmap(back);
    destroy_bitmap(score_bmp);
    destroy_bitmap(scaleball);
    destroy_bitmap(ball);

    back = score_bmp = scaleball = ball = 0;
    
    for (int i = 0; i < MAX_BLOCKS; i++)
    {
	destroy_bitmap(blocks[i]);
	blocks[i] = 0;
    }
    
    return 0;
}
