#include "grid.h"
#include <stdlib.h>
#include <stdio.h>

Grid::Grid(int _w, int _h)
{
    w = _w;
    h = _h;

    blocks = new (Block **)[w];
    for (int i = 0; i < w; i++)
    {
	blocks[i] = new (Block *)[h];
	for (int j = 0; j < h; j++)
	{
	    blocks[i][j] = 0;
	}
    }
}

Grid::~Grid()
{
    clear();
    
    for (int i = 0; i < w; i++)
    {
	delete [] blocks[i];
    }

    delete [] blocks;

    blocks = 0;
    w = 0;
    h = 0;
}

void Grid::clear()
{
    for (int i = 0; i < w; i++)
    {
	for (int j = 0; j < h; j++)
	{
	    if (blocks[i][j])
		delete blocks[i][j];

	    blocks[i][j] = 0;
	}
    }
}

// count all non-permanent blocks
int Grid::count()
{
    int total = 0;
    
    for (int i = 0; i < w; i++)
    {
	for (int j = 0; j < h; j++)
	{
	    if (blocks[i][j] && blocks[i][j]->counter >= 0)
		total++;
	}
    }

    return total;
}

Block *Grid::get(int x, int y)
{
    if (x < 0 || x >= w || y < 0 || y >= h)
	return 0;

    return blocks[x][y];
}

void Grid::set(Block *b, int x, int y)
{
    if (x < 0 || x >= w || y < 0 || y >= h)
    {
	printf("Grid::set : position out of range <%d, %d> (%d x %d grid)\n",
	       x, y, w, h);
	exit(1);
    }
    
    blocks[x][y] = b;

    if (b)
    {
	b->x = x;
	b->y = y;
    }
}
