#include "block.h"

Block::Block()
{
    l = r = b = t = x = y = 0;
}

Block::Block(int left, int right, int bottom, int top, int _counter)
{
    r = right;
    l = left;
    b = bottom;
    t = top;

    x = 0;
    y = 0;

    counter = _counter;    // how often do you need to hit the block
                           // -1 = permanent block, doesn't disappear
}

Block::Block(Block const &other)
{
    r = other.r;
    l = other.l;
    b = other.b;
    t = other.t;
    x = other.x;
    y = other.y;
}

Block const &Block::operator=(Block const &other)
{
    if (this != &other)
    {
	r = other.r;
	l = other.l;
	b = other.b;
	t = other.t;
	x = other.x;
	y = other.y;
    }

    return (*this);
}

// returns the value of counter at the time of the hit
// -1: block is permanent
//  0: remove block
// >0: block has to be hit more times
int Block::hit()
{
    int ret = counter;
    
    // if we can be hit more than once, decrement counter
    if (counter > 0)
    {
	counter--;
    }

    return ret;
}
