#include <allegro.h>

int main()
{
    allegro_init();
    install_keyboard();
    
    set_color_depth(16);

    set_gfx_mode(GFX_AUTODETECT, 800, 600, 800, 600);

    BITMAP *bla = create_bitmap(800, 600);

    int blue = makecol(0, 0, 255);
    
    line(screen, 0, 100, 799, 100, blue);
    line(screen, 0, 150, 799, 150, blue);
    line(screen, 0, 200, 799, 200, blue);
    line(screen, 0, 250, 799, 250, blue);

    int red = makecol(255, 0, 0);
    
    clear_to_color(bla, red);

    for (int i = 1; i < 8; i++)
    {
	line(screen, i * 100, 0, i * 100, 20, red);  // markers : ignore

	// rectangle test (should be 100 <= y <= 150)
	rectfill(screen, i * 100, 100, i * 100 + i - 1, 150, red);

	// blit test (should be 200 <= y <= 250)
	blit(bla, screen, 0, 0, i * 100, 200, i, 51);
    }

    
    readkey();
    
    return 0;
}

END_OF_MAIN();

