#ifndef _BALL_H_
#define _BALL_H_

#include "object.h"
#include "block.h"
#include "paddle.h"

class Ball : public Object
{
public:
    Ball();
    Ball(double _x, double _y, double _rad,
	 double _vx = 0.0, double _vy = 0.0, double _omega = 0.0);
    Ball(Ball const &other);
    Ball const &operator=(Ball const &other);

    int intersect(int x, int y);
    int intersect(double x, double y);
    int intersect(Block *b);
    int intersect(Ball *b);
    int intersect_round(Paddle *p);

    int collide(double x, double y);
    int collide(Block *b);
    int collide(Ball *b);
    int collide_round(Paddle *p);
    int collide(Paddle *p);

    int collide_left();
    int collide_right();
    int collide_top();
    int collide_bottom();
    int collide_center(Block *b);  // emergency case: ball is in the middle
                                   // of the block
    
    void move();
    
    double x;
    double y;
    double rad;
    double vx;
    double vy;
    double omega;
};

#endif
