#include <allegro.h>
#include <stdio.h>
#include <stdlib.h>

SAMPLE *click;

int init_sound()
{
    reserve_voices(3, 0);
    if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, 0) < 0)
    {
	if (install_sound(DIGI_NONE, MIDI_NONE, 0) < 0)
	    return -1;
    }
    
    click = load_sample("click.wav");
    if (!click)
    {
	return -1;
    }

    return 0;
}

int shutdown_sound()
{
    destroy_sample(click);

    return 0;
}

void play_click()
{
    int handle = allocate_voice(click);

    if (handle >= 0)
    {
	// skip the silent part of the sample
	voice_set_position(handle, 9500);
	voice_start(handle);

	release_voice(handle);
    }
}

void play_click_low()
{
    int handle = allocate_voice(click);

    if (handle >= 0)
    {
	// skip the silent part of the sample
	voice_set_position(handle, 9500);
	voice_set_frequency(handle, voice_get_frequency(handle) / 2);
	voice_start(handle);

	release_voice(handle);
    }
}

void play_click_high()
{
    int handle = allocate_voice(click);

    if (handle >= 0)
    {
	// skip the silent part of the sample
	voice_set_position(handle, 9500);
	voice_set_frequency(handle, voice_get_frequency(handle) * 2);
	voice_start(handle);

	release_voice(handle);
    }
}
