#include <stdio.h>
#include "map.h"

Grid gr(20, 20);
int center = 10;

char const *map[MAX_LEVEL][20] = 
{
    {
	"                    ",   
	"                    ",
	"                    ",   
	"                    ",
	"                    ",    // 5   
	"                    ",
	"                    ",   
	"       ######       ",
	"       #    #       ",   
	"       # ## #       ",    // 10
	"       # ## #       ",   
	"       #    #       ",
	"       ######       ",   
	"                    ",
	"                    ",    // 15
	"                    ",
	"                    ",   
	"                    ",
	"                    ",   
	"                    ",    // 20
    },
    {
	"                    ",   
	"                    ",
	"                    ",   
	"                    ",
	"                    ",    // 5   
	"                    ",
	"         ##         ",   
	"        #  #        ",
	"       #2  2#       ",   
	"      #  ##  #      ",    // 10
	"      #  ##  #      ",   
	"       #2  2#       ",
	"        #  #        ",   
	"         ##         ",
	"                    ",    // 15
	"                    ",
	"                    ",   
	"                    ",
	"                    ",   
	"                    ",    // 20
    },
    {
	"                    ",   
	"                    ",
	"                    ",   
	"                    ",
	"        2222        ",    // 5   
	"     ####  ####     ",
	"     #  #  #  #     ",   
	"     #  #  #  #     ",
	"    2####  ####2    ",   
	"    2    33    2    ",    // 10
	"    2    33    2    ",   
	"    2####  ####2    ",
	"     #  #  #  #     ",   
	"     #  #  #  #     ",
	"     ####  ####     ",    // 15
	"        2222        ",
	"                    ",   
	"                    ",
	"                    ",   
	"                    ",    // 20
    },
    {
	"                    ",   
	"                    ",
	"         ##         ",
	"        #33#        ",
	"       ##  ##       ",    // 5
	"      ##    ##      ",   
	"     ##      ##     ",
	"    ##   ##   ##    ",
	"   ##   #22#   ##   ",
	"  #3   #2  2#   3#  ",    // 10
	"  #3   #2  2#   3#  ",
	"   ##   #22#   ##   ",
	"    ##   ##   ##    ",
	"     ##      ##     ",
	"      ##    ##      ",    // 15
	"       ##  ##       ",
	"        #33#        ",
	"         ##         ",
	"                    ",
	"                    ",    // 20
    },
    {
	"                    ",   
	"                    ",
	"  ###    ##    ###  ",
	"  #4    #22#    4#  ",
	"  #    #2  2#    #  ",    // 5
	"      ##    ##      ",   
	"     ##      ##     ",
	"    ##        ##    ",
	"   #2    33    2#   ",
	"  #2    3**3    2#  ",    // 10
	"  #2    3**3    2#  ",
	"   #2    33    2#   ",
	"    ##        ##    ",
	"     ##      ##     ",
	"      ##    ##      ",    // 15
	"  #    #2  2#    #  ",
	"  #4    #22#    4#  ",
	"  ###    ##    ###  ",
	"                    ",
	"                    ",    // 20
    },
    {
	"                    ",   
	"                    ",
	"                    ",   
	"       ******       ",
	"      ##    ##      ",    // 5   
	"     ##222222##     ",
	"    ##2      2##    ",   
	"   *#2   22   2#*   ",
	"   * 2  2##2  2 *   ",   
	"   * 2 2#**#2 2 *   ",    // 10
	"   * 2 2#**#2 2 *   ",   
	"   * 2  2##2  2 *   ",
	"   *#2   22   2#*   ",   
	"    ##2      2##    ",
	"     ##222222##     ",    // 15
	"      ##    ##      ",
	"       ******       ",   
	"                    ",
	"                    ",   
	"                    ",    // 20
    },
    {
	"     ***5  5***     ",   
	" #  *          *  # ",
	"   *            *   ",   
	"  *              *  ",
	" *      3333      * ",    // 5   
	"*                  *",
	"*        ##        *",   
	"*       #22#       *",
	"5   3  ##22##  3   5",   
	"    3 #22##22# 3    ",    // 10
	"    3 #22##22# 3    ",   
	"5   3  ##22##  3   5",
	"*       #22#       *",   
	"*        ##        *",
	"*                  *",    // 15
	" *      3333      * ",
	"  *              *  ",   
	"   *            *   ",
	" #  *          *  # ",   
	"     ***5  5***     ",    // 20
    },
};

// expect a 20*20 array!
void load_map(char const **map)
{
    Block *bl;
    
    for (int x = -center; x < center; x++)
    {
	for (int y = -center; y < center; y++)
	{
	    if (map[y + center][x + center] != ' ')
	    {
		// make sure that the actual block size
		// is size, not size + 1 !!!
		bl = new Block(size * x, size * (x + 1) - 1,
			       size * y, size * (y + 1) - 1);

		// number indicates the amount of times a block
		// has to be hit. # = 1, * = permanent block
		// counter variable is set to n - 1
		switch (map[y + center][x + center])
		{
		    case '#':
		    case '1':
			bl->counter = 0;
			break;
		    case '2':
			bl->counter = 1;
			break;
		    case '3':
			bl->counter = 2;
			break;
		    case '4':
			bl->counter = 3;
			break;
		    case '5':
			bl->counter = 4;
			break;
		    case '*':
			bl->counter = -1;
			break;
		    default:
			printf("load_map: invalid character '%c'\n",
			       map[y + center][x + center]);
			break;
		}

		gr.set(bl, x + center, y + center);
	    }
	}
    }
}
