#include "line.h"

Point::Point(double _x, double _y)
{
    x = _x;
    y = _y;
}

Point::Point(Point const &other)
{
    x = other.x;
    y = other.y;
}

Point const &Point::operator=(Point const &other)
{
    if (this != &other)
    {
	x = other.x;
	y = other.y;
    }

    return (*this);
}

Line::Line(double xfrom, double yfrom, double xto, double yto)
{
    xf = xfrom;
    yf = yfrom;
    xt = xto;
    yt = yto;
}

Line::Line(Point const &pf, Point const &pt)
{
    set(pf, pt);
}

void Line::set(Point const &pf, Point const &pt)
{
    xf = pf.x;
    yf = pf.y;
    xt = pt.x;
    yt = pt.y;
}

Line::Line(Line const &other)
{
    xf = other.xf;
    yf = other.yf;
    xt = other.xt;
    yt = other.xt;
}

Line const &Line::operator=(Line const &other)
{
    if (this != &other)
    {
	xf = other.xf;
	yf = other.yf;
	xt = other.xt;
	yt = other.xt;
    }

    return (*this);
}

// intersect with a horizontal line
Point *Line::intersects_h(double y, double xmin, double xmax)
{
    // if we're horizontal, we don't cross a horizontal line
    if (yf == yt)
	return 0;
    
    // check that our endpoints lie on either side of the line vertically
    if (yf <= y && yt >= y || yf >= y && yt <= y)
    {
	// check that we cross within xmin and xmax
	double xx;
        double dxdy;
	double dy;
	
	dxdy = (xt - xf) / (yt - yf);
	dy = (y - yf);
	
	xx = xf + dxdy * dy;

	// intersection if we are between xmin and xmax
	if (xx < xmin && xx > xmax || xx > xmin && xx < xmax)
	    return new Point(xx, y);
    }
    
    return 0;
}

// intersect with a vertical line
Point * Line::intersects_v(double x, double ymin, double ymax)
{
    // if we're vertical, we don't cross a vertical line
    if (xf == xt)
	return 0;
    
    // check that our endpoints lie on either side of the line horizontally
    if (xf <= x && xt >= x || xf >= x && xt <= x)
    {
	// check that we cross within ymin and ymax
	double yy;
        double dydx;
	double dx;
	
	dydx = (yt - yf) / (xt - xf);
	dx = (x - xf);
	
	yy = yf + dydx * dx;

	// intersection if we are between ymin and ymax
	if (yy < ymin && yy > ymax || yy > ymin && yy < ymax)
	    return new Point(x, yy);
    }
    
    return 0;
}
