#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#include <allegro.h>
#include "paddle.h"
#include "list.h"

#define MAX_BLOCKS 6
#define MAX_PLAYERS 2

extern BITMAP *back;
extern BITMAP *scaleball;
extern BITMAP *ball;
extern BITMAP *blocks[MAX_BLOCKS];
extern BITMAP *score_bmp;

extern int block_colors[MAX_BLOCKS][3];

extern int min(int x1, int x2, int x3);
extern int min(int x1, int x2);
extern int max(int x1, int x2, int x3);
extern int max(int x1, int x2);

extern int white;
extern int blue;
extern int red;
extern int green;
extern int yellow;
extern int black;

extern List balls;
extern int size;
extern int ball_size; 

extern int score;

extern int const MAX_LIVES;
extern int lives;

extern int startlevel;
extern int level;
extern int start_difficulty;
extern int difficulty;
extern int players;

// frame variables
extern int lastframe;
extern int framecount;
extern double fps;

// only draw blocks the first time
extern int first_time;

extern Paddle *pad[MAX_PLAYERS];

// screen offsets for central coordinate system
extern int xo;
extern int yo;

// pad control (direction, stepsize)
extern int richard;
extern double delta_pad_pos;

// ball speed
extern double vx, vy;

#endif
