#include "dirty.h"

dr::dr()
{
    left = right = top = bottom = 0;
    next = 0;
}

dr::dr(int l, int r, int t, int b)
{
    left = l;
    right = r;
    top = t;
    bottom = b;
    next = 0;
}

dr *dirty_freelist = 0;             // first and last list
dr *dirty_list_paint = 0;           // second list
dr *dirty_list_back = 0;            // third list
dr *dirty_list_clear = 0;           // fourth list

dr *new_dirty()
{
    dr *tmp;
    
    if (dirty_freelist)
    {
	tmp = dirty_freelist;
	dirty_freelist = dirty_freelist->next;
	tmp->next = 0;
    }
    else
    {
	tmp = new dr;
    }

    return tmp;
}

void add_dirty(int l, int r, int b, int t)
{
    dr *tmp = new_dirty();

    tmp->left = l;
    tmp->right = r;
    tmp->top = t;
    tmp->bottom = b;

    tmp->next = dirty_list_paint;
    dirty_list_paint = tmp;
}

dr *pop_dirty_paint()
{
    dr *tmp = dirty_list_paint;

    if (tmp)
    {
	dirty_list_paint = tmp->next;
	tmp->next = 0;
    }

    return tmp;
}

dr *pop_dirty_back()
{
    dr *tmp = dirty_list_back;

    if (tmp)
    {
	dirty_list_back = tmp->next;
	tmp->next = 0;
    }

    return tmp;
}

dr *pop_dirty_clear()
{
    dr *tmp = dirty_list_clear;

    if (tmp)
    {
	dirty_list_clear = tmp->next;
	tmp->next = 0;
    }

    return tmp;
}

void free_dirty_paint(dr *tmp)
{
    // add the dirty rectangle to the back list
    tmp->next = dirty_list_back;
    dirty_list_back = tmp;
}

void free_dirty_back(dr *tmp)
{
    // add the dirty rectangle to the clear list
    tmp->next = dirty_list_clear;
    dirty_list_clear = tmp;
}

void free_dirty_clear(dr *tmp)
{
    // add the dirty rectangle to the freelist
    tmp->next = dirty_freelist;
    dirty_freelist = tmp;
}

void empty_list(dr *l)
{
    dr *tmp;
    
    while ((tmp = l))
    {
	l = tmp->next;
	delete tmp;
    }
}

void garbage_dirty()
{
    // clean all lists
    empty_list(dirty_list_paint);
    empty_list(dirty_list_back);
    empty_list(dirty_list_clear);
    empty_list(dirty_freelist);

    // set pointers to zero
    dirty_list_paint = 0;
    dirty_list_back = 0;
    dirty_list_clear = 0;
    dirty_freelist = 0;
}
