#include "includes.h"
#include "externs.h"

/* handles quit query (pressing ESC during play) */
void try_quit(void)
{
    /* remove the clock handler */
    if(cs_game[0].mode != CS_1TF)
    {
        remove_normal_clock();
    }
    else
    {
        remove_count_down_clock();
    }

    /* remove the stack handlers */
    remove_int(core_drop_stack0);
    if(cs_game[0].mode >= CS_2NS)
    {
        remove_int(core_drop_stack1);
    }

    /* set music pattern if we're supposed to */
    if(t3ss_num_patterns >= 64)
    {
        t3ss_set_music_pattern(64);
    }
    t3ss_play_sound(cs_theme.sound[SOUND_PAUSE], 128, I_NULL);

    /* update the screen */
    draw_bg();
    draw_game_paused(&cs_game[0], &cs_theme, &cs_clock);
    if(cs_game[0].mode >= CS_2NS)
    {
        draw_game_paused(&cs_game[1], &cs_theme, &cs_clock);
    }
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "Quit? (Y/N) ");

    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);

    /* wait to see what user wants */
    while(key[KEY_ESC]);
    while(!game_quit && !key[KEY_ESC])
    {
        /* this will exit back to the menu */
        if(key[KEY_Y])
        {
            game_quit = 1;
        }

        /* this will start the game back up */
        if(key[KEY_N])
        {
            break;
        }

        /* keep updating the screen */
        handle_message_list(&cs_game[0].messages);
        if(cs_game[0].mode >= CS_2NS)
        {
            handle_message_list(&cs_game[1].messages);
        }
        draw_bg();
        draw_game_paused(&cs_game[0], &cs_theme, &cs_clock);

        if(cs_game[0].mode >= CS_2NS)
        {
            draw_game_paused(&cs_game[1], &cs_theme, &cs_clock);
        }
        ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "Quit? (Y/N) ");

        cs_vsync();
        cs_screen_blit(cs_theme.screen, 0, 0);
    }
    while(key[KEY_ESC]);

    /* start clocks back up */
    if(cs_game[0].mode != CS_1TF)
    {
        install_normal_clock();
    }
    else
    {
        install_count_down_clock();
    }

    /* start stacks back up */
    install_int(core_drop_stack0, cs_game[0].drop_time);
    if(cs_game[0].mode >= CS_2NS)
    {
        install_int(core_drop_stack1, cs_game[1].drop_time);
    }

    /* reset the music pattern */
    if(t3ss_num_patterns >= 64)
    {
        t3ss_set_music_pattern(0);
    }
}

/* counts down to start of game */
void game_count_down(void)
{
    /* update the screen */
    draw_bg();
    draw_game_paused(&cs_game[0], &cs_theme, &cs_clock);
    if(cs_game[0].mode >= CS_2NS)
    {
        draw_game_paused(&cs_game[1], &cs_theme, &cs_clock);
    }
    t3ss_play_sound(cs_sound[SOUND_GAME_STOP], 128, 22050);
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "3           ");

    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);

    /* wait 1/3 of a second */
    rest(333);

    /* update the screen */
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "3.          ");
    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);

    /* wait 1/3 of a second */
    rest(333);

    /* update the screen */
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "3..         ");
    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);

    /* wait 1/3 of a second */
    rest(333);

    /* update the screen */
    t3ss_play_sound(cs_sound[SOUND_GAME_STOP], 128, 22050);
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "3..2        ");
    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);

    /* wait 1/3 of a second */
    rest(333);

    /* update the screen */
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "3..2.       ");
    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);

    /* wait 1/3 of a second */
    rest(333);

    /* update the screen */
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "3..2..      ");
    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);

    /* wait 1/3 of a second */
    rest(333);
    t3ss_play_sound(cs_sound[SOUND_GAME_STOP], 128, 22050);

    /* update the screen */
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "3..2..1     ");
    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);

    /* wait 1/3 of a second */
    rest(333);

    /* update the screen */
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "3..2..1.    ");
    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);

    /* wait 1/3 of a second */
    rest(333);

    /* update the screen */
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "3..2..1..   ");
    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);
    rest(333);
    t3ss_play_sound(cs_sound[SOUND_GAME_GO], 128, 22050);

    /* update the screen */
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, "3..2..1..GO!");
    cs_vsync();
    cs_screen_blit(cs_theme.screen, 0, 0);

    /* wait 1 second */
    rest(1000);

    /* start the music */
    t3ss_play_mod(music_name);
}

/* do this when the game ends (clears the board) */
void erase_board(CS_GAME * gp)
{
    int i, j;

    /* stamp the current stack onto the board */
    for(i = 0; i < STACK_HEIGHT; i++)
    {
        gp->board[(gp->stack.y + i) * cs_theme.board_w + gp->stack.x] = gp->stack.type[i];
    }

    /* deactivate the stack */
    gp->stack.active = 0;
    gp->stack.dactive = 0;

    /* delete the blocks */
    t3ss_play_sound(cs_theme.sound[SOUND_DELETE], cs_panning[(int)cs_options.stereo][gp->player], I_NULL);
    for(i = 0; i < cs_theme.board_h + STACK_HEIGHT; i++)
    {
        for(j = 0; j < cs_theme.board_w; j++)
        {
            if(gp->board[i * cs_theme.board_w + j] != 0)
            {
                core_delete_block(gp, &cs_theme, j, i, cs_theme.board_w, cs_theme.board_h);
            }
        }
    }
}

/* does this when game is over */
void game_over(void)
{
    /* only do if player didn't quit */
    if(!game_quit)
    {
        /* set the music pattern */
        if(t3ss_num_patterns >= 32)
        {
            t3ss_set_music_pattern(32);
        }

        /* classic mode messages */
        if(cs_game[0].mode == CS_1NS)
        {
            queue_message(&cs_game[0].messages, 2, "            Final Score - %d", cs_game[0].score);
            if(cs_place_score(&cs_game[0], &cs_scores) > 0)
            {
                if(cs_place_score(&cs_game[0], &cs_scores) < 10)
                {
                    queue_message(&cs_game[0].messages, 2, "            You are ranked number %d on the highest scores.", cs_place_score(&cs_game[0], &cs_scores) + 1);
                }
                queue_message(&cs_game[0].messages, 2, "            Try for 1st.");
            }
            else
            {
                queue_message(&cs_game[0].messages, 2, "            Congratulations, you have the best score.");
            }
        }

        /* destroyer mode messages */
        else if(cs_game[0].mode == CS_1TD && !game_quit && cs_game[0].state != STATE_GAMEOVER)
        {
            if(cs_place_score(&cs_game[0], &cs_scores) > 0)
            {
                if(cs_place_score(&cs_game[0], &cs_scores) < 10)
                {
                    queue_message(&cs_game[0].messages, 2, "            You are ranked number %d on the best times.", cs_place_score(&cs_game[0], &cs_scores) + 1);
                }
                queue_message(&cs_game[0].messages, 2, "            Try for 1st.");
            }
            else
            {
                queue_message(&cs_game[0].messages, 2, "            Congratulations, you have the best time.");
            }
        }

        /* frenzy mode messages */
        else if(cs_game[0].mode == CS_1TF)
        {
            queue_message(&cs_game[0].messages, 2, "            Final Score - %d", cs_game[0].score);
            if(cs_place_score(&cs_game[0], &cs_scores) > 0)
            {
                if(cs_place_score(&cs_game[0], &cs_scores) < 10)
                {
                    queue_message(&cs_game[0].messages, 2, "            You are ranked number %d on the highest scores.", cs_place_score(&cs_game[0], &cs_scores) + 1);
                }
                queue_message(&cs_game[0].messages, 2, "            Try for 1st");
            }
            else
            {
                queue_message(&cs_game[0].messages, 2, "            Congratulations, you have the best score.");
            }
        }

        /* show winner in 2 player modes */
        else if(cs_game[0].mode == CS_2NS || cs_game[0].mode == CS_2BS)
        {
            if(cs_game[0].score > cs_game[1].score)
            {
                queue_message(&cs_game[0].messages, 2, "            Congratulations player 1, you are the winner.");
                queue_message(&cs_game[1].messages, 2, "            You lose.");
            }
            else if(cs_game[1].score > cs_game[0].score)
            {
                queue_message(&cs_game[1].messages, 2, "            Congratulations player 2, you are the winner.");
                queue_message(&cs_game[0].messages, 2, "            You lose.");
            }
            else
            {
                queue_message(&cs_game[1].messages, 2, "            You are tied.");
                queue_message(&cs_game[0].messages, 2, "            You are tied.");
            }
        }
        else if(cs_game[0].mode == CS_2NL || cs_game[0].mode == CS_2BL)
        {
            if(cs_game[1].state == STATE_GAMEOVER)
            {
                queue_message(&cs_game[0].messages, 2, "            Congratulations player 1, you are the winner.");
                queue_message(&cs_game[1].messages, 2, "            You lose.");
            }
            else if(cs_game[0].state == STATE_GAMEOVER)
            {
                queue_message(&cs_game[1].messages, 2, "            Congratulations player 2, you are the winner.");
                queue_message(&cs_game[0].messages, 2, "            You lose.");
            }
        }
        else if(cs_game[0].mode == CS_2ND || cs_game[0].mode == CS_2BD)
        {
            if(cs_game[0].state == STATE_WIN)
            {
                queue_message(&cs_game[0].messages, 2, "            Congratulations player 1, you are the winner.");
                queue_message(&cs_game[1].messages, 2, "            You lose.");
            }
            else if(cs_game[1].state == STATE_WIN)
            {
                queue_message(&cs_game[1].messages, 2, "            Congratulations player 2, you are the winner.");
                queue_message(&cs_game[0].messages, 2, "            You lose.");
            }
        }

        /* wait until user desires to exit */
        while(!key[KEY_ESC] && !key[KEY_SPACE] && !key[KEY_ENTER] && !ncd_joy_button(0, 0))
        {
            /* poll joystick */
            ncd_joy_poll();

            /* move stuff */
            handle_message_list(&cs_game[0].messages);
            if(cs_game[0].mode >= CS_2NS)
            {
                handle_message_list(&cs_game[1].messages);
            }
            if(cs_options.effects)
            {
                move_effect_blocks(&cs_theme, &cs_effects_blocks);
            }

            /* update the screen */
            draw_bg();
            core_handle_wild_card(&cs_game[0]);
            draw_game(&cs_game[0], &cs_theme, &cs_clock);
            if(cs_game[0].mode >= CS_2NS)
            {
                core_handle_wild_card(&cs_game[1]);
                draw_game(&cs_game[1], &cs_theme, &cs_clock);
            }
            ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.message_x, cs_theme.message_y, " GAME OVER ");
            if(cs_options.effects)
            {
                draw_effect_blocks(&cs_theme, &cs_effects_blocks);
            }

            cs_vsync();
            cs_screen_blit(cs_theme.screen, 0, 0);
        }
    }
}
