#include "includes.h"

/* creates a clean message list */
void initialize_message_list(CS_MESSAGE_LIST * lp, char cwidth)
{
    int i;

    lp->size = 0;
    lp->counter = 0;
    lp->cw = cwidth;
    for(i = 0; i < QUEUE_SIZE; i++)
    {
        memset(lp->message[i], 0, 128);
    }
}

/* add a new message to the message list */
void queue_message(CS_MESSAGE_LIST * lp, char mode, char * fmt, ...)
{
    char buffer[128];

    /* make the string */
    va_list ap;
    va_start(ap, fmt);
    vsprintf(buffer, fmt, ap);
    va_end(ap);

    /* copy the string */
    strcpy(lp->message[lp->size], buffer);

    /* set the variables */
    lp->mode[lp->size] = mode;
    lp->visible = 1;
    lp->size++;
}

/* goes to the next message in the list */
void next_message(CS_MESSAGE_LIST * lp)
{
    int i;

    /* move all messages down in the list */
    for(i = 0; i < lp->size - 1; i++)
    {
        strcpy(lp->message[i], lp->message[i + 1]);
        lp->mode[i] = lp->mode[i + 1];
    }

    /* adjust the size of the list */
    if(lp->size > 0)
    {
        lp->size--;
        if(lp->size > 0)
        {
            lp->visible = 1;
        }
        else
        {
            lp->visible = 0;
        }
    }
}

/* handles the message list */
void handle_message_list(CS_MESSAGE_LIST * lp)
{
    char buffer[128];
    int i;

    /* see if there are messages in the list */
    if(lp->size > 0)
    {
        /* handle flash mode message */
        if(lp->mode[0] == MESSAGE_FLASH)
        {
            /* flashes based on counter */
            lp->counter++;
            if(lp->counter % 10 == 0)
            {
                if(lp->visible)
                {
                    lp->visible = 0;
                }
                else
                {
                    lp->visible = 1;
                }
            }

            /* time for next message after 120 frames */
            if(lp->counter >= 120)
            {
                next_message(lp);
                lp->counter = 0;
            }
        }

        /* handle scroll mode messages */
        else if(lp->mode[0] == MESSAGE_SCROLL)
        {
            /* scroll one letter every 7 frames */
            lp->counter++;
            if(lp->counter % 7 == 0)
            {
                /* chew first letter from message */
                for(i = 0; i < 127; i++)
                {
                    buffer[i] = lp->message[0][i + 1];
                }
                strcpy(lp->message[0], buffer);

                /* see if it's time for next message */
                if(strlen(lp->message[0]) <= 0)
                {
                    next_message(lp);
                    lp->counter = 0;
                }
            }
        }
    }
}

/* draws messages */
void draw_messages(CS_MESSAGE_LIST * lp, CS_GAME * gp, CS_THEME * tp)
{
    /* if message is visible, draw it */
    if(lp->visible)
    {
        ncd_printf_truncated(tp->screen, &tp->font, tp->player_message_x[gp->player], tp->player_message_y[gp->player], 12, lp->message[0]);
    }
}

/* draws messages at specified location */
void draw_messages_pos(CS_MESSAGE_LIST * lp, BITMAP * surface, NCDFONT * fp, int x, int y, int width)
{
    /* if message is visible, draw it */
    if(lp->visible)
    {
        ncd_printf_truncated(surface, fp, x, y, width, lp->message[0]);
    }
}
