#include "includes.h"
#include "externs.h"

int cc_flag = -1;
int dlet, blet;
char cc_temp[128];

/* build the menus */
void initialize_menus(void)
{
    /* set some variables */
//    text_mode(-1);
    gui_fg_color = 234;
    gui_bg_color = 238;
    cs_options.level = 0;
    cs_options.block_index = 1;
    cs_options.time_index = 1;

    /* set up the main menu */
    initialize_menu(&cs_menu[MENU_MAIN], MENU_MAIN);
    add_menu_item(&cs_menu[MENU_MAIN], "Play", "Play the Game", MENU_X, MENU_Y, NULL, NULL, main_menu_play);
    add_menu_item(&cs_menu[MENU_MAIN], "Options", "Adjust Game Settings", MENU_X, MENU_Y + 12, NULL, NULL, main_menu_options);
    add_menu_item(&cs_menu[MENU_MAIN], "Scores", "View High Scores", MENU_X, MENU_Y + 24, NULL, NULL, main_menu_scores);
    add_menu_item(&cs_menu[MENU_MAIN], "Credits", "View Credits", MENU_X, MENU_Y + 36, NULL, NULL, show_credits);
    add_menu_item(&cs_menu[MENU_MAIN], "Exit", "Exit to Favorite OS", MENU_X, MENU_Y + 48, NULL, NULL, main_menu_quit_proc);

        /* set up the custom controls menu */
        initialize_menu(&cs_menu[MENU_CCONTROL], MENU_CONTROL);
        add_menu_item(&cs_menu[MENU_CCONTROL], "Left", "Key for Moving Left", 20, 43 + 24, NULL, NULL, customize_controls);
        add_menu_item(&cs_menu[MENU_CCONTROL], "Right", "Key for Moving Right", 20, 43 + 48, NULL, NULL, customize_controls);
        add_menu_item(&cs_menu[MENU_CCONTROL], "Drop", "Key for Dropping Stack", 20, 43 + 72, NULL, NULL, customize_controls);
        add_menu_item(&cs_menu[MENU_CCONTROL], "Rotate Up", "Key to Rotate Up", 20, 43 + 96, NULL, NULL, customize_controls);
        add_menu_item(&cs_menu[MENU_CCONTROL], "Rotate Down", "Key to Rotate Down", 20, 43 + 120, NULL, NULL, customize_controls);
        add_menu_item(&cs_menu[MENU_CCONTROL], "Left", "Key for Moving Left", 180, 43 + 24, NULL, NULL, customize_controls);
        add_menu_item(&cs_menu[MENU_CCONTROL], "Right", "Key for Moving Right", 180, 43 + 48, NULL, NULL, customize_controls);
        add_menu_item(&cs_menu[MENU_CCONTROL], "Drop", "Key for Dropping Stack", 180, 43 + 72, NULL, NULL, customize_controls);
        add_menu_item(&cs_menu[MENU_CCONTROL], "Rotate Up", "Key to Rotate Up", 180, 43 + 96, NULL, NULL, customize_controls);
        add_menu_item(&cs_menu[MENU_CCONTROL], "Rotate Down", "Key to Rotate Down", 180, 43 + 120, NULL, NULL, customize_controls);

        /* set up the joystick menu */
        initialize_menu(&cs_menu[MENU_JCONTROL], MENU_CONTROL);
        add_menu_item(&cs_menu[MENU_JCONTROL], "Joystick Toggle", "Toggle Joystick", MENU_X, MENU_Y, menu_joystick_toggle, menu_joystick_toggle, NULL);

        /* set up the scores menu */
        initialize_menu(&cs_menu[MENU_SCORES], MENU_MAIN);
        add_menu_item(&cs_menu[MENU_SCORES], "Classic", "Show Classic Scores", MENU_X, MENU_Y, NULL, NULL, show_scores);
        add_menu_item(&cs_menu[MENU_SCORES], "Destroyer", "Show Destroyer Times", MENU_X, MENU_Y + 12, NULL, NULL, scores_menu_destroyer);
        add_menu_item(&cs_menu[MENU_SCORES], "Frenzy", "Show Frenzy Scores", MENU_X, MENU_Y + 24, NULL, NULL, scores_menu_frenzy);

            /* set up the destroyer times menu */
            initialize_menu(&cs_menu[MENU_DSCORES], MENU_SCORES);
            add_menu_item(&cs_menu[MENU_DSCORES], "Blocks", "Starting Blocks", MENU_X, MENU_Y, menu_blocks_left_proc, menu_blocks_right_proc, NULL);
            add_menu_item(&cs_menu[MENU_DSCORES], "View", "Show Times", MENU_X, MENU_Y + 24, NULL, NULL, show_scores);

            /* set up the frenzy scores menu */
            initialize_menu(&cs_menu[MENU_FSCORES], MENU_SCORES);
            add_menu_item(&cs_menu[MENU_FSCORES], "Time Limit", "Starting Time", MENU_X, MENU_Y, menu_time_left_proc, menu_time_right_proc, NULL);
            add_menu_item(&cs_menu[MENU_FSCORES], "View", "Show Scores", MENU_X, MENU_Y + 24, NULL, NULL, show_scores);

        /* set up the options menu */
        initialize_menu(&cs_menu[MENU_OPTIONS], MENU_MAIN);
        add_menu_item(&cs_menu[MENU_OPTIONS], "Audio", "Adjust Sound Settings", MENU_X, MENU_Y, NULL, NULL, options_menu_audio);
        add_menu_item(&cs_menu[MENU_OPTIONS], "Game", "Adjust Game Settings", MENU_X, MENU_Y + 12, NULL, NULL, options_menu_game);
        add_menu_item(&cs_menu[MENU_OPTIONS], "Graphics", "Adjust Graphics Settings", MENU_X, MENU_Y + 24, NULL, NULL, options_menu_graphics);
        add_menu_item(&cs_menu[MENU_OPTIONS], "Controls", "Adjust Control Settings", MENU_X, MENU_Y + 36, NULL, NULL, main_menu_control);
        add_menu_item(&cs_menu[MENU_OPTIONS], "Theme", "Load a New Theme", MENU_X, MENU_Y + 48, NULL, NULL, select_theme);

            /* set up the audio options menu */
            initialize_menu(&cs_menu[MENU_AUDIO], MENU_OPTIONS);
            add_menu_item(&cs_menu[MENU_AUDIO], "Sound Volume", "Change Sound Volume", MENU_X, MENU_Y, menu_sound_volume_left_proc, menu_sound_volume_right_proc, NULL);
            add_menu_item(&cs_menu[MENU_AUDIO], "Music Volume", "Change Music Volume", MENU_X, MENU_Y + 24, menu_music_volume_left_proc, menu_music_volume_right_proc, NULL);

            /* always stereo in Windows */
            #ifndef ALLEGRO_WINDOWS
            add_menu_item(&cs_menu[MENU_AUDIO], "Sound Quality", "Change Audio Quality (MUST RESTART GAME)", MENU_X, MENU_Y + 48, menu_sound_quality_left_proc, menu_sound_quality_right_proc, NULL);
            add_menu_item(&cs_menu[MENU_AUDIO], "Sound Mode", "Change Sound Mode (MUST RESTART GAME)", MENU_X, MENU_Y + 72, menu_stereo_left_proc, menu_stereo_right_proc, NULL);
            #endif

            /* set up the game options menu */
            initialize_menu(&cs_menu[MENU_GAME], MENU_OPTIONS);
            add_menu_item(&cs_menu[MENU_GAME], "Wild Card", "Toggle Wild Card", MENU_X, MENU_Y, menu_wild_card_toggle, menu_wild_card_toggle, NULL);
            add_menu_item(&cs_menu[MENU_GAME], "Bomb", "Toggle Bomb", MENU_X, MENU_Y + 24, menu_bomb_toggle, menu_bomb_toggle, NULL);

            /* set up the graphics options menu */
            initialize_menu(&cs_menu[MENU_GRAPHICS], MENU_OPTIONS);
            add_menu_item(&cs_menu[MENU_GRAPHICS], "Effects", "Toggle Special Effects", MENU_X, MENU_Y, menu_effects_toggle, menu_effects_toggle, NULL);
            add_menu_item(&cs_menu[MENU_GRAPHICS], "Transitions", "Toggle Transitions", MENU_X, MENU_Y + 24, menu_transitions_toggle, menu_transitions_toggle, NULL);
            add_menu_item(&cs_menu[MENU_GRAPHICS], "VSync", "Toggle Vertical Syncronization", MENU_X, MENU_Y + 48, menu_vsync_toggle, menu_vsync_toggle, NULL);

            /* only available in Windows for now */
            #if defined(ALLEGRO_WINDOWS) || defined(ALLEGRO_UNIX) || defined(__BEOS__)
            add_menu_item(&cs_menu[MENU_GRAPHICS], "Screen Mode", "Change Screen Mode", MENU_X, MENU_Y + 72, menu_screen_mode_left_proc, menu_screen_mode_right_proc, NULL);
            #endif

            /* set up the controls menu */
            initialize_menu(&cs_menu[MENU_CONTROL], MENU_OPTIONS);
            add_menu_item(&cs_menu[MENU_CONTROL], "Keyboard", "Set Up Keyboard", MENU_X, MENU_Y, NULL, NULL, control_menu_keyboard);
            add_menu_item(&cs_menu[MENU_CONTROL], "Joystick", "Set Joystick Options", MENU_X, MENU_Y + 12, NULL, NULL, control_menu_joystick);

        /* set up the play menu */
        initialize_menu(&cs_menu[MENU_PLAY], MENU_MAIN);
        add_menu_item(&cs_menu[MENU_PLAY], "1 Player", "Play a 1 Player Game", MENU_X, MENU_Y, NULL, NULL, play_menu_1p);
        add_menu_item(&cs_menu[MENU_PLAY], "2 Players", "Play a 2 Player Game", MENU_X, MENU_Y + 12, NULL, NULL, play_menu_2p);

            /* set up the 1 player game selection menu */
            initialize_menu(&cs_menu[MENU_1PLAY], MENU_PLAY);
            add_menu_item(&cs_menu[MENU_1PLAY], "Classic", "Play Classic Mode", MENU_X, MENU_Y, NULL, NULL, play_menu_1p_classic);
            add_menu_item(&cs_menu[MENU_1PLAY], "Destroyer", "Play Destroyer Mode", MENU_X, MENU_Y + 12, NULL, NULL, play_menu_1p_destroyer);
            add_menu_item(&cs_menu[MENU_1PLAY], "Frenzy", "Play Frenzy Mode", MENU_X, MENU_Y + 24, NULL, NULL, play_menu_1p_frenzy);

                /* set up the 1 player classic menu */
                initialize_menu(&cs_menu[MENU_1PLAYC], MENU_1PLAY);
                add_menu_item(&cs_menu[MENU_1PLAYC], "Start Level", "Change Starting Level", MENU_X, MENU_Y, menu_level_left_proc, menu_level_right_proc, NULL);
                add_menu_item(&cs_menu[MENU_1PLAYC], "Start", "Start Playing", MENU_X, MENU_Y + 24, NULL, NULL, menu_play_proc);

                /* set up the 1 player destroyer menu */
                initialize_menu(&cs_menu[MENU_1PLAYD], MENU_1PLAY);
                add_menu_item(&cs_menu[MENU_1PLAYD], "Start Level", "Change Starting Level", MENU_X, MENU_Y, menu_level_left_proc, menu_level_right_proc, NULL);
                add_menu_item(&cs_menu[MENU_1PLAYD], "Start Blocks", "Choose Amount of Blocks", MENU_X, MENU_Y + 24, menu_blocks_left_proc, menu_blocks_right_proc, NULL);
                add_menu_item(&cs_menu[MENU_1PLAYD], "Start", "Start Playing", MENU_X, MENU_Y + 48, NULL, NULL, menu_play_proc);

                /* set up the 1 player frenzy menu */
                initialize_menu(&cs_menu[MENU_1PLAYF], MENU_1PLAY);
                add_menu_item(&cs_menu[MENU_1PLAYF], "Start Level", "Change Starting Level", MENU_X, MENU_Y, menu_level_left_proc, menu_level_right_proc, NULL);
                add_menu_item(&cs_menu[MENU_1PLAYF], "Start Time", "Change Time Limit", MENU_X, MENU_Y + 24, menu_time_left_proc, menu_time_right_proc, NULL);
                add_menu_item(&cs_menu[MENU_1PLAYF], "Start", "Start Playing", MENU_X, MENU_Y + 48, NULL, NULL, menu_play_proc);

                /* set up the 2 player game selection menu */
                initialize_menu(&cs_menu[MENU_2PLAY], MENU_PLAY);
                add_menu_item(&cs_menu[MENU_2PLAY], "Normal", "Play Normal Game", MENU_X, MENU_Y, NULL, NULL, play_menu_2pn);
                add_menu_item(&cs_menu[MENU_2PLAY], "Battle", "Play with Battle Elements", MENU_X, MENU_Y + 12, NULL, NULL, play_menu_2pb);

                    initialize_menu(&cs_menu[MENU_2PLAYN], MENU_2PLAY);
                    add_menu_item(&cs_menu[MENU_2PLAYN], "Top Score", "Play Top Score Mode", MENU_X, MENU_Y, NULL, NULL, menu_2pn_top_score);
                    add_menu_item(&cs_menu[MENU_2PLAYN], "Last Out", "Play Last Out Mode", MENU_X, MENU_Y + 12, NULL, NULL, menu_2pn_last_out);
                    add_menu_item(&cs_menu[MENU_2PLAYN], "Destroyer", "Play Destroyer Mode", MENU_X, MENU_Y + 24, NULL, NULL, menu_2pn_destroyer);

                        initialize_menu(&cs_menu[MENU_2PLAYNS], MENU_2PLAYN);
                        add_menu_item(&cs_menu[MENU_2PLAYNS], "Start Level", "Change Starting Level", MENU_X, MENU_Y, menu_level_left_proc, menu_level_right_proc, NULL);
                        add_menu_item(&cs_menu[MENU_2PLAYNS], "Start", "Start Playing", MENU_X, MENU_Y + 24, NULL, NULL, menu_play_proc);

                        initialize_menu(&cs_menu[MENU_2PLAYNL], MENU_2PLAYN);
                        add_menu_item(&cs_menu[MENU_2PLAYNL], "Start Level", "Change Starting Level", MENU_X, MENU_Y, menu_level_left_proc, menu_level_right_proc, NULL);
                        add_menu_item(&cs_menu[MENU_2PLAYNL], "Start", "Start Playing", MENU_X, MENU_Y + 24, NULL, NULL, menu_play_proc);

                        initialize_menu(&cs_menu[MENU_2PLAYND], MENU_2PLAYN);
                        add_menu_item(&cs_menu[MENU_2PLAYND], "Start Level", "Change Starting Level", MENU_X, MENU_Y, menu_level_left_proc, menu_level_right_proc, NULL);
                        add_menu_item(&cs_menu[MENU_2PLAYND], "Start Blocks", "Choose Amount of Blocks", MENU_X, MENU_Y + 24, menu_blocks_left_proc, menu_blocks_right_proc, NULL);
                        add_menu_item(&cs_menu[MENU_2PLAYND], "Start", "Start Playing", MENU_X, MENU_Y + 48, NULL, NULL, menu_play_proc);

                    initialize_menu(&cs_menu[MENU_2PLAYB], MENU_2PLAY);
                    add_menu_item(&cs_menu[MENU_2PLAYB], "Top Score", "Play Top Score Mode", MENU_X, MENU_Y, NULL, NULL, menu_2pb_top_score);
                    add_menu_item(&cs_menu[MENU_2PLAYB], "Last Out", "Play Last Out Mode", MENU_X, MENU_Y + 12, NULL, NULL, menu_2pb_last_out);
                    add_menu_item(&cs_menu[MENU_2PLAYB], "Destroyer", "Play Destroyer Mode", MENU_X, MENU_Y + 24, NULL, NULL, menu_2pb_destroyer);

                        initialize_menu(&cs_menu[MENU_2PLAYBS], MENU_2PLAYB);
                        add_menu_item(&cs_menu[MENU_2PLAYBS], "Start Level", "Change Starting Level", MENU_X, MENU_Y, menu_level_left_proc, menu_level_right_proc, NULL);
                        add_menu_item(&cs_menu[MENU_2PLAYBS], "Start", "Start Playing", MENU_X, MENU_Y + 24, NULL, NULL, menu_play_proc);

                        initialize_menu(&cs_menu[MENU_2PLAYBL], MENU_2PLAYB);
                        add_menu_item(&cs_menu[MENU_2PLAYBL], "Start Level", "Change Starting Level", MENU_X, MENU_Y, menu_level_left_proc, menu_level_right_proc, NULL);
                        add_menu_item(&cs_menu[MENU_2PLAYBL], "Start", "Start Playing", MENU_X, MENU_Y + 24, NULL, NULL, menu_play_proc);

                        initialize_menu(&cs_menu[MENU_2PLAYBD], MENU_2PLAYN);
                        add_menu_item(&cs_menu[MENU_2PLAYBD], "Start Level", "Change Starting Level", MENU_X, MENU_Y, menu_level_left_proc, menu_level_right_proc, NULL);
                        add_menu_item(&cs_menu[MENU_2PLAYBD], "Start Blocks", "Choose Amount of Blocks", MENU_X, MENU_Y + 24, menu_blocks_left_proc, menu_blocks_right_proc, NULL);
                        add_menu_item(&cs_menu[MENU_2PLAYBD], "Start", "Start Playing", MENU_X, MENU_Y + 48, NULL, NULL, menu_play_proc);
}

/* update the custom controls menu */
void custom_control_menu_update(int ox, int oy, int d)
{
    /* draw player 1 heading */
    ncd_textout(screen_buffer, cs_menu[current_menu].selected < 5 ? &cs_big_menu_font : &cs_big_menu_font_un, 8 + ox, 43 + 2 + oy, "Player 1");

    /* draw all keys as currently configured */
    if(d != 0)
    {
//        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 0 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 32 + ox, 43 + 36 + 2 + oy, key_names[cs_controls[0].left]);
        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 0 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 32 + ox, 43 + 36 + 2 + oy, (char *)scancode_to_name(cs_controls[0].left));
    }
    if(d != 1)
    {
        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 1 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 32 + ox, 43 + 60 + 2 + oy, (char *)scancode_to_name(cs_controls[0].right));
    }
    if(d != 2)
    {
        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 2 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 32 + ox, 43 + 84 + 2 + oy, (char *)scancode_to_name(cs_controls[0].drop));
    }
    if(d != 3)
    {
        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 3 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 32 + ox, 43 + 108 + 2 + oy, (char *)scancode_to_name(cs_controls[0].rup));
    }
    if(d != 4)
    {
        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 4 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 32 + ox, 43 + 132 + 2 + oy, (char *)scancode_to_name(cs_controls[0].rdown));
    }
    ncd_textout(screen_buffer, cs_menu[current_menu].selected >= 5 ? &cs_big_menu_font : &cs_big_menu_font_un, 168 + ox, 43 + 2, "Player 2");
    if(d != 5)
    {
        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 5 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 192 + ox, 43 + 36 + 2 + oy, (char *)scancode_to_name(cs_controls[1].left));
    }
    if(d != 6)
    {
        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 6 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 192 + ox, 43 + 60 + 2 + oy, (char *)scancode_to_name(cs_controls[1].right));
    }
    if(d != 7)
    {
        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 7 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 192 + ox, 43 + 84 + 2 + oy, (char *)scancode_to_name(cs_controls[1].drop));
    }
    if(d != 8)
    {
        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 8 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 192 + ox, 43 + 108 + 2 + oy, (char *)scancode_to_name(cs_controls[1].rup));
    }
    if(d != 9)
    {
        ncd_textout(screen_buffer, cs_menu[current_menu].selected == 9 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, 192 + ox, 43 + 132 + 2 + oy, (char *)scancode_to_name(cs_controls[1].rdown));
    }
}

/* update the joystick menu */
void joystick_menu_update(void)
{
    ncd_textout(screen_buffer, cs_options.joystick ? &cs_big_menu_font_green : &cs_big_menu_font_red, MENU_X + 16, MENU_Y + 14, toggle_text[cs_options.joystick]);
}

/* update the destroyer scores menu */
void destroyer_scores_menu_update(int ox, int oy)
{
    ncd_draw_number(screen_buffer, cs_menu[current_menu].selected == 0 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16 + ox, MENU_Y + 14 + oy, block_chart[cs_options.block_index], 3);
}

/* update the frenzy scores menu */
void frenzy_scores_menu_update(int ox, int oy)
{
    ncd_draw_number(screen_buffer, cs_menu[current_menu].selected == 0 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16 + ox, MENU_Y + 14 + oy, time_minutes_chart[cs_options.time_index], 2);
    ncd_textout(screen_buffer, cs_menu[current_menu].selected == 0 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16 + 24 + ox, MENU_Y + 14 + oy, ":");
    ncd_draw_number(screen_buffer, cs_menu[current_menu].selected == 0 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16 + 36 + ox, MENU_Y + 14 + oy, time_seconds_chart[cs_options.time_index], 2);
}

/* update the audio menu */
void audio_menu_update(void)
{
    /* draw sound volume bar */
    rectfill(screen_buffer, MENU_X + 16, MENU_Y + 14, MENU_X + 16 + 101, MENU_Y + 14 + 10, cs_menu[current_menu].selected == 0 ? 220 : 217);
    if(cs_options.sound_volume > 0)
    {
        rectfill(screen_buffer, MENU_X + 16 + 1, MENU_Y + 14 + 1, MENU_X + 16 + cs_options.sound_volume, MENU_Y + 14 + 10 - 1, cs_menu[current_menu].selected == 0 ? 222 : 219);
    }

    /* draw music volume bar */
    rectfill(screen_buffer, MENU_X + 16, MENU_Y + 38, MENU_X + 16 + 101, MENU_Y + 38 + 10, cs_menu[current_menu].selected == 1 ? 220 : 217);
    if(cs_options.music_volume > 0)
    {
        rectfill(screen_buffer, MENU_X + 16 + 1, MENU_Y + 38 + 1, MENU_X + 16 + cs_options.music_volume, MENU_Y + 38 + 10 - 1, cs_menu[current_menu].selected == 1 ? 222 : 219);
    }

    /* draw the other settings */
    #ifndef ALLEGRO_WINDOWS
    ncd_textout(screen_buffer, cs_menu[current_menu].selected == 2 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16, MENU_Y + 62, sound_quality_text[cs_options.sound_quality]);
    ncd_textout(screen_buffer, cs_menu[current_menu].selected == 3 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16, MENU_Y + 86, stereo_mode_text[cs_options.stereo]);
    #endif
}

/* update the game options menu */
void game_menu_update(void)
{
    if(cs_menu[current_menu].selected == 0)
    {
        ncd_textout(screen_buffer, cs_options.wild_card ? &cs_big_menu_font_green : &cs_big_menu_font_red, MENU_X + 16, MENU_Y + 14, toggle_text[cs_options.wild_card]);
        ncd_textout(screen_buffer, cs_options.bomb ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, MENU_X + 16, MENU_Y + 14 + 24, toggle_text[cs_options.bomb]);
    }
    else if(cs_menu[current_menu].selected == 1)
    {
        ncd_textout(screen_buffer, cs_options.wild_card ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, MENU_X + 16, MENU_Y + 14, toggle_text[cs_options.wild_card]);
        ncd_textout(screen_buffer, cs_options.bomb ? &cs_big_menu_font_green : &cs_big_menu_font_red, MENU_X + 16, MENU_Y + 14 + 24, toggle_text[cs_options.bomb]);
    }
}

/* update the graphics options menu */
void graphics_menu_update(void)
{
    if(cs_menu[current_menu].selected == 0)
    {
        ncd_textout(screen_buffer, cs_options.effects ? &cs_big_menu_font_green : &cs_big_menu_font_red, MENU_X + 16, MENU_Y + 14, toggle_text[cs_options.effects]);
    }
    else
    {
        ncd_textout(screen_buffer, cs_options.effects ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, MENU_X + 16, MENU_Y + 14, toggle_text[cs_options.effects]);
    }
    if(cs_menu[current_menu].selected == 1)
    {
        ncd_textout(screen_buffer, cs_options.transitions ? &cs_big_menu_font_green : &cs_big_menu_font_red, MENU_X + 16, MENU_Y + 38, toggle_text[cs_options.transitions]);
    }
    else
    {
        ncd_textout(screen_buffer, cs_options.transitions ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, MENU_X + 16, MENU_Y + 38, toggle_text[cs_options.transitions]);
    }
    if(cs_menu[current_menu].selected == 2)
    {
        ncd_textout(screen_buffer, cs_options.vsync ? &cs_big_menu_font_green : &cs_big_menu_font_red, MENU_X + 16, MENU_Y + 62, toggle_text[cs_options.vsync]);
    }
    else
    {
        ncd_textout(screen_buffer, cs_options.vsync ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, MENU_X + 16, MENU_Y + 62, toggle_text[cs_options.vsync]);
    }
    #if defined(ALLEGRO_WINDOWS) || defined(ALLEGRO_UNIX) || defined(__BEOS__)
    ncd_textout(screen_buffer, cs_menu[current_menu].selected == 3 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16, MENU_Y + 86, screen_mode_text[(int)cs_screen_mode]);
    #endif
}

/* update the 1 player classic menu */
void play_1p_classic_menu_update(void)
{
    ncd_draw_number(screen_buffer, cs_menu[current_menu].selected == 0 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16, MENU_Y + 14, cs_options.level + 1, 2);
}

/* update the 1 player destroyer menu */
void play_1p_destroyer_menu_update(void)
{
    ncd_draw_number(screen_buffer, cs_menu[current_menu].selected == 0 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16, MENU_Y + 14, cs_options.level + 1, 2);
    ncd_draw_number(screen_buffer, cs_menu[current_menu].selected == 1 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16, MENU_Y + 38, block_chart[cs_options.block_index], 3);
}

/* update the 1 player frenzy menu */
void play_1p_frenzy_menu_update(void)
{
    ncd_draw_number(screen_buffer, cs_menu[current_menu].selected == 0 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16, MENU_Y + 14, cs_options.level + 1, 2);
    ncd_draw_number(screen_buffer, cs_menu[current_menu].selected == 1 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16, MENU_Y + 38, time_minutes_chart[cs_options.time_index], 2);
    ncd_textout(screen_buffer, cs_menu[current_menu].selected == 1 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16 + 24, MENU_Y + 38, ":");
    ncd_draw_number(screen_buffer, cs_menu[current_menu].selected == 1 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16 + 36, MENU_Y + 38, time_seconds_chart[cs_options.time_index], 2);
}

/* update the 2 player normal top score menu */
void play_2pn_top_score_menu_update(void)
{
    ncd_draw_number(screen_buffer, cs_menu[current_menu].selected == 0 ? &cs_big_menu_font_green : &cs_big_menu_font_green_un, MENU_X + 16, MENU_Y + 14, cs_options.level + 1, 2);
}

/* draw the specified menu (ox and oy are 0 when menu is drawn as normal) */
void draw_menu(CS_MENU * mp, BITMAP * bp, int ox, int oy)
{
    int i;

    /* update the selector sprite position */
    cs_select_sprite.x = cs_menu[current_menu].item[cs_menu[current_menu].selected].x - 22;
    cs_select_sprite.y = cs_menu[current_menu].item[cs_menu[current_menu].selected].y;

    /* update the background */
    blit(cs_menu_bg_image, bp, 0, 0, ox, oy, 320, 240);

    /* update according to what menu we're on */
    if(current_menu != MENU_CCONTROL)
    {
        draw_sprite(bp, cs_logo_image, ox, MLOGO_Y + oy);
    }
    if(current_menu == MENU_AUDIO)
    {
        audio_menu_update();
    }
    if(current_menu == MENU_GAME)
    {
        game_menu_update();
    }
    if(current_menu == MENU_GRAPHICS)
    {
        graphics_menu_update();
    }
    if(current_menu == MENU_1PLAYC)
    {
        play_1p_classic_menu_update();
    }
    if(current_menu == MENU_1PLAYD)
    {
        play_1p_destroyer_menu_update();
    }
    if(current_menu == MENU_1PLAYF)
    {
        play_1p_frenzy_menu_update();
    }
    if(current_menu == MENU_2PLAYNS)
    {
        play_2pn_top_score_menu_update();
    }
    if(current_menu == MENU_2PLAYNL)
    {
        play_2pn_top_score_menu_update();
    }
    if(current_menu == MENU_2PLAYND)
    {
        play_1p_destroyer_menu_update();
    }
    if(current_menu == MENU_2PLAYBS)
    {
        play_2pn_top_score_menu_update();
    }
    if(current_menu == MENU_2PLAYBL)
    {
        play_2pn_top_score_menu_update();
    }
    if(current_menu == MENU_2PLAYBD)
    {
        play_1p_destroyer_menu_update();
    }
    if(current_menu == MENU_CCONTROL)
    {
        custom_control_menu_update(ox, oy, cc_flag);
    }
    if(current_menu == MENU_JCONTROL)
    {
        joystick_menu_update();
    }
    if(current_menu == MENU_DSCORES)
    {
        destroyer_scores_menu_update(ox, oy);
    }
    if(current_menu == MENU_FSCORES)
    {
        frenzy_scores_menu_update(ox, oy);
    }

    /* draws all items in the menu */
    for(i = 0; i < mp->item_count; i++)
    {
        if(i == cs_menu[current_menu].selected)
        {
            ncd_textout(bp, &cs_big_menu_font, mp->item[i].x + ox, mp->item[i].y + oy, mp->item[i].text);
        }
        else
        {
            ncd_textout(bp, &cs_big_menu_font_un, mp->item[i].x + ox, mp->item[i].y + oy + 2, mp->item[i].text);
        }
    }

    /* animate the selector */
    cs_select_sprite.frame++;

    /* draw the selector */
    draw_ani(bp, cs_select_sprite.ap, cs_select_sprite.x + ox, cs_select_sprite.y + oy, cs_select_sprite.frame);

    /* draw the subtitle text */
    ncd_textout_center(screen_buffer, &cs_menu_font, ox, 231 + oy, cs_menu[current_menu].item[cs_menu[current_menu].selected].sub_text);
}

/* draws everything onto bp */
void draw_menu_screen(BITMAP * bp, int ox, int oy)
{
    draw_menu(&cs_menu[current_menu], bp, ox, oy);
}

/* we call this normally (when we're not doing any effects) */
void update_menu_screen(void)
{
    draw_menu_screen(screen_buffer, 0, 0);
    cs_vsync();
    cs_screen_blit(screen_buffer, 0, 0);
}

/* reset the menus */
void reset_menus(void)
{
    /* set the graphics mode, in case it was changed by themes */
    cs_gfx_mode(320, 240, cs_options.transitions ? screen_palette : black_palette);

    /* back to main menu */
    current_menu = MENU_MAIN;

    /* if we didn't get a high score last game, don't restart music */
    if(cs_place < 10)
    {
        t3ss_play_mod(DATADIR "cs.dat#menu_music");
    }

    /* do the transition effect */
    draw_menu_screen(screen_buffer, 0, 0);
    if(cs_options.transitions)
    {
        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
        gef_split_in_horizontal(screen_buffer);
    }
    else
    {
        cs_screen_blit(screen_buffer, 0, 0);
        fade_in(screen_palette, 3);
    }
}

/* handle the menu controls */
void do_menu_controls(void)
{
    int i;
    int speed = 1;

    /* poll the joystick */
    ncd_joy_poll();

    /* see if we'll allow joystick input this frame */
    if(!ncd_joy_left(0) && !ncd_joy_right(0) && !ncd_joy_up(0) && !ncd_joy_down(0))
    {
        dlet = 0;
    }
    if(!ncd_joy_button(0, 0) && !ncd_joy_button(0, 1) && !ncd_joy_button(0, 2))
    {
        blet = 1;
    }

    /* handle the back buttons */
    if(key[KEY_ESC] || (ncd_joy_button(0, 1) && blet))
    {
        t3ss_play_sound(cs_sound[SOUND_MENU_BACK], 128, 22050);

        /* if we're on main menu, select quit option */
        if(current_menu == MENU_MAIN)
        {
            cs_menu[current_menu].selected = 4;
        }

        /* otherwise */
        else
        {
            /* if we're on custom control menu, do scooting effect */
            if(current_menu == MENU_CCONTROL)
            {
                current_menu = cs_menu[current_menu].parent;
                if(cs_options.transitions)
                {
                    t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);

                    /* do scoot effect */
                    blit(screen_buffer, gef_screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
                    for(i = 0; i < 320; i += speed)
                    {
                        speed++;
                    }
                    speed++;
                    for(i = 320; i >= 0; i -= speed)
                    {
                        draw_menu_screen(screen_buffer, i, 0);
                        blit(gef_screen, screen_buffer, 0, 0, i - 320, 0, SCREEN_W, SCREEN_H);
                        speed--;

                        cs_vsync();
                        cs_screen_blit(screen_buffer, 0, 0);
                    }
                }
            }
            /* or we go to parent menu */
            else
            {
                current_menu = cs_menu[current_menu].parent;
            }
        }

        /* so we don't jump around the menus */
        clear_keybuf();
        key[KEY_ESC] = 0;
        blet = 0;
    }

    /* handle up buttons */
    if(key[KEY_UP] || (ncd_joy_up(0) && dlet % 16 == 0))
    {
        /* select the previous item in the menu */
        cs_menu[current_menu].selected--;

        /* wrap to bottom if we're at top of menu */
        if(cs_menu[current_menu].selected < 0)
        {
            cs_menu[current_menu].selected = cs_menu[current_menu].item_count - 1;
        }
        t3ss_play_sound(cs_sound[SOUND_MENU_MOVE], 128, 22050);

        /* so we don't jump around the menus */
        clear_keybuf();
        key[KEY_UP] = 0;
        dlet++;
    }
    else if(ncd_joy_up(0))
    {
        dlet++;
    }

    /* handle down buttons */
    if(key[KEY_DOWN] || (ncd_joy_down(0) && dlet % 16 == 0))
    {
        /* select next item in the menu */
        cs_menu[current_menu].selected++;

        /* wrap to top if we're at the bottom */
        if(cs_menu[current_menu].selected >= cs_menu[current_menu].item_count)
        {
            cs_menu[current_menu].selected = 0;
        }
        t3ss_play_sound(cs_sound[SOUND_MENU_MOVE], 128, 22050);

        /* so we don't jump around the menus */
        clear_keybuf();
        key[KEY_DOWN] = 0;
        dlet++;
    }
    else if(ncd_joy_down(0))
    {
        dlet++;
    }

    /* handle left buttons */
    if(key[KEY_LEFT] || (ncd_joy_left(0) && dlet % 16 == 0))
    {
        /* if a left_proc is defined for the current menu item, call it */
        if(cs_menu[current_menu].item[cs_menu[current_menu].selected].left_proc != NULL)
        {
            /* don't play the sound if we're changing the music volume */
            if(!(current_menu == MENU_AUDIO && cs_menu[current_menu].selected == 1))
            {
                t3ss_play_sound_reserved(cs_sound[SOUND_MENU_CHANGE], 0, 128, 22050);
            }

            /* call the procedure */
            cs_menu[current_menu].item[cs_menu[current_menu].selected].left_proc();

            /* keep it from repeating (except on volume changes) */
            if(current_menu != MENU_AUDIO || (current_menu == MENU_AUDIO && cs_menu[current_menu].selected >= 2))
            {
                clear_keybuf();
                key[KEY_LEFT] = 0;
                dlet++;
            }
        }
    }
    else if(ncd_joy_left(0))
    {
        dlet++;
    }

    /* handle right buttons */
    if(key[KEY_RIGHT] || (ncd_joy_right(0) && dlet % 16 == 0))
    {
        /* if a right_proc is defined for the current menu item, call it */
        if(cs_menu[current_menu].item[cs_menu[current_menu].selected].right_proc != NULL)
        {
            /* don't play the sound if we're changing the music volume */
            if(!(current_menu == MENU_AUDIO && cs_menu[current_menu].selected == 1))
            {
                t3ss_play_sound_reserved(cs_sound[SOUND_MENU_CHANGE], 0, 128, 22050);
            }

            /* call the procedure */
            cs_menu[current_menu].item[cs_menu[current_menu].selected].right_proc();

            /* keep it from repeating (except on volume changes) */
            if(current_menu != MENU_AUDIO || (current_menu == MENU_AUDIO && cs_menu[current_menu].selected >= 2))
            {
                clear_keybuf();
                key[KEY_RIGHT] = 0;
                dlet++;
            }
        }
    }
    else if(ncd_joy_right(0))
    {
        dlet++;
    }

    /* handle select buttons */
    if(key[KEY_ENTER] || ((ncd_joy_button(0, 0) || ncd_joy_button(0, 2)) && blet))
    {
        /* if enter_proc is defined for the current menu item, call it */
        if(cs_menu[current_menu].item[cs_menu[current_menu].selected].enter_proc != NULL)
        {
            t3ss_play_sound(cs_sound[SOUND_MENU_ENTER], 128, 22050);
            cs_menu[current_menu].item[cs_menu[current_menu].selected].enter_proc();
        }

        /* keep it from repeating */
        clear_keybuf();
        key[KEY_ENTER] = 0;
        blet = 0;
    }
}

/* draws the high score screen onto bp */
void draw_high_score_screen(BITMAP * bp, int mode, int ox, int oy)
{
    blit(cs_menu_bg_image, bp, 0, 0, ox, oy, 320, 240);
    draw_sprite(bp, cs_high_score_image, ox, MLOGO_Y + oy);
    draw_high_scores_pos(bp, &cs_big_menu_font, &cs_scores, mode, ox, oy, 1);
}

/* function to show scores from the menu */
void show_scores(void)
{
    int i;
    char HSScreen = 0;
    int speed = 1;

    /* figure which mode to pass (0=classic,1-10=destroyer,11-20=frenzy) */
    if(current_menu == MENU_DSCORES)
    {
        HSScreen = 1 + cs_options.block_index;
    }
    if(current_menu == MENU_FSCORES)
    {
        HSScreen = 11 + cs_options.time_index;
    }

    /* do the scoot effect */
    if(cs_options.transitions)
    {
        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
        for(i = 0; i < 320; i += speed)
        {
            speed++;
        }
        speed++;
        for(i = 0; i < 320; i += speed)
        {
            draw_menu_screen(screen_buffer, -i, 0);
            draw_high_score_screen(screen_buffer, HSScreen, 320 - i, 0);
            speed--;

            cs_vsync();
            cs_screen_blit(screen_buffer, 0, 0);
        }
    }

    /* show the scores */
    while(!key[KEY_ESC] && !ncd_joy_button(0, 1))
    {
        ncd_joy_poll();

        /* update the screen buffer */
        blit(cs_menu_bg_image, screen_buffer, 0, 0, 0, 0, 320, 240);
        draw_sprite(screen_buffer, cs_high_score_image, 0, MLOGO_Y);
        draw_high_scores(screen_buffer, &cs_big_menu_font, &cs_scores, HSScreen);

        /* draw it to the screen */
        cs_vsync();
        cs_screen_blit(screen_buffer, 0, 0);
    }

    /* do the scoot effect */
    if(cs_options.transitions)
    {
        speed = 1;

        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
        for(i = 0; i < 320; i += speed)
        {
            speed++;
        }
        speed++;
        for(i = 320; i >= 0; i -= speed)
        {
            draw_menu_screen(screen_buffer, -i, 0);
            draw_high_score_screen(screen_buffer, HSScreen, 320 - i, 0);
            speed--;

            cs_vsync();
            cs_screen_blit(screen_buffer, 0, 0);
        }
    }
    else
    {
        clear_keybuf();
        key[KEY_ESC] = 0;
    }
}

/* whos score screen immediately (done after you play the game) */
void show_scores_immediate(int HSScreen)
{
    int i;
    int speed = 1;

    /* show the scores */
    while(!key[KEY_ESC] && !ncd_joy_button(0, 1))
    {
        ncd_joy_poll();
        blit(cs_menu_bg_image, screen_buffer, 0, 0, 0, 0, 320, 240);
        draw_sprite(screen_buffer, cs_high_score_image, 0, MLOGO_Y);
        draw_high_scores(screen_buffer, &cs_big_menu_font, &cs_scores, HSScreen);

        cs_vsync();
        cs_screen_blit(screen_buffer, 0, 0);
    }

    /* select the main menu */
    current_menu = MENU_MAIN;

    /* play the menu music if we got a high score last game */
    if(cs_place < 10)
    {
        t3ss_play_mod(DATADIR "cs.dat#menu_music");
    }

    /* do scoot effect */
    if(cs_options.transitions)
    {
        speed = 1;

        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
        for(i = 0; i < 320; i += speed)
        {
            speed++;
        }
        speed++;
        for(i = 320; i >= 0; i -= speed)
        {
            draw_menu_screen(screen_buffer, -i, 0);
            draw_high_score_screen(screen_buffer, HSScreen, 320 - i, 0);
            speed--;

            cs_vsync();
            cs_screen_blit(screen_buffer, 0, 0);
        }
    }
    else
    {
        clear_keybuf();
        key[KEY_ESC] = 0;
    }
}

/* the main menu function (stays here until the user exits) */
void cs_main_menu(void)
{
    /* set up */
    initialize_menus();

    /* start the music */
    t3ss_play_mod(DATADIR "cs.dat#menu_music");

    /* do transition effect */
    if(cs_options.transitions)
    {
        set_palette(screen_palette);
        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
        draw_menu_screen(screen_buffer, 0, 0);
        gef_split_in_horizontal(screen_buffer);
    }

    /* or not */
    else
    {
        set_palette(black_palette);
        draw_menu_screen(screen_buffer, 0, 0);
        cs_screen_blit(screen_buffer, 0, 0);
        fade_in(screen_palette, 3);
    }

    /* stay in the menu until we're done */
    while(!menu_quit)
    {
        do_menu_controls();
        update_menu_screen();
    }

    /* do transition effect */
    if(cs_options.transitions)
    {
        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
        gef_split_out_horizontal_b(screen_buffer);
    }
    else
    {
        fade_out(3);
    }
}

/* these are all the functions pointed to by the menus */
void main_menu_quit_proc(void)
{
    menu_quit = 1;
}

/* switch to keyboard menu */
void control_menu_keyboard(void)
{
    int i;
    int speed = 1;

    current_menu = MENU_CCONTROL;
    cs_menu[MENU_CCONTROL].selected = 0;

    /* do scooting effect */
    if(cs_options.transitions)
    {
        blit(screen_buffer, gef_screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
        for(i = 0; i < 320; i += speed)
        {
            speed++;
        }
        speed++;
        for(i = 0; i < 320; i += speed)
        {
            blit(gef_screen, screen_buffer, 0, 0, i, 0, SCREEN_W, SCREEN_H);
            draw_menu_screen(screen_buffer, i - 320, 0);
            speed--;

            cs_vsync();
            cs_screen_blit(screen_buffer, 0, 0);
        }
    }
}

/* switch to joystick menu */
void control_menu_joystick(void)
{
    current_menu = MENU_JCONTROL;
    cs_menu[MENU_JCONTROL].selected = 0;
}

/* scan the key array for a pressed key (so all keys can be used) */
int get_key_all(void)
{
	int i;

	for(i = 0; i < KEY_MAX; i++)
	{
		key[i] = 0;
	}
	while(1)
	{
		for(i = 0; i < KEY_MAX; i++)
		{
			if(key[i])
			{
				key[i] = 0;
				return i;
			}
		}
	}
}

/* let user select a new key for currently selected event */
void customize_controls(void)
{
    int new_key;

    /* so the drawing code knows what to draw */
    cc_flag = cs_menu[current_menu].selected;

    /* temporarily replace the subtitle text */
    strcpy(cc_temp, cs_menu[current_menu].item[cs_menu[current_menu].selected].sub_text);
    strcpy(cs_menu[current_menu].item[cs_menu[current_menu].selected].sub_text, "Select New Key (ESC Cancel)");

    /* update the screen */
    update_menu_screen();

    /* get ready to read user key */
    clear_keybuf();

    /* read the key */
//    new_key = readkey() >> 8;
    new_key = get_key_all();

    /* make sure user didn't want to cancel */
    if(new_key != KEY_ESC)
    {
        t3ss_play_sound(cs_sound[SOUND_MENU_TYPE], 128, 22050);

        /* change the controls as desired */
        if(cs_menu[current_menu].selected == 0)
        {
            cs_controls[0].left = new_key;
        }
        if(cs_menu[current_menu].selected == 1)
        {
            cs_controls[0].right = new_key;
        }
        if(cs_menu[current_menu].selected == 2)
        {
            cs_controls[0].drop = new_key;
        }
        if(cs_menu[current_menu].selected == 3)
        {
            cs_controls[0].rup = new_key;
        }
        if(cs_menu[current_menu].selected == 4)
        {
            cs_controls[0].rdown = new_key;
        }
        if(cs_menu[current_menu].selected == 5)
        {
            cs_controls[1].left = new_key;
        }
        if(cs_menu[current_menu].selected == 6)
        {
            cs_controls[1].right = new_key;
        }
        if(cs_menu[current_menu].selected == 7)
        {
            cs_controls[1].drop = new_key;
        }
        if(cs_menu[current_menu].selected == 8)
        {
            cs_controls[1].rup = new_key;
        }
        if(cs_menu[current_menu].selected == 9)
        {
            cs_controls[1].rdown = new_key;
        }
    }

    /* user cancelled */
    else
    {
        t3ss_play_sound(cs_sound[SOUND_MENU_BACK], 128, 22050);
    }

    /* for the drawing code */
    cc_flag = -1;

    /* change the subtitle text back */
    strcpy(cs_menu[current_menu].item[cs_menu[current_menu].selected].sub_text, cc_temp);
}

/* switch to scores menu */
void main_menu_scores(void)
{
    current_menu = MENU_SCORES;
    cs_menu[MENU_SCORES].selected = 0;
}

/* switch to destroyer scores menu */
void scores_menu_destroyer(void)
{
    current_menu = MENU_DSCORES;
    cs_menu[MENU_DSCORES].selected = 0;
}

/* switch to frenzy scores menu */
void scores_menu_frenzy(void)
{
    current_menu = MENU_FSCORES;
    cs_menu[MENU_FSCORES].selected = 0;
}

/* switch to play menu */
void main_menu_play(void)
{
    current_menu = MENU_PLAY;
    cs_menu[MENU_PLAY].selected = 0;
}

/* switch to 1 player menu */
void play_menu_1p(void)
{
    current_menu = MENU_1PLAY;
    cs_menu[MENU_1PLAY].selected = 0;
}

/* switch to 1 player classic menu */
void play_menu_1p_classic(void)
{
    current_menu = MENU_1PLAYC;
    cs_menu[MENU_1PLAYC].selected = 0;
    cs_game_mode = CS_1NS;
}

/* switch to 1 player destroyer menu */
void play_menu_1p_destroyer(void)
{
    current_menu = MENU_1PLAYD;
    cs_menu[MENU_1PLAYD].selected = 0;
    cs_game_mode = CS_1TD;
}

/* switch to 1 player frenzy menu */
void play_menu_1p_frenzy(void)
{
    current_menu = MENU_1PLAYF;
    cs_menu[MENU_1PLAYF].selected = 0;
    cs_game_mode = CS_1TF;
}

/* switch to 2 player menu */
void play_menu_2p(void)
{
    current_menu = MENU_2PLAY;
    cs_menu[MENU_2PLAY].selected = 0;
}

/* switch to 2 player normal menu */
void play_menu_2pn(void)
{
    current_menu = MENU_2PLAYN;
    cs_menu[MENU_2PLAYN].selected = 0;
}

/* switch to 2 player normal top score menu */
void menu_2pn_top_score(void)
{
    current_menu = MENU_2PLAYNS;
    cs_menu[MENU_2PLAYNS].selected = 0;
    cs_game_mode = CS_2NS;
}

/* switch to 2 player normal last out menu */
void menu_2pn_last_out(void)
{
    current_menu = MENU_2PLAYNL;
    cs_menu[MENU_2PLAYNL].selected = 0;
    cs_game_mode = CS_2NL;
}

/* switch to 2 player normal destroyer menu */
void menu_2pn_destroyer(void)
{
    current_menu = MENU_2PLAYND;
    cs_menu[MENU_2PLAYND].selected = 0;
    cs_game_mode = CS_2ND;
}

/* switch to 2 player battle menu */
void play_menu_2pb(void)
{
    current_menu = MENU_2PLAYB;
    cs_menu[MENU_2PLAYB].selected = 0;
}

/* switch to 2 player battle top score menu */
void menu_2pb_top_score(void)
{
    current_menu = MENU_2PLAYBS;
    cs_menu[MENU_2PLAYBS].selected = 0;
    cs_game_mode = CS_2BS;
}

/* switch to 2 player battle last out menu */
void menu_2pb_last_out(void)
{
    current_menu = MENU_2PLAYBL;
    cs_menu[MENU_2PLAYBL].selected = 0;
    cs_game_mode = CS_2BL;
}

/* switch to 2 player battle destroyer menu */
void menu_2pb_destroyer(void)
{
    current_menu = MENU_2PLAYBD;
    cs_menu[MENU_2PLAYBD].selected = 0;
    cs_game_mode = CS_2BD;
}

/* switch to options menu */
void main_menu_options(void)
{
    current_menu = MENU_OPTIONS;
    cs_menu[MENU_OPTIONS].selected = 0;
}

/* switch to audio options menu */
void options_menu_audio(void)
{
    current_menu = MENU_AUDIO;
    cs_menu[MENU_AUDIO].selected = 0;
}

/* switch to game options menu */
void options_menu_game(void)
{
    current_menu = MENU_GAME;
    cs_menu[MENU_GAME].selected = 0;
}

/* switch to graphics options menu */
void options_menu_graphics(void)
{
    current_menu = MENU_GRAPHICS;
    cs_menu[MENU_GRAPHICS].selected = 0;
}

/* switch to control options menu */
void main_menu_control(void)
{
    current_menu = MENU_CONTROL;
    cs_menu[MENU_CONTROL].selected = 0;
}

void menu_sound_volume_left_proc(void)
{
    cs_options.sound_volume--;
    if(cs_options.sound_volume < 0)
    {
        cs_options.sound_volume = 0;
    }
    t3ss_set_sound_volume(cs_options.sound_volume);
}

void menu_sound_volume_right_proc(void)
{
    cs_options.sound_volume++;
    if(cs_options.sound_volume > 100)
    {
        cs_options.sound_volume = 100;
    }
    t3ss_set_sound_volume(cs_options.sound_volume);
}

void menu_music_volume_left_proc(void)
{
    cs_options.music_volume--;
    if(cs_options.music_volume < 0)
    {
        cs_options.music_volume = 0;
    }
    t3ss_set_music_volume(cs_options.music_volume);
}

void menu_music_volume_right_proc(void)
{
    cs_options.music_volume++;
    if(cs_options.music_volume > 100)
    {
        cs_options.music_volume = 100;
    }
    t3ss_set_music_volume(cs_options.music_volume);
}

void menu_sound_quality_left_proc(void)
{
    if(cs_options.sound_quality > 0)
    {
        cs_options.sound_quality--;
    }
}

void menu_sound_quality_right_proc(void)
{
    if(cs_options.sound_quality < 4)
    {
        cs_options.sound_quality++;
    }
}

void menu_stereo_left_proc(void)
{
    if(cs_options.stereo > 0)
    {
        cs_options.stereo--;
    }
}

void menu_stereo_right_proc(void)
{
    if(cs_options.stereo < 2)
    {
        cs_options.stereo++;
    }
}

void menu_joystick_toggle(void)
{
    if(cs_options.joystick == 1)
    {
        cs_options.joystick = 0;
        ncd_joy_remove();
    }
    else
    {
        cs_options.joystick = 1;
        ncd_joy_install();
    }
}

void menu_wild_card_toggle(void)
{
    if(cs_options.wild_card == 1)
    {
        cs_options.wild_card = 0;
    }
    else
    {
        cs_options.wild_card = 1;
    }
}

void menu_bomb_toggle(void)
{
    if(cs_options.bomb == 1)
    {
        cs_options.bomb = 0;
    }
    else
    {
        cs_options.bomb = 1;
    }
}

void menu_effects_toggle(void)
{
    if(cs_options.effects == 1)
    {
        cs_options.effects = 0;
    }
    else
    {
        cs_options.effects = 1;
    }
}

void menu_transitions_toggle(void)
{
    if(cs_options.transitions == 1)
    {
        cs_options.transitions = 0;
    }
    else
    {
        cs_options.transitions = 1;
    }
}

void menu_vsync_toggle(void)
{
    if(cs_options.vsync == 1)
    {
        cs_options.vsync = 0;
    }
    else
    {
        cs_options.vsync = 1;
    }
}

void menu_screen_mode_left_proc(void)
{
    #ifdef __BEOS__

        if(cs_screen_mode > 1)
        {
            cs_screen_mode--;
            cs_gfx_mode_force(320, 240, screen_palette);
        }

    #else

        if(cs_screen_mode > 0)
        {
            cs_screen_mode--;
            cs_gfx_mode_force(320, 240, screen_palette);
        }

    #endif
}

void menu_screen_mode_right_proc(void)
{
    if(cs_screen_mode < 2)
    {
        cs_screen_mode++;
        cs_gfx_mode_force(320, 240, screen_palette);
    }
}

void menu_level_left_proc(void)
{
    if(cs_options.level > 0)
    {
        cs_options.level--;
    }
}

void menu_level_right_proc(void)
{
    if(cs_options.level < 9)
    {
        cs_options.level++;
    }
}

void menu_blocks_left_proc(void)
{
    if(cs_options.block_index > 0)
    {
        cs_options.block_index--;
    }
}

void menu_blocks_right_proc(void)
{
    if(cs_options.block_index < 9)
    {
        cs_options.block_index++;
    }
}

void menu_time_left_proc(void)
{
    if(cs_options.time_index > 0)
    {
        cs_options.time_index--;
    }
}

void menu_time_right_proc(void)
{
    if(cs_options.time_index < 9)
    {
        cs_options.time_index++;
    }
}

void menu_play_proc(void)
{
    /* if 1 player, do the pixelize effect */
    if(cs_game_mode < CS_2NS)
    {
        if(cs_options.transitions)
        {
            t3ss_play_sound(cs_sound[SOUND_FADE_OUT], 128, 22050);
            gef_pixelize_out(screen_buffer);
        }
        else
        {
            fade_out(3);
        }
    }

    /* otherwise do the splitting effect */
    else
    {
        if(cs_options.transitions)
        {
            t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
            gef_split_out_horizontal(screen_buffer);
        }
        else
        {
            fade_out(3);
        }
    }
    t3ss_stop_mod();

    /* play the game */
    cs_play(cs_game_mode);
}

/* select a new theme */
void select_theme(void)
{
#ifndef T3SS_PTHREADS
    t3ss_pause_music();
#endif	
    file_select_ex("Select theme file...", cs_options.theme_name, "CTH", 256, 320, 240);
#ifndef T3SS_PTHREADS
    t3ss_resume_music();
#endif
    update_theme_filenames(cs_options.theme_name);
    update_menu_screen();
    while((key[KEY_ESC] || key[KEY_ENTER] || key[KEY_SPACE]));
}
