#include "includes.h"
#include "externs.h"

CREDIT_LIST credits;

/* builds the credits list */
void build_credit_list(void)
{
    clear_credit_list(&credits);

    add_credit(&credits, "Game Idea");
    add_name(&credits, "The creator of Columns");

    add_credit(&credits, "Game Title");
    add_name(&credits, "Travis Cope");

    add_credit(&credits, "Support");
    add_name(&credits, "Terry Cope");
    add_name(&credits, "Travis Cope");

    add_credit(&credits, "Game Design");
    add_name(&credits, "Todd Cope");

    add_credit(&credits, "Programming");
    add_name(&credits, "Todd Cope");

    /* additional platform ports */
    add_credit(&credits, "BeOS Port");
    add_name(&credits, "Eugenia Loli-Queru");
    add_credit(&credits, "Linux Port");
    add_name(&credits, "Hans de Goede");

    add_credit(&credits, "Graphics");
    add_name(&credits, "Todd Cope");

    add_credit(&credits, "Music and Sound");
    add_name(&credits, "Todd Cope");

    add_credit(&credits, "Base Library");
    add_name(&credits, "Allegro");

    add_credit(&credits, "Sound Engine");
    add_name(&credits, "DUMB");

    add_credit(&credits, "Sound Tools");
    add_name(&credits, "FM Dreams");
    add_name(&credits, "GoldWave");
    add_name(&credits, "Fasttracker 2");

    add_credit(&credits, "Graphics Tools");
    add_name(&credits, "Neopaint");
    add_name(&credits, "Paint Shop Pro 7");

    add_credit(&credits, "Programming Tools");
    #ifdef ALLEGRO_WINDOWS
        add_name(&credits, "MinGW32");
    #elif defined(ALLEGRO_UNIX)
        add_name(&credits, "GCC");
    #else
        add_name(&credits, "DJGPP");
    #endif
    add_name(&credits, "Microsoft Edit");
    add_name(&credits, "Crimson Editor");

    add_credit(&credits, "Other Tools");
    add_name(&credits, "Allegro Grabber");
    add_name(&credits, "PowerArchiver");
    add_name(&credits, "Inno Setup");

    add_credit(&credits, "Testing");
    add_name(&credits, "Todd Cope");
    add_name(&credits, "Travis Cope");
    add_name(&credits, "Terry Cope");
    add_name(&credits, "Alex Cope");
    add_name(&credits, "Greg Brotzge");
    add_name(&credits, "Jason May");

    add_credit(&credits, "Thanks");
    add_name(&credits, "Allegro.CC Community");

    add_credit(&credits, "Special Thanks");
    add_name(&credits, "Jesus Christ");

    credits.title_font = &cs_big_menu_font;
    credits.name_font = &cs_big_menu_font_green;
}

/* show credits */
void show_credits(void)
{
    int i;
    int speed = 1;

    /* do the screen scooting effect if transitions are on */
    if(cs_options.transitions)
    {
        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);

        /* set up the speed */
        for(i = 0; i < 320; i += speed)
        {
            speed++;
        }
        speed++;

        /* do the effect */
        for(i = 0; i < 320; i += speed)
        {
            draw_menu_screen(screen_buffer, i, 0);
            blit(cs_menu_bg_image, screen_buffer, 0, 0, i - 320, 0, SCREEN_W, SCREEN_H);
            speed--;

            cs_vsync();
            cs_screen_blit(screen_buffer, 0, 0);
        }
    }

    /* do the credits */
    build_credit_list();
    do_credits(&credits);

    /* do the screen scooting effect if transitions are on */
    speed = 1;
    if(cs_options.transitions)
    {
        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);

        /* set up the speed */
        for(i = 0; i < 320; i += speed)
        {
            speed++;
        }
        speed++;

        /* do the effect */
        for(i = 320; i >= 0; i -= speed)
        {
            draw_menu_screen(screen_buffer, i, 0);
            blit(cs_menu_bg_image, screen_buffer, 0, 0, i - 320, 0, SCREEN_W, SCREEN_H);
            speed--;

            cs_vsync();
            cs_screen_blit(screen_buffer, 0, 0);
        }
    }
}
