#include "includes.h"
#include "externs.h"

/* sets up video and memory areas for use by the game */
int initialize_game(CS_GAME * gp, CS_THEME * tp, int Player, int GameMode, int Difficulty, int StartLevel)
{
    int i, j;

    gp->player = Player;

    /* set game options */
    gp->mode = GameMode;
    gp->level = StartLevel;
    gp->drop_time = level_chart[gp->level - 1];
    drop_amount[gp->player] = 0;

    /* initialize other variables */
    gp->score = 0;

    gp->counter = 0;
    gp->state = STATE_NORMAL;
    gp->removed = 0;
    gp->power = 0;
    gp->total_removed = 0;

    initialize_message_list(&gp->messages, tp->font.w);

    /* allocate memory for each players board data */
    gp->board = malloc(tp->board_w * (tp->board_h + STACK_HEIGHT));
    if(gp->board == NULL)
    {
        return 0; /* return 0 if couldn't allocate */
    }
    /* allocate memory for each players run data */
    gp->runs = malloc(tp->board_w * (tp->board_h + STACK_HEIGHT));
    if(gp->runs == NULL)
    {
        return 0; /* return 0 if couldn't allocate */
    }
    /* allocate memory for each players board buffer */
    gp->board_screen = create_sub_bitmap(tp->screen, tp->board_x[gp->player], tp->board_y[gp->player], tp->block_w * tp->board_w, tp->block_h * tp->board_h);
    if(gp->board_screen == NULL)
    {
        return 0; /* return 0 if couldn't allocate */
    }
    for(i = 0; i < tp->board_h + STACK_HEIGHT; i++)
    {
        for(j = 0; j < tp->board_w; j++)
        {
            gp->board[i * tp->board_w + j] = 0;
            gp->runs[i * tp->board_w + j] = 0;
        }
    }

    gp->runs_left = 0;
    core_generate_stack(gp, tp);
    core_copy_stack(gp);
    core_generate_stack(gp, tp);
    gp->stack.active = 1;
    gp->wild_count = 0;

    return 1;
}

/* free game stuff from memory */
void destroy_game(CS_GAME * gp)
{
    free(gp->board);
    free(gp->runs);
    destroy_bitmap(gp->board_screen);
}
