/* module for the 2 player normal last out mode */

#include "includes.h"
#include "externs.h"

/* initialize the game to normal 1 player mode */
void initialize_2pn_last_out(void)
{
    cs_initialize_theme(&cs_theme);
    initialize_game(&cs_game[0], &cs_theme, 0, CS_2NL, 0, cs_options.level + 1);
    initialize_game(&cs_game[1], &cs_theme, 1, CS_2NL, 0, cs_options.level + 1);
    initialize_effect_blocks(&cs_effects_blocks);
    reset_clock(0, 0);
    game_quit = 0;
}

/* ready to exit game */
void exit_2pn_last_out(void)
{
    destroy_game(&cs_game[0]);
    destroy_game(&cs_game[1]);
}

/* redraw screen */
void refresh_2pn_last_out(void)
{
    draw_bg();
    draw_game_paused(&cs_game[0], &cs_theme, &cs_clock);
    draw_game_paused(&cs_game[1], &cs_theme, &cs_clock);

    /* do transition */
    if(cs_options.transitions)
    {
        clear(screen);
        set_palette(cs_theme.palette);
        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
        gef_split_in_vertical(cs_theme.screen);
    }
    else
    {
        cs_screen_blit(cs_theme.screen, 0, 0);
        fade_in(cs_theme.palette, 3);
    }
}

void play_2pn_last_out(void)
{
    /* get ready */
    initialize_2pn_last_out();
    refresh_2pn_last_out();
    game_count_down();

    /* start game */
    install_normal_clock();
    install_int(core_drop_stack0, cs_game[0].drop_time);
    install_int(core_drop_stack1, cs_game[1].drop_time);
    while(!game_quit && !(cs_game[0].state == STATE_GAMEOVER || cs_game[1].state == STATE_GAMEOVER))
    {
        if(key[KEY_ESC])
        {
            try_quit();
        }

        /* move everything */
        cs_read_controls();
        core_game_step_normal(&cs_game[0], &cs_theme);
        core_game_step_normal(&cs_game[1], &cs_theme);
        if(cs_options.effects)
        {
            move_effect_blocks(&cs_theme, &cs_effects_blocks);
        }

        /* draw everything in memory */
        draw_bg();
        draw_game(&cs_game[0], &cs_theme, &cs_clock);
        draw_game(&cs_game[1], &cs_theme, &cs_clock);
        if(cs_options.effects)
        {
            draw_effect_blocks(&cs_theme, &cs_effects_blocks);
        }

        /* copy buffer to screen */
        cs_vsync();
        cs_screen_blit(cs_theme.screen, 0, 0);
    }

    /* stop game */
    remove_normal_clock();
    remove_int(core_drop_stack0);
    remove_int(core_drop_stack1);
    game_over();

    /* ready to exit */
    t3ss_stop_mod();
    if(cs_options.transitions)
    {
        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
        gef_split_out_vertical(cs_theme.screen);
    }
    else
    {
        fade_out(3);
    }
    exit_2pn_last_out();
}
