/* module for the 1 player classic mode */

#include "includes.h"
#include "externs.h"

/* initialize the game to normal 1 player mode */
void initialize_1p_classic(void)
{
    cs_initialize_theme(&cs_theme);
    initialize_game(&cs_game[0], &cs_theme, 0, CS_1NS, 0, cs_options.level + 1);
    initialize_effect_blocks(&cs_effects_blocks);
    reset_clock(0, 0);
    game_quit = 0;
    beat_score = 0;
}

/* ready to exit game */
void exit_1p_classic(void)
{
    destroy_game(&cs_game[0]);
}

/* redraw the screen before game start */
void refresh_1p_classic(void)
{
    draw_bg();
    draw_game_paused(&cs_game[0], &cs_theme, &cs_clock);

    /* do transition if we're supposed to */
    if(cs_options.transitions)
    {
        clear(screen);
        set_palette(cs_theme.palette);
        t3ss_play_sound(cs_sound[SOUND_FADE_IN], 128, 22050);
        gef_pixelize_in(cs_theme.screen);
    }
    else
    {
        cs_screen_blit(cs_theme.screen, 0, 0);
        fade_in(cs_theme.palette, 3);
    }
}

/* play 1 player classic mode */
void play_1p_classic(void)
{
    /* get things ready */
    initialize_1p_classic();
    refresh_1p_classic();
    game_count_down();

    /* start the game up */
    install_normal_clock();
    install_int(core_drop_stack0, cs_game[0].drop_time);
    while(!game_quit && cs_game[0].state != STATE_GAMEOVER)
    {
        if(key[KEY_ESC])
        {
            try_quit();
        }

        /* see if player beat the high score */
        if(cs_game[0].score >= cs_scores.classic_score[0] && !beat_score)
        {
            queue_message(&cs_game[0].messages, 2, "            You got the high score");
            beat_score = 1;
        }

        /* move everything */
        cs_read_controls();
        core_game_step_normal(&cs_game[0], &cs_theme);
        if(cs_options.effects)
        {
            move_effect_blocks(&cs_theme, &cs_effects_blocks);
        }

        /* draw everything in memory */
        draw_bg();
        draw_game(&cs_game[0], &cs_theme, &cs_clock);
        if(cs_options.effects)
        {
            draw_effect_blocks(&cs_theme, &cs_effects_blocks);
        }

        cs_vsync();
        cs_screen_blit(cs_theme.screen, 0, 0);
    }

    /* stop the game */
    remove_normal_clock();
    remove_int(core_drop_stack0);
    game_over();

    /* get ready to exit */
    t3ss_stop_mod();
    if(cs_options.transitions)
    {
        t3ss_play_sound(cs_sound[SOUND_FADE_OUT], 128, 22050);
        gef_pixelize_out(cs_theme.screen);
    }
    else
    {
        fade_out(3);
    }
    exit_1p_classic();
}
