#ifndef CS_H
#define CS_H

#include <allegro.h>


/* define the version number */
#define VERSION "Crystal Stacker version 1.5 (c) 2006 NewCreature Design.\n"


/* game mode definitions */
#define MAX_GAME_MODES    9
#define CS_1NS            0  /* normal game (go for high score) */
#define CS_1TD            1  /* time attack, destroyer (destroy x blocks) */
#define CS_1TF            2  /* time attack, frenzy (score points until time's up) */
#define CS_2NS            3  /* normal, score */
#define CS_2NL            4  /* normal, lastout */
#define CS_2ND            5  /* normal, destroyer */
#define CS_2BS            6  /* battle, score */
#define CS_2BL            7  /* battle, lastout */
#define CS_2BD            8  /* battle, destroyer */


/* screen mode definitions */
#define CS_FULL           0
#define CS_WIN            1
#define CS_WIN2           2


/* sound definitions for easy reading */
#define MAX_CS_SOUNDS    11
#define SOUND_MENU_MOVE   0
#define SOUND_MENU_ENTER  1
#define SOUND_MENU_CHANGE 2
#define SOUND_MENU_SWOOSH 3
#define SOUND_MENU_BACK   4
#define SOUND_MENU_TYPE   5
#define SOUND_GAME_STOP   6
#define SOUND_GAME_GO     7
#define SOUND_FADE_IN     8
#define SOUND_FADE_OUT    9
#define SOUND_ENTER_NAME 10


/* help functions used by other source files */
void cs_gfx_mode(int w, int h, PALETTE mpal);
void cs_gfx_mode_force(int w, int h, PALETTE mpal);
void cs_vsync(void);
void cs_exit(void);
void cs_screen_blit(BITMAP * bp, int x, int y);
void cs_fade_out(int speed);
void cs_fade_in(PALETTE pal, int speed);
void cs_play_mod(char * fn);
void cs_rest(int time);

void cs_read_controls(void);
void cs_play(int mode);
char *cs_get_config_file_name(char *suffix);

#endif
