/* time stuff */

#include "includes.h"
#include "externs.h"

/* adds 1 second to the clock (should be called each second) */
void clock_normal(void)
{
    cs_clock.seconds++;
    if(cs_clock.seconds > 59 && cs_clock.minutes < 99)
    {
        cs_clock.seconds = 0;
        cs_clock.minutes++;
    }
    else if(cs_clock.seconds > 59)
    {
        cs_clock.seconds = 59;
    }
}
END_OF_FUNCTION(clock_normal);

/* subtracts 1 second from the clock (should be called each second) */
void clock_count_down(void)
{
    cs_clock.seconds--;
    if(cs_clock.seconds < 0)
    {
        cs_clock.seconds = 59;
        cs_clock.minutes--;
        if(cs_clock.minutes < 0)
        {
            cs_clock.minutes = 0;
            cs_clock.seconds = 0;
        }
    }
}
END_OF_FUNCTION(clock_count_down);

/* set game clock to specified time */
void reset_clock(int Minutes, int Seconds)
{
    cs_clock.minutes = Minutes;
    cs_clock.seconds = Seconds;
}

/* installs DoTime timer */
void install_normal_clock(void)
{
    LOCK_FUNCTION(clock_normal);
    LOCK_VARIABLE(cs_clock);
    install_int(clock_normal, 1000);
}

/* installs CountDown timer */
void install_count_down_clock(void)
{
    LOCK_FUNCTION(clock_count_down);
    LOCK_VARIABLE(cs_clock);
    install_int(clock_count_down, 1000);
}

/* removes DoTime timer */
void remove_normal_clock(void)
{
    remove_int(clock_normal);
}

/* removes CountDown timer */
void remove_count_down_clock(void)
{
    remove_int(clock_count_down);
}

/* returns 0 if no time is left on the clock */
int time_left(void)
{
    return (cs_clock.minutes + cs_clock.seconds);
}
