#include "includes.h"


char * bg_button_label[2] = {"Tile Map", "Full Screen"};
char set_done = 0;


void set_init(void)
{
        int i;

        set_done = 0;

        ThemeSettings.c = GFX_AUTODETECT;
        ThemeSettings.rx = 320;
        ThemeSettings.ry = 200;
        ThemeSettings.fs = 8;
        ThemeSettings.bs = 10;
        ThemeSettings.bw = 6;
        ThemeSettings.bh = 14;
        ThemeSettings.tw = 20;
        ThemeSettings.th = 20;
        ThemeSettings.fullbg = 0;
        create_ncdfont(&ThemeSettings.tempfont, ThemeSettings.fs, ThemeSettings.fs);

        update_proc = set_update;

        for(i = 0; i < WINDOWS; i++)
        {
                deactivate_window(&Window[i]);
        }
        select_window(&Window[WINDOW_SETTINGS]);
        selected_window = WINDOW_SETTINGS;
        make_closest(ce_zbuffer, WINDOW_SETTINGS, WINDOWS);
        set_window_position(&Window[WINDOW_SETTINGS], 320 - Window[WINDOW_SETTINGS].w - 10, 100 - Window[WINDOW_SETTINGS].h / 2);
        activate_window(&Window[WINDOW_SETTINGS]);
        fade_out(3);
        update_proc();
        fade_in(ce_palette, 3);
}


void set_exit(void)
{
        destroy_ncdfont(&ThemeSettings.tempfont);

        fade_out(3);

        reset_ce();

        while(key[KEY_ESC]);

        update_proc();
        fade_in(ce_palette, 3);
}


void create_it(void)
{
        int i;

        /* destroy the old theme if needed */
        if(ThemeLoaded)

                DestroyTheme(&Theme);

        Theme.Header[0] = 'C';
        Theme.Header[1] = 'T';
        Theme.Header[2] = 'H';
        Theme.Header[3] = 21;

        Theme.Card = ThemeSettings.c;
        Theme.ResX = ThemeSettings.rx;
        Theme.ResY = ThemeSettings.ry;

        Theme.ScreenBuffer = create_bitmap(Theme.ResX, Theme.ResY);
        clear(Theme.ScreenBuffer);
        Theme.BGPic = create_bitmap(Theme.ResX, Theme.ResY);
        clear(Theme.BGPic);

        if(ThemeSettings.fullbg)
        {
                Theme.TileWidth = 0;
                Theme.TileHeight = 0;
                Theme.MapWidth = 0;
                Theme.MapHeight = 0;
        }
        else
        {
                /* initialize tiles */
                Theme.TileWidth = ThemeSettings.tw;
                Theme.TileHeight = ThemeSettings.th;
                for(i = 0; i < NUM_BG_TILES; i++)
                {
                        Theme.Tile[i] = create_bitmap(Theme.TileWidth, Theme.TileHeight);
                        clear(Theme.Tile[i]);
                }

                /* initialize map */
                Theme.MapWidth = Theme.ResX / Theme.TileWidth;
                Theme.MapHeight = Theme.ResY / Theme.TileHeight;
                Theme.BGMapData = malloc(Theme.MapWidth * Theme.MapHeight);
                for(i = 0; i < Theme.MapWidth * Theme.MapHeight; i++)

                        Theme.BGMapData[i] = 0;
        }
        for(i = 0; i < 256; i++)
        {
                Theme.Palette[i].r = ce_palette[i].r;
                Theme.Palette[i].g = ce_palette[i].g;
                Theme.Palette[i].b = ce_palette[i].b;
        }

        Theme.BlockWidth = ThemeSettings.bs;
        Theme.BlockHeight = ThemeSettings.bs;
        for(i = 0; i < NUM_BLOCK_TYPES; i++)
        {
                Theme.Block[i] = create_bitmap(Theme.BlockWidth, Theme.BlockHeight);
                clear(Theme.Block[i]);
                Theme.BlockErase[i] = create_bitmap(Theme.BlockWidth, Theme.BlockHeight);
                clear(Theme.BlockErase[i]);
        }

        Theme.BoardWidth = ThemeSettings.bw;
        Theme.BoardHeight = ThemeSettings.bh;

        create_ncdfont(&Theme.Font, ThemeSettings.fs, ThemeSettings.fs);

        for(i = 0; i < MAX_SOUNDS; i++)

                Theme.Sound[0] = NULL;

        ThemeLoaded = 1;
        set_done = 1;
}


void set_update(void)
{
        int i;

        /* update the settings window */
        blit(settings, Window[WINDOW_SETTINGS].dat.iw.image, 0, 0, 0, 0, settings->w, settings->h);
        textout_ex(Window[WINDOW_SETTINGS].dat.iw.image, font, "Display Settings", (Window[WINDOW_SETTINGS].w / 2) - (strlen("Display Settings") * 8) / 2, 1, Window[WINDOW_SETTINGS].fg, -1);
        textout_ex(Window[WINDOW_SETTINGS].dat.iw.image, font, bg_button_label[ThemeSettings.fullbg], (Window[WINDOW_SETTINGS].w / 2) - (strlen(bg_button_label[ThemeSettings.fullbg]) * 8) / 2, 11, Window[WINDOW_SETTINGS].fg, -1);
        textprintf_ex(Window[WINDOW_SETTINGS].dat.iw.image, font, 113, 31, -1, Window[WINDOW_SETTINGS].fg, "%2d", ThemeSettings.fs);
        textprintf_ex(Window[WINDOW_SETTINGS].dat.iw.image, font, 113, 51, -1, Window[WINDOW_SETTINGS].fg, "%2d", ThemeSettings.bs);
        if(ThemeSettings.fullbg)

                textprintf_ex(Window[WINDOW_SETTINGS].dat.iw.image, font, 89, 71, -1, Window[WINDOW_SETTINGS].fg, "%2dx%2d", 0, 0);

        else

                textprintf_ex(Window[WINDOW_SETTINGS].dat.iw.image, font, 89, 71, -1, Window[WINDOW_SETTINGS].fg, "%2dx%2d", ThemeSettings.tw, ThemeSettings.th);

        clear(screen_buffer);

        if(!ThemeSettings.fullbg)
        {
                for(i = 0; i < ThemeSettings.rx / ThemeSettings.tw; i++)
                {
                        line(screen_buffer, i * ThemeSettings.tw, 0, i * ThemeSettings.tw, ThemeSettings.ry - 1, 239);
                        line(screen_buffer, i * ThemeSettings.tw + ThemeSettings.tw - 1, 0, i * ThemeSettings.tw + ThemeSettings.tw - 1, ThemeSettings.ry - 1, 239);
                }
                for(i = 0; i < ThemeSettings.ry / ThemeSettings.th; i++)
                {
                        line(screen_buffer, 0, i * ThemeSettings.th, ThemeSettings.rx - 1, i * ThemeSettings.th, 239);
                        line(screen_buffer, 0, i * ThemeSettings.th + ThemeSettings.th - 1, ThemeSettings.rx - 1, i * ThemeSettings.th + ThemeSettings.th - 1, 239);
                }
        }

        for(i = 0; i < ThemeSettings.bw; i++)
        {
                line(screen_buffer, i * ThemeSettings.bs, 0, i * ThemeSettings.bs, ThemeSettings.bh * ThemeSettings.bs - 1, 236);
                line(screen_buffer, i * ThemeSettings.bs + ThemeSettings.bs - 1, 0, i * ThemeSettings.bs + ThemeSettings.bs - 1, ThemeSettings.bh * ThemeSettings.bs - 1, 236);
        }

        for(i = 0; i < ThemeSettings.bh; i++)
        {
                line(screen_buffer, 0, i * ThemeSettings.bs, ThemeSettings.bw * ThemeSettings.bs - 1, i * ThemeSettings.bs, 236);
                line(screen_buffer, 0, i * ThemeSettings.bs + ThemeSettings.bs - 1, ThemeSettings.bw * ThemeSettings.bs - 1, i * ThemeSettings.bs + ThemeSettings.bs - 1, 236);
        }

        rectfill(screen_buffer, 0, ThemeSettings.bh * ThemeSettings.bs, ThemeSettings.fs * 12 + 2, ThemeSettings.bh * ThemeSettings.bs + ThemeSettings.fs + 2, 0);
        rect(screen_buffer, 0, ThemeSettings.bh * ThemeSettings.bs, ThemeSettings.fs * 12 + 2, ThemeSettings.bh * ThemeSettings.bs + ThemeSettings.fs + 2, 228);
        ncd_textout(screen_buffer, &ThemeSettings.tempfont, 1, ThemeSettings.bh * ThemeSettings.bs + 1, "Font Preview");

        for(i = 0; i < WINDOWS; i++)

                draw_window(&Window[ce_zbuffer[i]], screen_buffer);

        draw_sprite(screen_buffer, cursor, mouse_x, mouse_y);

        vsync();
        blit(screen_buffer, screen, 0, 0, 0, 0, ThemeSettings.rx, ThemeSettings.ry);
}


void set_control(void)
{
        if(mouse_b & 1)
        {
                if(mouse_x > Window[WINDOW_SETTINGS].x && mouse_x < Window[WINDOW_SETTINGS].x + Window[WINDOW_SETTINGS].w && mouse_y > Window[WINDOW_SETTINGS].y + 10 && mouse_y <= Window[WINDOW_SETTINGS].y + 20)
                {
                        gui_bg_color = Window[selected_window].hbg;
                        gui_fg_color = Window[selected_window].hfg;
                        if(gfx_mode_select(&ThemeSettings.c, &ThemeSettings.rx, &ThemeSettings.ry))
                        {
                                destroy_bitmap(screen_buffer);
                                set_gfx_mode(GFX_AUTODETECT, ThemeSettings.rx, ThemeSettings.ry, ThemeSettings.rx, ThemeSettings.ry);
                                set_palette(ce_palette);
                                screen_buffer = create_bitmap(ThemeSettings.rx, ThemeSettings.ry);
                        }
                        while(key[KEY_ESC] || key[KEY_ENTER] || key[KEY_SPACE])
        
                        update_proc();
                }
                if(mouse_x > Window[WINDOW_SETTINGS].x && mouse_x < Window[WINDOW_SETTINGS].x + Window[WINDOW_SETTINGS].w && mouse_y > Window[WINDOW_SETTINGS].y + 20 && mouse_y <= Window[WINDOW_SETTINGS].y + 30)
                {
                        if(ThemeSettings.fullbg == 0)
        
                                ThemeSettings.fullbg = 1;
        
                        else
        
                                ThemeSettings.fullbg = 0;
                }
                if(mouse_x > Window[WINDOW_SETTINGS].x + 138 && mouse_x < Window[WINDOW_SETTINGS].x + 138 + 8 && mouse_y > Window[WINDOW_SETTINGS].y + 57 && mouse_y <= Window[WINDOW_SETTINGS].y + 64)
                {
                        ThemeSettings.bs++;
                }
                if(mouse_x > Window[WINDOW_SETTINGS].x + 138 && mouse_x < Window[WINDOW_SETTINGS].x + 138 + 8 && mouse_y > Window[WINDOW_SETTINGS].y + 65 && mouse_y <= Window[WINDOW_SETTINGS].y + 72)
                {
                        ThemeSettings.bs--;
                }
                if(mouse_x > Window[WINDOW_SETTINGS].x + 138 && mouse_x < Window[WINDOW_SETTINGS].x + 138 + 8 && mouse_y > Window[WINDOW_SETTINGS].y + 37 && mouse_y <= Window[WINDOW_SETTINGS].y + 44)
                {
                        ThemeSettings.fs++;
                        destroy_ncdfont(&ThemeSettings.tempfont);
                        create_ncdfont(&ThemeSettings.tempfont, ThemeSettings.fs, ThemeSettings.fs);
                }
                if(mouse_x > Window[WINDOW_SETTINGS].x + 138 && mouse_x < Window[WINDOW_SETTINGS].x + 138 + 8 && mouse_y > Window[WINDOW_SETTINGS].y + 45 && mouse_y <= Window[WINDOW_SETTINGS].y + 52)
                {
                        ThemeSettings.fs--;
                        destroy_ncdfont(&ThemeSettings.tempfont);
                        create_ncdfont(&ThemeSettings.tempfont, ThemeSettings.fs, ThemeSettings.fs);
                }
                if(!ThemeSettings.fullbg && mouse_x > Window[WINDOW_SETTINGS].x + 138 && mouse_x < Window[WINDOW_SETTINGS].x + 138 + 8 && mouse_y > Window[WINDOW_SETTINGS].y + 77 && mouse_y <= Window[WINDOW_SETTINGS].y + 84)
                {
                        ThemeSettings.th++;
                }
                if(!ThemeSettings.fullbg && mouse_x > Window[WINDOW_SETTINGS].x + 138 && mouse_x < Window[WINDOW_SETTINGS].x + 138 + 8 && mouse_y > Window[WINDOW_SETTINGS].y + 85 && mouse_y <= Window[WINDOW_SETTINGS].y + 92)
                {
                        ThemeSettings.th--;
                }
                if(!ThemeSettings.fullbg && mouse_x > Window[WINDOW_SETTINGS].x + 146 && mouse_x < Window[WINDOW_SETTINGS].x + 146 + 8 && mouse_y > Window[WINDOW_SETTINGS].y + 81 && mouse_y <= Window[WINDOW_SETTINGS].y + 88)
                {
                        ThemeSettings.tw--;
                }
                if(!ThemeSettings.fullbg && mouse_x > Window[WINDOW_SETTINGS].x + 155 && mouse_x < Window[WINDOW_SETTINGS].x + 155 + 8 && mouse_y > Window[WINDOW_SETTINGS].y + 81 && mouse_y <= Window[WINDOW_SETTINGS].y + 88)
                {
                        ThemeSettings.tw++;
                }
                if(mouse_x > Window[WINDOW_SETTINGS].x && mouse_x < Window[WINDOW_SETTINGS].x + Window[WINDOW_SETTINGS].w && mouse_y > Window[WINDOW_SETTINGS].y + 99 && mouse_y <= Window[WINDOW_SETTINGS].y + 109)
                {
                        create_it();
                }
                while(mouse_b & 1)

                        update_proc();
        }
}


void gui_new_theme(void)
{
        set_init();
        while(!key[KEY_ESC] && !set_done)
        {
                ce_control();
                set_control();
                update_proc();
        }
        set_exit();
}
