#include "includes.h"


/* initialize palette editor */
void pe_init(void)
{
        int i;

        fade_out(3);

        /* point update_proc to the right place */
        update_proc = pe_update;

        /* deactivate all the windows */
        for(i = 0; i < WINDOWS; i++)
        {
                deactivate_window(&Window[i]);
        }

        /* set up and activate file window */
        clear_menu(&Window[WINDOW_FILE]);
//        set_window_color(&Window[WINDOW_FILE], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
        add_menu_item(&Window[WINDOW_FILE], "Import", -1, pe_import);
        add_menu_item(&Window[WINDOW_FILE], "Export", -1, pe_export);
        add_menu_item(&Window[WINDOW_FILE], "Grab", -1, pe_grab);
        select_window(&Window[WINDOW_FILE]);
        selected_window = WINDOW_FILE;
        make_closest(ce_zbuffer, WINDOW_FILE, WINDOWS);
        set_window_position(&Window[WINDOW_FILE], screen_buffer->w - Window[WINDOW_FILE].w - 10, toolpic->h + 10);
        activate_window(&Window[WINDOW_FILE]);

        /* activate the editor windows */
        set_window_position(&Window[WINDOW_RGB], leftbar->w + 10, toolpic->h + 10);
        activate_window(&Window[WINDOW_RGB]);

        /* fade in */
        update_proc();
        fade_in(Theme.Palette, 3);

        edited = 1;
}


/* exit palette editor */
void pe_exit(void)
{
        /* fade in */
        fade_out(3);

        /* reset editor */
        reset_ce();

        update_proc();
        fade_in(ce_palette, 3);

        /* grab escape press */
        while(key[KEY_ESC])

                update_proc();
}


/* exports a loaded palette to a raw palette file */
void pe_export(void)
{
        int i;
        PACKFILE * WriteFile;
        char TempFileName[256];

        /* set file selector color */
        gui_bg_color = Window[selected_window].hbg;
        gui_fg_color = Window[selected_window].hfg;

        /* clear the filename and select file from list */
        memset(TempFileName, 0, 256);
        if(!file_select_ex("Enter palette filename...", TempFileName, "PAL", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        /* make sure that extension is .PAL */
        replace_extension(TempFileName, TempFileName, "PAL", 256);

        /* open the file */
        WriteFile = pack_fopen(TempFileName, "w");

        /* write the palette data */
        for(i = 0; i < 256; i++)
        {
                pack_putc(Theme.Palette[i].r, WriteFile);
                pack_putc(Theme.Palette[i].g, WriteFile);
                pack_putc(Theme.Palette[i].b, WriteFile);
        }

        /* close the file */
        pack_fclose(WriteFile);
}


/* imports a raw palette */
void pe_import(void)
{
        int i;
        PACKFILE * ReadFile;
        char TempFileName[256];

        /* set file selector color */
        gui_bg_color = Window[selected_window].hbg;
        gui_fg_color = Window[selected_window].hfg;

        /* choose file to open */
        memset(TempFileName, 0, 256);
        if(!file_select_ex("Choose palette file...", TempFileName, "PAL", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        /* open the file */
        ReadFile = pack_fopen(TempFileName, "r");

        /* read the palette data */
        for(i = 0; i < 256; i++)
        {
                Theme.Palette[i].r = pack_getc(ReadFile);
                Theme.Palette[i].g = pack_getc(ReadFile);
                Theme.Palette[i].b = pack_getc(ReadFile);
        }

        /* close the file */
        pack_fclose(ReadFile);

        /* set the new palette */
        set_palette(Theme.Palette);
        ce_convert();
}


/* grabs palette from PCX file */
void pe_grab(void)
{
        int i;
        char TempFileName[256];
        PALETTE TempPalette;
        BITMAP * TempBitmap;

        /* set file selector color */
        gui_bg_color = Window[selected_window].hbg;
        gui_fg_color = Window[selected_window].hfg;

        memset(TempFileName, 0, 256);
        if(!file_select_ex("Select file to grab from...", TempFileName, "PCX", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        /* load the bitmap and palette into temp buffers */
        TempBitmap = load_pcx(TempFileName, TempPalette);

        /* free the bitmap */
        destroy_bitmap(TempBitmap);

        /* copy the and set loaded palette */
        for(i = 0; i < 256; i++)
        {
                Theme.Palette[i].r = TempPalette[i].r;
                Theme.Palette[i].g = TempPalette[i].g;
                Theme.Palette[i].b = TempPalette[i].b;
        }
        set_palette(Theme.Palette);
        ce_convert();
}


/* only function the main menu system needs to use */
void edit_palette(void)
{
        pe_init();
        while(!key[KEY_ESC])
        {
                ce_control();
                pe_control();
                update_proc();
        }
        while(key[KEY_ESC]);
        pe_exit();
}


/* do controls specific to palette editor */
void pe_control(void)
{

        select_color();

        /* if user is clicking the left mouse button */
        if(mouse_b & 1)
        {

                /* move the RGB sliders when appropriate */
                if(selected_window == WINDOW_RGB)
                {
                        if(mouse_x > Window[WINDOW_RGB].x + 1 + 2 + 10 && mouse_x < Window[WINDOW_RGB].x + 1 + 3 + 64 + 10)
                        {
                                if(mouse_y > Window[WINDOW_RGB].y + 12 + 1 && mouse_y < Window[WINDOW_RGB].y + 12 + 1 + 6)
                                {
                                        Theme.Palette[left_color].r = mouse_x - Window[WINDOW_RGB].x - 1 - 3 - 10;
                                        set_palette(Theme.Palette);
                                        ce_convert();
                                }
                                else if(mouse_y > Window[WINDOW_RGB].y + 12 + 10 && mouse_y < Window[WINDOW_RGB].y + 12 + 10 + 6)
                                {
                                        Theme.Palette[left_color].g = mouse_x - Window[WINDOW_RGB].x - 1 - 3 - 10;
                                        set_palette(Theme.Palette);
                                        ce_convert();
                                }
                                else if(mouse_y > Window[WINDOW_RGB].y + 12 + 19 && mouse_y < Window[WINDOW_RGB].y + 12 + 19 + 6)
                                {
                                        Theme.Palette[left_color].b = mouse_x - Window[WINDOW_RGB].x - 1 - 3 - 10;
                                        set_palette(Theme.Palette);
                                        ce_convert();
                                }
                        }
                }
        }

        /* copy selected color to the clipboard */
        if(key[KEY_C])

                copy_color = left_color;

        /* past clipboard to selected color */
        if(key[KEY_P])
        {
                Theme.Palette[left_color].r = Theme.Palette[copy_color].r;
                Theme.Palette[left_color].g = Theme.Palette[copy_color].g;
                Theme.Palette[left_color].b = Theme.Palette[copy_color].b;
                set_palette(Theme.Palette);
                ce_convert();
        }
}


/* update palette editor windows */
void pe_update(void)
{
        /* update the RGB editor window */
        blit(rgb, Window[WINDOW_RGB].dat.iw.image, 0, 0, 0, 0, Window[WINDOW_RGB].dat.iw.image->w, Window[WINDOW_RGB].dat.iw.image->h);
        masked_blit(slider, Window[WINDOW_RGB].dat.iw.image, 0, 0, 2 + 10 + Theme.Palette[left_color].r, 3, Window[WINDOW_RGB].dat.iw.image->w, Window[WINDOW_RGB].dat.iw.image->h); 
        masked_blit(slider, Window[WINDOW_RGB].dat.iw.image, 0, 0, 2 + 10 + Theme.Palette[left_color].g, 12, Window[WINDOW_RGB].dat.iw.image->w, Window[WINDOW_RGB].dat.iw.image->h); 
        masked_blit(slider, Window[WINDOW_RGB].dat.iw.image, 0, 0, 2 + 10 + Theme.Palette[left_color].b, 21, Window[WINDOW_RGB].dat.iw.image->w, Window[WINDOW_RGB].dat.iw.image->h); 

        /* update the color display window */
        floodfill(Window[WINDOW_RGB].dat.iw.image, 94, 14, left_color);

        redraw_gui_edit();
}
