#include <allegro.h>

void DoReplace(BITMAP * bp, int x, int y, int c)
{
    int i, j, oc;

    oc = bp->line[y][x];
    for(i = 0; i < bp->h; i++)
    {
        for(j = 0; j < bp->w; j++)
        {
            if(bp->line[i][j] == oc)
            {
                bp->line[i][j] = c;
            }
        }
    }
}

void DoBrush(BITMAP * bp, int x, int y, int c)
{
    bp->line[y][x] = c;
}

int DoDropper(BITMAP * bp, int x, int y)
{
    return bp->line[y][x];
}

void DoErase(BITMAP * bp, int c)
{
    int i, j;

    for(i = 0; i < bp->h; i++)
    {
        for(j = 0; j < bp->w; j++)
        {
            bp->line[i][j] = c;
        }
    }
}

void DoFill(BITMAP * bp, int x, int y, int c)
{
    floodfill(bp, x, y, c);
}

void DoLine(BITMAP * bp, int b, int x, int y, int dx, int dy, int s, int c, void (*proc)())
{
    int px = (mouse_x - dx) / s;
    int py = (mouse_y - dy) / s;
    BITMAP * cbp = create_bitmap(bp->w, bp->h);

    blit(bp, cbp, 0, 0, 0, 0, bp->w, bp->h);
    while(mouse_b & b)
    {
        blit(cbp, bp, 0, 0, 0, 0, bp->w, bp->h);
        line(bp, px, py, (mouse_x - dx) / s, (mouse_y - dy) / s, c);
        proc();
    }
    destroy_bitmap(cbp);
}

void DoRect(BITMAP * bp, int b, int x, int y, int dx, int dy, int s, int c, void (*proc)())
{
    int px = (mouse_x - dx) / s;
    int py = (mouse_y - dy) / s;
    BITMAP * cbp = create_bitmap(bp->w, bp->h);

    blit(bp, cbp, 0, 0, 0, 0, bp->w, bp->h);
    while(mouse_b & b)
    {
        blit(cbp, bp, 0, 0, 0, 0, bp->w, bp->h);
        rect(bp, px, py, (mouse_x - dx) / s, (mouse_y - dy) / s, c);
        proc();
    }
    destroy_bitmap(cbp);
}

void DoFRect(BITMAP * bp, int b, int x, int y, int dx, int dy, int s, int c, void (*proc)())
{
    int px = (mouse_x - dx) / s;
    int py = (mouse_y - dy) / s;
    BITMAP * cbp = create_bitmap(bp->w, bp->h);

    blit(bp, cbp, 0, 0, 0, 0, bp->w, bp->h);
    while(mouse_b & b)
    {
        blit(cbp, bp, 0, 0, 0, 0, bp->w, bp->h);
        rectfill(bp, px, py, (mouse_x - dx) / s, (mouse_y - dy) / s, c);
        proc();
    }
    destroy_bitmap(cbp);
}

void DoCircle(BITMAP * bp, int b, int x, int y, int dx, int dy, int s, int c, void (*proc)())
{
    int px = (mouse_x - dx) / s;
    int py = (mouse_y - dy) / s;
    int nx, ny;
    BITMAP * cbp = create_bitmap(bp->w, bp->h);

    blit(bp, cbp, 0, 0, 0, 0, bp->w, bp->h);
    while(mouse_b & b)
    {
        nx = (mouse_x - dx) / s - px;
        ny = (mouse_y - dy) / s - py;
        blit(cbp, bp, 0, 0, 0, 0, bp->w, bp->h);
        if(nx != 0 && ny != 0)
        {
            if(nx / 2 == ny / 2)
            {
                circle(bp, nx / 2 + px, ny / 2 + py, nx < 0 ? -nx / 2 : nx / 2, c);
            }
            else
            {
                ellipse(bp, nx / 2 + px, ny / 2 + py, nx < 0 ? -nx / 2 : nx / 2, ny < 0 ? -ny / 2 : ny / 2, c);
            }
        }
        proc();
    }
    destroy_bitmap(cbp);
}

void DoFCircle(BITMAP * bp, int b, int x, int y, int dx, int dy, int s, int c, void (*proc)())
{
    int px = (mouse_x - dx) / s;
    int py = (mouse_y - dy) / s;
    int nx, ny;
    BITMAP * cbp = create_bitmap(bp->w, bp->h);

    blit(bp, cbp, 0, 0, 0, 0, bp->w, bp->h);
    while(mouse_b & b)
    {
        nx = (mouse_x - dx) / s - px;
        ny = (mouse_y - dy) / s - py;
        blit(cbp, bp, 0, 0, 0, 0, bp->w, bp->h);
        if(nx != 0 && ny != 0)
        {
            if(nx / 2 == ny / 2)
            {
                circlefill(bp, nx / 2 + px, ny / 2 + py, nx < 0 ? -nx / 2 : nx / 2, c);
            }
            else
            {
                ellipsefill(bp, nx / 2 + px, ny / 2 + py, nx < 0 ? -nx / 2 : nx / 2, ny < 0 ? -ny / 2 : ny / 2, c);
            }
        }
        proc();
    }
    destroy_bitmap(cbp);
}
