#include "includes.h"

void initialize_tools(void)
{
//        toolpic = load_pcx("grtools.pcx", NULL, 0);
//        tool[0] = load_pcx("gt0.pcx", NULL, 0);
//        tool[1] = load_pcx("gt1.pcx", NULL, 0);
//        tool[2] = load_pcx("gt2.pcx", NULL, 0);
//        tool[3] = load_pcx("gt3.pcx", NULL, 0);
//        tool[4] = load_pcx("gt4.pcx", NULL, 0);
//        tool[5] = load_pcx("gt5.pcx", NULL, 0);
//        tool[6] = load_pcx("gt6.pcx", NULL, 0);
//        tool[7] = load_pcx("gt7.pcx", NULL, 0);
//        tool[8] = load_pcx("gt8.pcx", NULL, 0);
//        tool[9] = load_pcx("gt9.pcx", NULL, 0);
//        leftbar = load_pcx("ptools.pcx", NULL, 0);
        toolpic = load_pcx(DATADIR "ce.dat#grt", NULL);
        tool[0] = load_pcx(DATADIR "ce.dat#grt0", NULL);
        tool[1] = load_pcx(DATADIR "ce.dat#grt1", NULL);
        tool[2] = load_pcx(DATADIR "ce.dat#grt2", NULL);
        tool[3] = load_pcx(DATADIR "ce.dat#grt3", NULL);
        tool[4] = load_pcx(DATADIR "ce.dat#grt4", NULL);
        tool[5] = load_pcx(DATADIR "ce.dat#grt5", NULL);
        tool[6] = load_pcx(DATADIR "ce.dat#grt6", NULL);
        tool[7] = load_pcx(DATADIR "ce.dat#grt7", NULL);
        tool[8] = load_pcx(DATADIR "ce.dat#grt8", NULL);
        tool[9] = load_pcx(DATADIR "ce.dat#grt9", NULL);
        leftbar = load_pcx(DATADIR "ce.dat#pal_tools", NULL);
}

void remove_tools(void)
{
        int i;

        destroy_bitmap(toolpic);

        for(i = 0; i < TOTAL_TOOLS; i++)

                destroy_bitmap(tool[i]);

        destroy_bitmap(leftbar);
}

void draw_palette(void)
{
        int i, j, k;

        for(i = 0; i < 256; i++)

                for(j = 0; j < PALETTE_SCALE; j++)

                        for(k = 0; k < PALETTE_SCALE; k++)

                                putpixel(screen_buffer, (i / 32) * PALETTE_SCALE + k + 3, (i % 32) * PALETTE_SCALE + j + 43, i);

}

void draw_tools(void)
{
        blit(toolpic, screen_buffer, 0, 0, 0, 0, screen_buffer->w, screen_buffer->h);
        blit(tool[selected_tool], screen_buffer, 0, 0, 0, 0, screen_buffer->w, screen_buffer->h);
        blit(leftbar, screen_buffer, 0, 0, 0, toolpic->h, screen_buffer->w, screen_buffer->h);
        floodfill(screen_buffer, 4, toolpic->h + 4, left_color);
        floodfill(screen_buffer, 4 + 4 * PALETTE_SCALE, toolpic->h + 4, right_color);
        draw_palette();
        putpixel(screen_buffer, 3 + (left_color / 32) * PALETTE_SCALE + 1, 43 + (left_color % 32) * PALETTE_SCALE + 1, Window[WINDOW_FILE].bg);
        putpixel(screen_buffer, 3 + (left_color / 32) * PALETTE_SCALE + 1, 43 + (left_color % 32) * PALETTE_SCALE + 2, Window[WINDOW_FILE].fg);
        putpixel(screen_buffer, 3 + (right_color / 32) * PALETTE_SCALE + PALETTE_SCALE - 2, 43 + (right_color % 32) * PALETTE_SCALE + 1, Window[WINDOW_FILE].bg);
        putpixel(screen_buffer, 3 + (right_color / 32) * PALETTE_SCALE + PALETTE_SCALE - 2, 43 + (right_color % 32) * PALETTE_SCALE + 2, Window[WINDOW_FILE].fg);
}

void select_tool(void)
{
        if(mouse_b & 1 && mouse_y < toolpic->h - 1)
        {
                if(mouse_x < 240)
                {
                        selected_tool = mouse_x / 24;
                        while(mouse_b & 1)

                                update_proc();
                }
        }
}

void select_color(void)
{
        if(mouse_b & 1 && mouse_y >= 43 && mouse_y < 43 + PALETTE_SCALE * 32 && mouse_x >= 3 && mouse_x < 3 + PALETTE_SCALE * 8)

                left_color = ((mouse_x - 3) / PALETTE_SCALE) * 32 + (mouse_y - 43) / PALETTE_SCALE;

        if(mouse_b & 2 && mouse_y >= 43 && mouse_y < 43 + PALETTE_SCALE * 32 && mouse_x >= 3 && mouse_x < 3 + PALETTE_SCALE * 8)

                right_color = ((mouse_x - 3) / PALETTE_SCALE) * 32 + (mouse_y - 43) / PALETTE_SCALE;
}
