#ifndef FONT_H
#define FONT_H


/* fixed size font structure */
typedef struct
{
    unsigned char w; /* width */
    unsigned char h; /* height */
    BITMAP * ch[256];
} NCDFONT;        

/* internal function used in editor */
void create_ncdfont(NCDFONT * FontPointer, int w, int h);

/* disk functions */
int load_ncdfont_fp(NCDFONT * FontPointer, PACKFILE * fp);
int load_ncdfont(NCDFONT * FontPointer, char * FileName);
int save_ncdfont_fp(NCDFONT * FontPointer, PACKFILE * fp);
int save_ncdfont(NCDFONT * FontPointer, char * FileName);
void destroy_ncdfont(NCDFONT * FontPointer);

/* set some options */
void ncd_text_mode(int mode);
void ncd_text_color(int color);

/* text output functions */
void ncd_textout(BITMAP * b, NCDFONT * f, int x, int y, char * s);
void ncd_textout_center(BITMAP * b, NCDFONT * f, int ox, int oy, char * s);
void ncd_printf(BITMAP *b, NCDFONT *f, int x, int y, char *format, ...);
void ncd_printf_center(BITMAP *b, NCDFONT *f, int ox, int oy, char *format, ...);
void ncd_printf_truncated(BITMAP *b, NCDFONT *f, int x, int y, int length, char *format, ...);
void ncd_draw_number(BITMAP * b, NCDFONT * f, int x, int y, unsigned long n, int d);
void ncd_draw_number_right(BITMAP * b, NCDFONT * f, int x, int y, long n, int d);
void ncd_draw_number_left(BITMAP * b, NCDFONT * f, int x, int y, long n, int d);
void ncd_show_text(BITMAP * bp, NCDFONT * fp, int x, int y, char * tp);

#endif
