#include "palette.h"
#include "includes.h"

/* sets up the main menu */
void make_main_menu(void)
{
    destroy_window(&Window[WINDOW_MAINMENU]);

    /* add items */
    create_window(&Window[WINDOW_MAINMENU], TYPE_MENU, "Main Menu");
    set_window_position(&Window[WINDOW_MAINMENU], 20, 60);
    set_window_color(&Window[WINDOW_MAINMENU], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    add_menu_item(&Window[WINDOW_MAINMENU], "New", -1, gui_new_theme);
    add_menu_item(&Window[WINDOW_MAINMENU], "Load", -1, gui_load_theme);

    /* only add these if a theme is loaded */
    if(ThemeLoaded)
    {
        add_menu_item(&Window[WINDOW_MAINMENU], "Edit", WINDOW_EDITMENU, NULL);
        add_menu_item(&Window[WINDOW_MAINMENU], "View", -1, view_theme);
        add_menu_item(&Window[WINDOW_MAINMENU], "Save", -1, gui_save_theme);
    }

    /* add items and activate */
    if(ThemeLoaded && edited)
    {
        add_menu_item(&Window[WINDOW_MAINMENU], "Quit", WINDOW_SAVE, NULL);
    }
    else
    {
        add_menu_item(&Window[WINDOW_MAINMENU], "Quit", -1, ce_quit);
    }
    activate_window(&Window[WINDOW_MAINMENU]);
    make_closest(ce_zbuffer, WINDOW_MAINMENU, WINDOWS);
    select_window(&Window[WINDOW_MAINMENU]);
    selected_window = WINDOW_MAINMENU;

    create_window(&Window[WINDOW_FILE], TYPE_MENU, "File");
    set_window_position(&Window[WINDOW_FILE], 20, 60);
    set_window_color(&Window[WINDOW_FILE], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
}


void reset_ce(void)
{
    int i;

    for(i = 0; i < WINDOWS; i++)
    {
        deactivate_window(&Window[i]);
    }

    select_palette(ce_palette);
    make_main_menu();
    unselect_palette();
    destroy_bitmap(screen_buffer);
    set_gfx_mode(GFX_AUTODETECT, 320, 200, 320, 200);
    set_palette(black_palette);
    screen_buffer = create_bitmap(320, 200);
    update_proc = ce_update;
}


void redraw_gui_edit(void)
{
    int i;

    clear(screen_buffer);

    /* draw all the windows */
    for(i = 0; i < WINDOWS; i++)
    {
        draw_window(&Window[ce_zbuffer[i]], screen_buffer);
    }
    draw_tools();

    /* draw the mouse */
    draw_sprite(screen_buffer, cursor, mouse_x, mouse_y);

    /* copy to hardware screen */
    vsync();
    blit(screen_buffer, screen, 0, 0, 0, 0, screen->w, screen->h);
}


void redraw_gui(void)
{
    int i;

    /* clear the software screen */
    clear(screen_buffer);

    /* draw all the windows */
    for(i = 0; i < WINDOWS; i++)
    {
        draw_window(&Window[ce_zbuffer[i]], screen_buffer);
    }

    /* draw the mouse */
    draw_sprite(screen_buffer, ce_cursor, mouse_x, mouse_y);

    /* copy to hardware screen */
    vsync();
    blit(screen_buffer, screen, 0, 0, 0, 0, screen->w, screen->h);
}


/* loads a theme from a selected file */
void gui_load_theme(void)
{
    gui_bg_color = Window[selected_window].hbg;
    gui_fg_color = Window[selected_window].hfg;
    if(file_select_ex("Select theme file...", ThemeName, "CTH", 256, SCREEN_W, SCREEN_H))
    {
        if(ThemeLoaded)
        {
            DestroyTheme(&Theme);
        }
        LoadTheme(&Theme, ThemeName, 0);
        ce_convert();
        ThemeLoaded = 1;
        make_main_menu();
    }
    while(key[KEY_ESC] || key[KEY_ENTER] || key[KEY_SPACE])
    {
        update_proc();
    }
    edited = 0;
}


/* saves a theme to chosen filename */
void gui_save_theme(void)
{
    gui_bg_color = Window[selected_window].hbg;
    gui_fg_color = Window[selected_window].hfg;
    if(file_select_ex("Choose theme name...", ThemeName, "CTH", 256, SCREEN_W, SCREEN_H))
    {
        SaveTheme(&Theme, ThemeName);
        edited = 0;
        make_main_menu();
    }
    while(key[KEY_ESC] || key[KEY_ENTER] || key[KEY_SPACE])
    {
        update_proc();
    }
}


void grab_image(BITMAP * dp, char * filename)
{
    PALETTE temppalette;
    BITMAP * sp;

    sp = load_pcx(filename, temppalette);
    convert_palette(sp, temppalette, Theme.Palette);
    stretch_blit(sp, dp, 0, 0, sp->w, sp->h, 0, 0, dp->w, dp->h);
    destroy_bitmap(sp);
}


void try_quit(void)
{
    int i;

    if(ThemeLoaded)
    {
        for(i = 0; i < WINDOWS; i++)
        {
            deactivate_window(&Window[i]);
        }
        activate_window(&Window[WINDOW_SAVE]);
    }
    else
    {
        ce_quit();
    }
}


void save_exit(void)
{
    SaveTheme(&Theme, ThemeName);
    ce_quit();
}


void loadimages_ce(void)
{
    cursor = load_pcx(DATADIR "ce.dat#cursor", NULL);
    rgb = load_pcx(DATADIR "ce.dat#rgb", NULL);
    slider = load_pcx(DATADIR "ce.dat#slider", NULL);
    initialize_tools();
}


void freeimages_ce(void)
{
    destroy_bitmap(cursor);
    destroy_bitmap(rgb);
    destroy_bitmap(slider);
    remove_tools();
}


/* get ready to run the program */
void initialize_ce(void)
{
    /* set up allegro */
    allegro_init();
    install_timer();
    install_keyboard();

    /* make sure we have a mouse */
    if(!install_mouse())
    {
        allegro_message("This program requires a mouse!\n");
        exit(0);
    }

    /* make sure the editor is installed properly */
    if(!exists(DATADIR "ce.dat"))
    {
        allegro_message("Editor not installed correctly!");
        exit(0);
    }

    /* setup sound stuff */
    ncds_install(22050, 0);

    /* load images */
    bg_pic = load_pcx(DATADIR "ce.dat#bgpic", ce_palette);
    ce_cursor = load_pcx(DATADIR "ce.dat#cursor", NULL);
    settings = load_pcx(DATADIR "ce.dat#settings", NULL);
    sounds = load_pcx(DATADIR "ce.dat#sound_settings", NULL);
    loadimages_ce();

    /* set up the screen */
    set_gfx_mode(GFX_AUTODETECT, 320, 200, 320, 200);
    set_mouse_sprite(ce_cursor);
    screen_buffer = create_bitmap(320, 200);

    /* set up the main menu */
    set_palette(ce_palette);
    make_main_menu();

    /* set up the edit menu */
    create_window(&Window[WINDOW_EDITMENU], TYPE_MENU, "Edit");
    set_window_color(&Window[WINDOW_EDITMENU], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_parent(&Window[WINDOW_EDITMENU], WINDOW_MAINMENU);
    add_menu_item(&Window[WINDOW_EDITMENU], "Palette", -1, edit_palette);
    add_menu_item(&Window[WINDOW_EDITMENU], "Font", -1, edit_font);
    add_menu_item(&Window[WINDOW_EDITMENU], "Block", -1, edit_block);
    add_menu_item(&Window[WINDOW_EDITMENU], "Tile", -1, edit_tiles);
    add_menu_item(&Window[WINDOW_EDITMENU], "Background", -1, gui_background);
    add_menu_item(&Window[WINDOW_EDITMENU], "Layout", -1, edit_layout);
    add_menu_item(&Window[WINDOW_EDITMENU], "Sound", -1, edit_sounds);

    /* set up the settings window (used by settings.c) */
    create_window(&Window[WINDOW_SETTINGS], TYPE_IMAGE, "Settings");
    set_window_position(&Window[WINDOW_SETTINGS], 70, 40);
    set_window_color(&Window[WINDOW_SETTINGS], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_parent(&Window[WINDOW_SETTINGS], WINDOW_SETTINGS);
    import_image(&Window[WINDOW_SETTINGS], create_bitmap(settings->w, settings->h));

    /* set up the settings window (used by settings.c) */
    create_window(&Window[WINDOW_SOUNDS], TYPE_IMAGE, "Sounds");
    set_window_position(&Window[WINDOW_SOUNDS], 40, 40);
    set_window_color(&Window[WINDOW_SOUNDS], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_parent(&Window[WINDOW_SOUNDS], WINDOW_SOUNDS);
    import_image(&Window[WINDOW_SOUNDS], create_bitmap(sounds->w, sounds->h));

    /* set up the rgb window */
    create_window(&Window[WINDOW_RGB], TYPE_IMAGE, "RGB");
    set_window_color(&Window[WINDOW_RGB], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_parent(&Window[WINDOW_RGB], WINDOW_RGB);
    import_image(&Window[WINDOW_RGB], create_bitmap(rgb->w, rgb->h));
    set_window_position(&Window[WINDOW_RGB], 0, 0);

    /* set up the image selector window */
    create_window(&Window[WINDOW_ISELECT], TYPE_IMAGE, "Pics");
    set_window_position(&Window[WINDOW_ISELECT], 60, 20);
    set_window_color(&Window[WINDOW_ISELECT], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_parent(&Window[WINDOW_ISELECT], WINDOW_ISELECT);

    /* set up the image editor window */
    create_window(&Window[WINDOW_IEDIT], TYPE_IMAGE, "Edit");
    set_window_position(&Window[WINDOW_IEDIT], 0, 0);
    set_window_color(&Window[WINDOW_IEDIT], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_parent(&Window[WINDOW_IEDIT], WINDOW_IEDIT);

    create_window(&Window[WINDOW_SAVE], TYPE_MENU, "Save Changes?");
    add_menu_item(&Window[WINDOW_SAVE], "Yes", -1, save_exit);
    add_menu_item(&Window[WINDOW_SAVE], "No", -1, ce_quit);
    set_window_position(&Window[WINDOW_SAVE], 160 - (Window[WINDOW_SAVE].w >> 1), 100 - (Window[WINDOW_SAVE].h >> 1));
    set_window_color(&Window[WINDOW_SAVE], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_parent(&Window[WINDOW_SAVE], WINDOW_MAINMENU);

    /* create zbuffer */
    create_zbuff(ce_zbuffer, WINDOWS);

    /* point update_proc to the right place */
    update_proc = ce_update;

    strcpy(ThemeName, ".\\");

    set_palette(black_palette);
}


/* get ready to go back to DOS */
void exit_ce(void)
{
    int i;

    /* unload images */
    freeimages_ce();
    destroy_bitmap(bg_pic);
    destroy_bitmap(screen_buffer);
    destroy_bitmap(settings);
    destroy_bitmap(sounds);
    destroy_bitmap(ce_cursor);

    for(i = 0; i < WINDOWS; i++)
    {
        destroy_window(&Window[i]);
    }
    destroy_zbuff(ce_zbuffer);

    if(ThemeLoaded)
    {
        SaveTheme(&Theme, "cebackup.cth");
        DestroyTheme(&Theme);
    }
        
    /* stop sound */
    ncds_remove();

//    set_gfx_mode(GFX_TEXT, 80, 25, 80, 25);
//    allegro_exit();
}


/* sets quitbit (so we can exit) */
void ce_quit(void)
{
    quitbit = 1;
}


/* normal update procedure used on the main screen */
void ce_update(void)
{
    int i;

    /* see if there are any hanging drop down menus */
    deactivate_drop_menus();

    /* draw the background */
    blit(bg_pic, screen_buffer, 0, 0, 0, 0, 320, 200);

    /* draw all windows */
    for(i = 0; i < WINDOWS; i++)
    {
        draw_window(&Window[ce_zbuffer[i]], screen_buffer);
    }

    /* draw the mouse */
    draw_sprite(screen_buffer, ce_cursor, mouse_x, mouse_y);

    /* update the hardware screen */
    vsync();
    blit(screen_buffer, screen, 0, 0, 0, 0, 320, 200);
}


void ce_convert(void)
{
    int i;

    freeimages_ce();
    loadimages_ce();
    convert_palette(cursor, ce_palette, Theme.Palette);
    convert_palette(rgb, ce_palette, Theme.Palette);
    convert_palette(slider, ce_palette, Theme.Palette);
    for(i = 0; i < TOTAL_TOOLS; i++)
    {
        convert_palette(tool[i], ce_palette, Theme.Palette);
    }
    set_window_color(&Window[WINDOW_MAINMENU], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_color(&Window[WINDOW_EDITMENU], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_color(&Window[WINDOW_SETTINGS], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_color(&Window[WINDOW_SOUNDS], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_color(&Window[WINDOW_SAVE], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_color(&Window[WINDOW_FILE], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_color(&Window[WINDOW_RGB], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_color(&Window[WINDOW_ISELECT], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
    set_window_color(&Window[WINDOW_IEDIT], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
}


/* run the program */
void run_ce(void)
{
//    update_proc();
    fade_in(ce_palette, 3);
    while(!quitbit)
    {
        ce_control();
        update_proc();
    }
    fade_out(3);
}


/* main function */
int main(void)
{
    initialize_ce();
    run_ce();
    exit_ce();

    return 0;
}

END_OF_MAIN()
