#ifndef MENU_H
#define MENU_H

#include <allegro.h>

#define TOTAL_MENUS   29
#define MENU_MAIN      0
#define MENU_OPTIONS   1
#define MENU_AUDIO     2
#define MENU_GAME      3
#define MENU_GRAPHICS  4
#define MENU_HELP      5
#define MENU_MODES     6
#define MENU_MODES_1P  7
#define MENU_MODES_2P  8

#define MENU_PLAY      9

#define MENU_1PLAY    10
#define MENU_1PLAYC   11
#define MENU_1PLAYD   12
#define MENU_1PLAYF   13

#define MENU_2PLAY    14
#define MENU_2PLAYN   15
#define MENU_2PLAYNS  16
#define MENU_2PLAYNL  17
#define MENU_2PLAYND  18
#define MENU_2PLAYB   19
#define MENU_2PLAYBS  20
#define MENU_2PLAYBL  21
#define MENU_2PLAYBD  22
#define MENU_CONTROL  23
#define MENU_SCORES   24
#define MENU_DSCORES  25
#define MENU_FSCORES  26
#define MENU_CCONTROL 27
#define MENU_JCONTROL 28

#define MLOGO_Y  15
#define MENU_X  110
#define MENU_Y  115

//void DoMenuQuit(void);
void reset_menus(void);
void draw_menu_screen(BITMAP * bp, int ox, int oy);
void cs_main_menu(void);
void show_scores(void);
void show_scores_immediate(int HSScreen);

/* menu item subfunctions */
void main_menu_quit_proc(void);
void control_menu_keyboard(void);
void control_menu_joystick(void);
void customize_controls(void);
void main_menu_scores(void);
void scores_menu_destroyer(void);
void scores_menu_frenzy(void);
void main_menu_play(void);
void play_menu_1p(void);
void play_menu_1p_classic(void);
void play_menu_1p_destroyer(void);
void play_menu_1p_frenzy(void);
void play_menu_2p(void);
void play_menu_2pn(void);
void menu_2pn_top_score(void);
void menu_2pn_last_out(void);
void menu_2pn_destroyer(void);
void play_menu_2pb(void);
void menu_2pb_top_score(void);
void menu_2pb_last_out(void);
void menu_2pb_destroyer(void);
void main_menu_options(void);
void options_menu_audio(void);
void options_menu_game(void);
void options_menu_graphics(void);
void main_menu_control(void);
void menu_sound_volume_left_proc(void);
void menu_sound_volume_right_proc(void);
void menu_music_volume_left_proc(void);
void menu_music_volume_right_proc(void);
void menu_sound_quality_left_proc(void);
void menu_sound_quality_right_proc(void);
void menu_stereo_left_proc(void);
void menu_stereo_right_proc(void);
void menu_joystick_toggle(void);
void menu_wild_card_toggle(void);
void menu_bomb_toggle(void);
void menu_effects_toggle(void);
void menu_transitions_toggle(void);
void menu_vsync_toggle(void);
void menu_screen_mode_left_proc(void);
void menu_screen_mode_right_proc(void);
void menu_level_left_proc(void);
void menu_level_right_proc(void);
void menu_blocks_left_proc(void);
void menu_blocks_right_proc(void);
void menu_time_left_proc(void);
void menu_time_right_proc(void);
void menu_play_proc(void);
void select_theme(void);

#endif
