#include "includes.h"
#include "externs.h"

/* sets all the theme filenames, checks for files */
void update_theme_filenames(char * FileName)
{
    char TempName[256];

    strcpy(TempName, FileName);

    /* get theme filename and set default if it doesn't exist (shouldn't happen in release version) */
    replace_extension(TempName, TempName, "cth", 128);
    if(exists(TempName))
    {
        strcpy(cs_options.theme_name, TempName);
    }
    else
    {
        strcpy(cs_options.theme_name, DATADIR "cs.cth");
    }

    /* get the mod filename and set default if it doesn't exist (in case music wasn't included with theme) */
    replace_extension(TempName, TempName, "xm", 128);
    if(exists(TempName))
    {
        strcpy(music_name, TempName);
    }
    else
    {
        strcpy(music_name, DATADIR "cs.xm");
    }
}
