#include "includes.h"
#include "externs.h"

/* draws specified players score according to theme specs */
void draw_score(CS_GAME * gp)
{
    ncd_draw_number(cs_theme.screen, &cs_theme.font, cs_theme.score_x[gp->player], cs_theme.score_y[gp->player], gp->score, 5);
}

/* draws the current high score */
void draw_high_score(unsigned long sc)
{
    ncd_draw_number(cs_theme.screen, &cs_theme.font, cs_theme.high_score_x, cs_theme.high_score_y, sc, 5);
}

/* draws specified players score according to theme specs */
void draw_block_counter(CS_GAME * gp)
{
    if(gp->mode != CS_1TD && gp->mode != CS_2ND && gp->mode != CS_2BD)
    {
        ncd_draw_number(cs_theme.screen, &cs_theme.font, cs_theme.block_x[gp->player], cs_theme.block_y[gp->player], gp->total_removed, 4);
    }
    else
    {
        ncd_draw_number(cs_theme.screen, &cs_theme.font, cs_theme.block_x[gp->player], cs_theme.block_y[gp->player], gp->blocks_left, 4);
    }
}

/* draws specified players score according to theme specs */
void draw_blocks_left(CS_GAME * gp)
{
    ncd_draw_number(cs_theme.screen, &cs_theme.font, cs_theme.block_x[gp->player], cs_theme.block_y[gp->player], gp->total_removed, 4);
}

/* draws specified players score according to theme specs */
void draw_level(CS_GAME * gp)
{
    ncd_draw_number(cs_theme.screen, &cs_theme.font, cs_theme.level_x[gp->player], cs_theme.level_y[gp->player], gp->level, 2);
}

/* draws clock onto screen */
void draw_clock(CS_GAME * gp, CS_CLOCK * ClockPointer)
{
    ncd_draw_number(cs_theme.screen, &cs_theme.font, cs_theme.time_x, cs_theme.time_y, ClockPointer->minutes, 2);
    ncd_printf(cs_theme.screen, &cs_theme.font, cs_theme.time_x, cs_theme.time_y, "  :");
    ncd_draw_number(cs_theme.screen, &cs_theme.font, cs_theme.time_x + cs_theme.font.w * 3, cs_theme.time_y, ClockPointer->seconds, 2);
}

/* draws clock onto screen at specified location */
void draw_clock_pos(int Min, int Sec, int x, int y)
{
    ncd_draw_number(cs_theme.screen, &cs_theme.font, x, y, Min, 2);
    ncd_printf(cs_theme.screen, &cs_theme.font, x, y, "  :");
    ncd_draw_number(cs_theme.screen, &cs_theme.font, x + cs_theme.font.w * 3, y, Sec, 2);
}

/* draws the theme background image */
void draw_bg(void)
{
	int i, j;

	/* draw the tilemap */
	if(cs_theme.tile_w > 0 && cs_theme.tile_h > 0)
	{
		for(i = 0; i < cs_theme.map_h; i++)
		{
			for(j = 0; j < cs_theme.map_w; j++)
			{
				blit_ani(cs_theme.tile_image[(int)cs_theme.map[i * cs_theme.map_w + j]], cs_theme.screen, j * cs_theme.tile_w, i * cs_theme.tile_h, cs_frame);
			}
		}
	}

	/* or draw the full screen backdrop */
	else
	{
		blit(cs_theme.bg_image, cs_theme.screen, 0, 0, 0, 0, cs_theme.rx, cs_theme.ry);
	}
}

/* draws the board backdrop */
void draw_board_bg(CS_GAME * gp, CS_THEME * tp)
{
	int i, j;

    for(i = 0; i < tp->board_h; i++)
    {
	    for(j = 0; j < tp->board_w; j++)
	    {
		    draw_ani(gp->board_screen, tp->block_image[0], j * tp->block_w, i * tp->block_h, cs_frame);
	    }
    }
//    draw_sprite(gp->board_screen, tp->board_image, 0, 0);
}

/* draw block that is currently dropping */
void draw_stack(CS_GAME * gp)
{
    int i;

    if(gp->stack.dactive)
    {
        for(i = 0; i < STACK_HEIGHT; i++)
        {
            /* draw normal */
            if(gp->stack.dtype[i] < NUM_BLOCK_TYPES)
            {
                draw_ani(gp->board_screen, cs_theme.block_image[(int)gp->stack.dtype[i]], gp->stack.dx * cs_theme.block_w, (gp->stack.dy + i - STACK_HEIGHT) * cs_theme.block_h, cs_frame);
            }

            /* wild card */
            else if(gp->stack.dtype[i] == NUM_BLOCK_TYPES)
            {
                draw_ani(gp->board_screen, cs_theme.block_image[(gp->wild_count >> WILD_SHIFT) + 1], gp->stack.dx * cs_theme.block_w, (gp->stack.dy + i - STACK_HEIGHT) * cs_theme.block_h, cs_frame);
            }

            /* or bomb */
            else if(gp->stack.dtype[i] == NUM_BLOCK_TYPES + 1)
            {
                draw_ani(gp->board_screen, gp->wild_count % 2 ? cs_theme.block_image[(gp->wild_count >> WILD_SHIFT) + 1] : cs_theme.block_flash_image[(gp->wild_count >> WILD_SHIFT) + 1], gp->stack.dx * cs_theme.block_w, (gp->stack.dy + i - STACK_HEIGHT) * cs_theme.block_h, cs_frame);
            }
        }
    }
}

/* draw next block preview */
void draw_preview(CS_GAME * gp)
{
    int i;

    for(i = 0; i < STACK_HEIGHT; i++)
    {
        /* draw normal */
        if(gp->next_stack.dtype[i] < NUM_BLOCK_TYPES)
        {
            draw_ani(cs_theme.screen, cs_theme.block_image[(int)gp->next_stack.dtype[i]], cs_theme.preview_x[gp->player], cs_theme.preview_y[gp->player] + (i * cs_theme.block_h), cs_frame);
        }

        /* wild card */
        else if(gp->next_stack.dtype[i] == NUM_BLOCK_TYPES)
        {
            draw_ani(cs_theme.screen, cs_theme.block_image[(gp->wild_count >> WILD_SHIFT) + 1], cs_theme.preview_x[gp->player], cs_theme.preview_y[gp->player] + (i * cs_theme.block_h), cs_frame);
        }

        /* or bomb */
        else if(gp->next_stack.dtype[i] == NUM_BLOCK_TYPES + 1)
        {
            draw_ani(cs_theme.screen, gp->wild_count % 2 ? cs_theme.block_image[(gp->wild_count >> WILD_SHIFT) + 1] : cs_theme.block_flash_image[(gp->wild_count >> WILD_SHIFT) + 1], cs_theme.preview_x[gp->player], cs_theme.preview_y[gp->player] + (i * cs_theme.block_h), cs_frame);
        }
    }
}

/* draw block that is currently dropping in the preview window */
void draw_preview_current(CS_GAME * gp)
{
    int i;

    for(i = 0; i < STACK_HEIGHT; i++)
    {
        /* draw normal */
        if(gp->stack.dtype[i] < NUM_BLOCK_TYPES)
        {
            draw_ani(cs_theme.screen, cs_theme.block_image[(int)gp->stack.dtype[i]], cs_theme.preview_x[gp->player], cs_theme.preview_y[gp->player] + (i * cs_theme.block_h), cs_frame);
        }

        /* wild card */
        else if(gp->stack.dtype[i] == NUM_BLOCK_TYPES)
        {
            draw_ani(cs_theme.screen, cs_theme.block_image[(gp->wild_count >> WILD_SHIFT) + 1], cs_theme.preview_x[gp->player], cs_theme.preview_y[gp->player] + (i * cs_theme.block_h), cs_frame);
        }

        /* or bomb */
        else if(gp->stack.dtype[i] == NUM_BLOCK_TYPES + 1)
        {
            draw_ani(cs_theme.screen, gp->wild_count % 2 ? cs_theme.block_image[(gp->wild_count >> WILD_SHIFT) + 1] : cs_theme.block_flash_image[(gp->wild_count >> WILD_SHIFT) + 1], cs_theme.preview_x[gp->player], cs_theme.preview_y[gp->player] + (i * cs_theme.block_h), cs_frame);
        }
    }
}

/* draw the board */
void draw_board(CS_GAME * gp)
{
    int i, j;

    /* go through visible part of board */
    for(i = 0; i < cs_theme.board_h; i++)
    {
        for(j = 0; j < cs_theme.board_w; j++)
        {
            /* draw crystal if there'e one there */
            if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j])
            {
                if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j] < NUM_BLOCK_TYPES)
                {
                    draw_ani(gp->board_screen, cs_theme.block_image[gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j]], j * cs_theme.block_w, i * cs_theme.block_h, cs_frame);
                }
                else if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j] == NUM_BLOCK_TYPES)
                {
                    draw_ani(gp->board_screen, cs_theme.block_image[(gp->wild_count >> WILD_SHIFT) + 1], j * cs_theme.block_w, i * cs_theme.block_h, cs_frame);
                }
                else if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j] == NUM_BLOCK_TYPES + 1)
                {
                    draw_ani(gp->board_screen, gp->wild_count % 2 ? cs_theme.block_image[(gp->wild_count >> WILD_SHIFT) + 1] : cs_theme.block_flash_image[(gp->wild_count >> WILD_SHIFT) + 1], j * cs_theme.block_w, i * cs_theme.block_h, cs_frame);
                }
            }
        }
    }
}

/* draws highlighted blocks using the blockerase image */
void draw_board_runs(CS_GAME * gp, CS_THEME * tp)
{
    int i, j;

    /* go through visible part of board */
    for(i = 0; i < cs_theme.board_h; i++)
    {
        for(j = 0; j < cs_theme.board_w; j++)
        {
            /* if crystal is in a run, draw highlighted crystal */
            if(gp->runs[(i + STACK_HEIGHT) * cs_theme.board_w + j])
            {
                if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j] < NUM_BLOCK_TYPES)
                {
                    draw_ani(gp->board_screen, cs_theme.block_flash_image[gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j]], j * cs_theme.block_w, i * cs_theme.block_h, cs_frame);
                }
                else if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j] == NUM_BLOCK_TYPES)
                {
                    draw_ani(gp->board_screen, cs_theme.block_flash_image[(gp->wild_count >> WILD_SHIFT) + 1], j * cs_theme.block_w, i * cs_theme.block_h, cs_frame);
                }
                else if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j] == NUM_BLOCK_TYPES + 1)
                {
                    draw_ani(gp->board_screen, cs_theme.block_flash_image[(gp->wild_count >> WILD_SHIFT) + 1], j * cs_theme.block_w, i * cs_theme.block_h, cs_frame);
                }
            }

            /* otherwise draw normal crystal */
            else
            {
                if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j])
                {
                    if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j] < NUM_BLOCK_TYPES)
                    {
                        draw_ani(gp->board_screen, cs_theme.block_image[gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j]], j * cs_theme.block_w, i * cs_theme.block_h, cs_frame);
                    }
                    else if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j] == NUM_BLOCK_TYPES)
                    {
                        draw_ani(gp->board_screen, cs_theme.block_image[(gp->wild_count >> WILD_SHIFT) + 1], j * cs_theme.block_w, i * cs_theme.block_h, cs_frame);
                    }
                    else if(gp->board[(i + STACK_HEIGHT) * cs_theme.board_w + j] == NUM_BLOCK_TYPES + 1)
                    {
                        draw_ani(gp->board_screen, cs_theme.block_image[(gp->wild_count >> WILD_SHIFT) + 1], j * cs_theme.block_w, i * cs_theme.block_h, cs_frame);
                    }
                }
            }
        }
    }
}

/* draws a game */
void draw_game(CS_GAME * gp, CS_THEME * tp, CS_CLOCK * cp)
{
    /* draw stuff */
    draw_board_bg(gp, tp);
    if(!gp->runs_left)
    {
        draw_board(gp);
        draw_stack(gp);
        draw_preview(gp);
    }

    /* handle the runs */
    if(gp->runs_left)
    {
        /* battle mode */
        if(gp->mode >= CS_2BS)
        {
            if(gp->player == 0)
            {
                core_handle_runs_battle(&cs_game[0], &cs_game[1], tp);
            }
            else
            {
                core_handle_runs_battle(&cs_game[1], &cs_game[0], tp);
            }
        }

        /* normal mode */
        else
        {
            core_handle_runs_normal(gp, tp);
        }
    }

    /* draw counters */
    draw_score(gp);
    draw_block_counter(gp);
    draw_level(gp);
    draw_clock(gp, cp);

    /* 1 player classic mode */
    if(gp->mode == CS_1NS)
    {
        /* draw high score from table */
        if(cs_scores.classic_score[0] > gp->score)
        {
            draw_high_score(cs_scores.classic_score[0]);
        }

        /* or player's if he beat the score */
        else
        {
            draw_high_score(gp->score);
        }
    }

    /* 1 player frenzy mode */
    if(gp->mode == CS_1TF)
    {
        /* draw high score from table */
        if(cs_scores.frenzy_score[cs_options.time_index][0] > gp->score)
        {
            draw_high_score(cs_scores.frenzy_score[cs_options.time_index][0]);
        }

        /* or player's if he beat the score */
        else
        {
            draw_high_score(gp->score);
        }
    }

    /* all modes except 1 player destroyer */
    if(gp->mode != CS_1TD)
    {
        /* show best time as 0:00 */
        draw_clock_pos(0, 0, cs_theme.best_time_x, cs_theme.best_time_y);
    }

    /* 1 player destroyer mode */
    else
    {
        /* show best time */
        draw_clock_pos(cs_scores.destroyer_minutes[cs_options.block_index][0], cs_scores.destroyer_seconds[cs_options.block_index][0], cs_theme.best_time_x, cs_theme.best_time_y);

        /* show high score as 0 */
        draw_high_score(0);
    }

    if(gp->mode >= CS_2NS)
    {
        draw_high_score(0);
    }
    draw_messages(&gp->messages, gp, tp);
    cs_frame++;
}

/* draws game in paused mode (hides preview and board status) */
void draw_game_paused(CS_GAME * gp, CS_THEME * tp, CS_CLOCK * cp)
{
    /* draw stuff */
    draw_board_bg(gp, tp);
    draw_score(gp);
    draw_block_counter(gp);
    draw_level(gp);

    /* draw the clock when we run player 1 through this procedure */
    if(gp->player == 0)
    {
        draw_clock(gp, cp);
    }

    /* draw some counters */
    if(gp->mode == CS_1NS)
    {
        /* draw the high score from the table */
        if(cs_scores.classic_score[0] > gp->score)
        {
            draw_high_score(cs_scores.classic_score[0]);
        }

        /* unless player has bested that score (then draw players score) */
        else
        {
            draw_high_score(gp->score);
        }
    }

    /* draw some counters */
    if(gp->mode == CS_1TF)
    {
        /* draw the high score from the table */
        if(cs_scores.frenzy_score[cs_options.time_index][0] > gp->score)
        {
            draw_high_score(cs_scores.frenzy_score[cs_options.time_index][0]);
        }

        /* unless player has bested that score (then draw players score) */
        else
        {
            draw_high_score(gp->score);
        }
    }

    /* draw some counters */
    if(gp->player == 0)
    {
        /* draw static clock */
        if(gp->mode != CS_1TD)
        {
            draw_clock_pos(0, 0, cs_theme.best_time_x, cs_theme.best_time_y);
        }

        /* or best time clock */
        else
        {
            draw_clock_pos(cs_scores.destroyer_minutes[cs_options.block_index][0], cs_scores.destroyer_seconds[cs_options.block_index][0], cs_theme.best_time_x, cs_theme.best_time_y);
            draw_high_score(0);
        }

        /* in 2 player modes, show high score as 0 */
        if(gp->mode >= CS_2NS)
        {
            draw_high_score(0);
        }
    }

    /* draw the messages */
    draw_messages(&gp->messages, gp, tp);
    cs_frame++;
}
