#include "includes.h"
#include "externs.h"

/* level 1 attack */
void level_1_attack(CS_GAME * gp)
{
    /* stop the timer */
    if(gp->player == 0)
    {
        remove_int(core_drop_stack0);
    }
    else
    {
        remove_int(core_drop_stack1);
    }
    /* play attack sound */
    t3ss_play_sound(cs_theme.sound[SOUND_ATTACK], cs_panning[(int)cs_options.stereo][gp->player], I_NULL);

    /* insert solid blocks */
    core_insert_solid_row(gp);

    /* restart timer */
    if(gp->player == 0)
    {
        install_int(core_drop_stack0, gp->drop_time);
    }
    else
    {
        install_int(core_drop_stack1, gp->drop_time);
    }
}

/* level 2 attack */
void level_2_attack(CS_GAME * gp)
{
    /* stop the timer */
    if(gp->player == 0)
    {
        remove_int(core_drop_stack0);
    }
    else
    {
        remove_int(core_drop_stack1);
    }
    /* play attack sound */
    t3ss_play_sound(cs_theme.sound[SOUND_ATTACK], cs_panning[(int)cs_options.stereo][gp->player], I_NULL);

    /* insert solid blocks */
    core_insert_solid_row(gp);
    core_insert_solid_row(gp);

    /* restart timer */
    if(gp->player == 0)
    {
        install_int(core_drop_stack0, gp->drop_time);
    }
    else
    {
        install_int(core_drop_stack1, gp->drop_time);
    }
}

/* level 3 attack */
void level_3_attack(CS_GAME * gp)
{
    /* stop the timer */
    if(gp->player == 0)
    {
        remove_int(core_drop_stack0);
    }
    else
    {
        remove_int(core_drop_stack1);
    }

    /* play attack sound */
    t3ss_play_sound(cs_theme.sound[SOUND_ATTACK], cs_panning[(int)cs_options.stereo][gp->player], I_NULL);

    /* insert solid blocks */
    core_insert_solid_row(gp);
    core_insert_solid_row(gp);
    core_insert_solid_row(gp);

    /* restart timer */
    if(gp->player == 0)
    {
        install_int(core_drop_stack0, gp->drop_time);
    }
    else
    {
        install_int(core_drop_stack1, gp->drop_time);
    }
}
