#ifndef THEME_H
#define THEME_H

#define NUM_BG_TILES    40
#define NUM_BLOCK_TYPES  7
#define MAX_PLAYERS      2
#define MAX_BOARDWIDTH  32

#define MAX_SOUNDS       11
#define SOUND_DROP        0
#define SOUND_ROTATEUP    1
#define SOUND_ROTATEDOWN  2
#define SOUND_MOVE        3
#define SOUND_HITWALL     4
#define SOUND_LAND        5
#define SOUND_RUN         6
#define SOUND_DELETE      7
#define SOUND_LEVELUP     8
#define SOUND_PAUSE       9
#define SOUND_ATTACK     10

typedef struct{
        /* global theme data */

        char Header[4];                       /* header buffer for loader */

        unsigned char Card;                   /* video card */
        unsigned short ResX;                  /* screen width */
        unsigned short ResY;                  /* screen height */
        PALETTE Palette;
        BITMAP * ScreenBuffer;
        BITMAP * BGPic;
        BITMAP * BoardBGPic;

        unsigned char BlockWidth;             /* width of block graphics */
        unsigned char BlockHeight;            /* height of block graphics */
        unsigned char BoardWidth;             /* width of board in blocks */
        unsigned char BoardHeight;            /* height of board in blocks */
        BITMAP * Block[NUM_BLOCK_TYPES];      /* block bitmaps */
        BITMAP * BlockErase[NUM_BLOCK_TYPES]; /* blocks when lit */

        unsigned char TileWidth;              /* width of background tiles */
        unsigned char TileHeight;             /* height of background tiles */
        unsigned char FontSize;               /* size of font */
        BITMAP * Tile[NUM_BG_TILES];          /* background tile bitmaps */

        NCDFONT Font;

        unsigned char MapWidth;
        unsigned char MapHeight;
        unsigned char * BGMapData;            /* bg map data */

        short BoardX[MAX_PLAYERS];           /* x location of board1 */
        short BoardY[MAX_PLAYERS];           /* y location of board1 */
        short ScoreX[MAX_PLAYERS];           /* location to draw score */
        short ScoreY[MAX_PLAYERS];           /* location to draw score */
        short NextX[MAX_PLAYERS];
        short NextY[MAX_PLAYERS];
        short LevelX[MAX_PLAYERS];
        short LevelY[MAX_PLAYERS];
        short BlockX[MAX_PLAYERS];
        short BlockY[MAX_PLAYERS];
        short PMessageX[MAX_PLAYERS];
        short PMessageY[MAX_PLAYERS];

        short ClockX;
        short ClockY;
        short HighScoreX;
        short HighScoreY;
        short BestTimeX;
        short BestTimeY;
        short MessageX;
        short MessageY;

        NCDS_SAMPLE * Sound[MAX_SOUNDS];

        } THEME;

int InitializeTheme(THEME * ThemePointer);
int LoadTheme(THEME * ThemePointer, char * FileName, unsigned long Offset);
int SaveTheme(THEME * ThemePointer, char * FileName);
void DestroyTheme(THEME * ThemePointer);

#endif
