#include "includes.h"

int selected_wav = 0;

void import_wav(void)
{
        char TempFileName[256];

        /* set file selector color */
        gui_bg_color = Window[selected_window].hbg;
        gui_fg_color = Window[selected_window].hfg;

        /* choose file to open */
        memset(TempFileName, 0, 256);
        if(!file_select_ex("Choose wave file...", TempFileName, "WAV", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        ncds_free_sample(Theme.Sound[selected_wav]);
        Theme.Sound[selected_wav] = ncds_load_wav(TempFileName);
}


/* initialize palette editor */
void se_init(void)
{
        int i;

        fade_out(3);

        /* point update_proc to the right place */
        update_proc = se_update;

        /* deactivate all the windows */
        for(i = 0; i < WINDOWS; i++)
        {
                deactivate_window(&Window[i]);
        }

        /* activate the editor windows */
        set_window_position(&Window[WINDOW_SOUNDS], (screen_buffer->w >> 1) - (Window[WINDOW_SOUNDS].w >> 1), (screen_buffer->h >> 1) - (Window[WINDOW_SOUNDS].h >> 1));
        activate_window(&Window[WINDOW_SOUNDS]);

        /* fade in */
        update_proc();
        fade_in(ce_palette, 3);

        edited = 1;
}


/* exit palette editor */
void se_exit(void)
{
        /* fade in */
        fade_out(3);

        /* reset editor */
        reset_ce();

        update_proc();
        fade_in(ce_palette, 3);

        /* grab escape press */
        while(key[KEY_ESC])

                update_proc();
}


/* only function the main menu system needs to use */
void edit_sounds(void)
{
        se_init();
        while(!key[KEY_ESC])
        {
                ce_control();
                se_control();
                update_proc();
        }
        while(key[KEY_ESC]);
        se_exit();
}


/* do controls specific to palette editor */
void se_control(void)
{

        /* if user is clicking the left mouse button */
        if(mouse_b & 1)
        {

                /* move the RGB sliders when appropriate */
                if(selected_window == WINDOW_SOUNDS)
                {
                        if(mouse_x > Window[WINDOW_SOUNDS].x && mouse_x < Window[WINDOW_SOUNDS].x + Window[WINDOW_SOUNDS].w)
                        {
                                if(mouse_y > Window[WINDOW_SOUNDS].y + 10 && mouse_y < Window[WINDOW_SOUNDS].y + Window[WINDOW_SOUNDS].h)
                                {
                                        if(mouse_x - Window[WINDOW_SOUNDS].x > 224)
                                        {
                                                selected_wav = (mouse_y - Window[WINDOW_SOUNDS].y - 11) / 10;
                                                ncds_play_sound(Theme.Sound[selected_wav], 128);
                                                while(mouse_b & 1) update_proc();
                                        }
                                        else if(mouse_x - Window[WINDOW_SOUNDS].x > 160 && mouse_x - Window[WINDOW_SOUNDS].x <= 224)
                                        {
                                                selected_wav = (mouse_y - Window[WINDOW_SOUNDS].y - 11) / 10;
                                                ncds_free_sample(Theme.Sound[selected_wav]);
                                                Theme.Sound[selected_wav] = NULL;
                                                while(mouse_b & 1) update_proc();
                                        }
                                        else if(mouse_x - Window[WINDOW_SOUNDS].x > 113 && mouse_x - Window[WINDOW_SOUNDS].x <= 160)
                                        {
                                                selected_wav = (mouse_y - Window[WINDOW_SOUNDS].y - 11) / 10;
                                                while(mouse_b & 1) update_proc();
                                                import_wav();
                                        }
                                }
                        }
                }
        }
}


/* update palette editor windows */
void se_update(void)
{
        int i;

        blit(sounds, Window[WINDOW_SOUNDS].dat.iw.image, 0, 0, 0, 0, sounds->w, sounds->h);
        for(i = 0; i < MAX_SOUNDS; i++)
        {
                if(Theme.Sound[i] != NULL)

                        textout_ex(Window[WINDOW_SOUNDS].dat.iw.image, font, "*", 104, i * 10, Window[WINDOW_SOUNDS].fg, -1);
        }
        redraw_gui();
}
