#include <allegro.h>
#include "palette.h"

/* loads a raw RGB palette */
void load_palette(PALETTE pal, char * fn)
{
    int i;
    PACKFILE * fp;

    fp = pack_fopen(fn, "r");

    for(i = 0; i < 256; i++)
    {
        pal[i].r = pack_getc(fp);
        pal[i].g = pack_getc(fp);
        pal[i].b = pack_getc(fp);
    }

    pack_fclose(fp);
}

/* saves a raw RGB palette */
void save_palette(PALETTE pal, char * fn)
{
    int i;
    PACKFILE * fp;

    fp = pack_fopen(fn, "w");

    for(i = 0; i < 256; i++)
    {
        pack_putc(pal[i].r, fp);
        pack_putc(pal[i].g, fp);
        pack_putc(pal[i].b, fp);
    }

    pack_fclose(fp);
}

/* converts colors in image from one palette to another */
void convert_palette(BITMAP * bp, PALETTE sp, PALETTE dp)
{
    int i, j;
    int Closest;
    int Difference[3];
    unsigned char ColorMap[256];

    /* in case someone is using non-transparent black */
    int other_black = 0;

    /* figure out the color map */
    for(i = 0; i < 256; i++)
    {
        Closest = 1000;
        for(j = 0; j < 256; j++)
        {
            Difference[0] = sp[i].r - dp[j].r;
            if(Difference[0] < 0)
            {
                Difference[0] = -Difference[0];
            }
            Difference[1] = sp[i].g - dp[j].g;
            if(Difference[1] < 0)
            {
                Difference[1] = -Difference[1];
            }
            Difference[2] = sp[i].b - dp[j].b;
            if(Difference[2] < 0)
            {
                Difference[2] = -Difference[2];
            }
            if((Difference[0] + Difference[1] + Difference[2]) < Closest)
            {
                Closest = Difference[0] + Difference[1] + Difference[2];
                ColorMap[i] = j;
            }
        }
        /* map the "other" black */
        if(dp[i].r == 0 && dp[i].g == 0 && dp[i].b == 0)
        {
            other_black = i;
        }
    }

    /* map the colors to the picture */
    for(i = 0; i < bp->h; i++)
    {
        for(j = 0; j < bp->w; j++)
        {
            /* do this if non-transparent black */
            if(bp->line[i][j] != 0 && sp[bp->line[i][j]].r == 0 && sp[bp->line[i][j]].g == 0 && sp[bp->line[i][j]].b == 0)
            {
                bp->line[i][j] = other_black;
            }

            /* otherwise convert normally */
            else
            {
                bp->line[i][j] = ColorMap[bp->line[i][j]];
            }
        }
    }
}

void copy_palette(PALETTE sp, PALETTE dp)
{
    int i;

    for(i = 0; i < 256; i++)
    {
        dp[i].r = sp[i].r;
        dp[i].g = sp[i].g;
        dp[i].b = sp[i].b;
    }
}
