#ifndef CE_H
#define CE_H

#define GUI_BG   makecol(195, 195, 227)
#define GUI_FG   makecol(35, 35, 67)
#define GUI_HBG  makecol(223, 223, 255)
#define GUI_HFG  makecol(67, 67, 99)
#define GUI_MHBG makecol(0, 0, 35)
#define GUI_MHFG makecol(223, 223, 255)

typedef struct
{

        int c, rx, ry, fs, bs, bw, bh, tw, th;
        char fullbg;
        NCDFONT tempfont;

} SETTINGS;

/* default theme settings */
#define DF_FONT_WIDTH    8
#define DF_FONT_HEIGHT   8
#define DF_BLOCK_WIDTH  10
#define DF_BLOCK_HEIGHT 10
#define DF_BOARD_WIDTH   6
#define DF_BOARD_HEIGHT 14
#define DF_TILE_WIDTH   20
#define DF_TILE_HEIGHT  20

void make_main_menu(void);
void reset_ce(void);
void redraw_gui_edit(void);
void redraw_gui(void);
void gui_load_theme(void);
void gui_save_theme(void);
void grab_image(BITMAP * dp, char * filename);
void try_quit(void);
void save_exit(void);
void initialize_ce(void);
void exit_ce(void);
void ce_quit(void);
void ce_update(void);
void ce_convert(void);
void run_ce(void);

#endif
