#include "includes.h"

BITMAP * blpts[NUM_BLOCK_TYPES * 2];

void be_export(void)
{
        char TempFileName[256];
        int i, j, k;
        PACKFILE * file;

        /* set file selector color */
        gui_bg_color = Window[selected_window].hbg;
        gui_fg_color = Window[selected_window].hfg;

        strcpy(TempFileName, "");
        if(!file_select_ex("Enter blockset filename...", TempFileName, "BST", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        replace_extension(TempFileName, TempFileName, "BST", 256);

        file = pack_fopen(TempFileName, "w");

        pack_putc(Theme.BlockWidth, file);
        pack_putc(Theme.BlockHeight, file);

        for(i = 0; i < NUM_BLOCK_TYPES; i++)

                for(j = 0; j < Theme.BlockHeight; j++)

                        for(k = 0; k < Theme.BlockWidth; k++)
                        {
                                pack_putc(Theme.Block[i]->line[j][k], file);
                                pack_putc(Theme.BlockErase[i]->line[j][k], file);
                        }

        pack_fclose(file);
}


void be_import(void)
{
        char TempFileName[256];
        int i, j, k;
        PACKFILE * file;

        /* set file selector color */
        gui_bg_color = Window[selected_window].hbg;
        gui_fg_color = Window[selected_window].hfg;

        strcpy(TempFileName, "");
        if(!file_select_ex("Choose blockset file...", TempFileName, "BST", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }
        file = pack_fopen(TempFileName, "r");

        Theme.BlockWidth = pack_getc(file);
        Theme.BlockHeight = pack_getc(file);

        for(i = 0; i < NUM_BLOCK_TYPES; i++)
        {

                destroy_bitmap(Theme.Block[i]);
                destroy_bitmap(Theme.BlockErase[i]);
                Theme.Block[i] = create_bitmap(Theme.BlockWidth, Theme.BlockHeight);
                Theme.BlockErase[i] = create_bitmap(Theme.BlockWidth, Theme.BlockHeight);
                for(j = 0; j < Theme.BlockHeight; j++)

                        for(k = 0; k < Theme.BlockWidth; k++)
                        {
                                Theme.Block[i]->line[j][k] = pack_getc(file);
                                Theme.BlockErase[i]->line[j][k] = pack_getc(file);
                        }
        }
        pack_fclose(file);
}


void be_grab(void)
{
        char TempFileName[256];

        /* set file selector color */
        gui_bg_color = Window[selected_window].hbg;
        gui_fg_color = Window[selected_window].hfg;

        memset(TempFileName, 0, 256);
        if(!file_select_ex("Select file to grab from...", TempFileName, "PCX", 256, SCREEN_W, SCREEN_H))
        {
                while(key[KEY_ESC] || key[KEY_ENTER]);
                return;
        }

        grab_image(blpts[selected_image], TempFileName);
}


void be_init(void)
{
        int i;

        fade_out(3);

        destroy_bitmap(screen_buffer);
        set_gfx_mode(GFX_AUTODETECT, Theme.ResX, Theme.ResY, Theme.ResX, Theme.ResY);
        clear(screen);
        set_palette(black_palette);
        screen_buffer = create_bitmap(Theme.ResX, Theme.ResY);

        for(i = 0; i < NUM_BLOCK_TYPES; i++)
        {
                blpts[i] = Theme.Block[i];
                blpts[i + NUM_BLOCK_TYPES] = Theme.BlockErase[i];
        }

        /* point update_proc to the right place */
        update_proc = be_update;

        /* deactivate all the windows */
        for(i = 0; i < WINDOWS; i++)
        {
                deactivate_window(&Window[i]);
        }

        select_palette(Theme.Palette);
        /* set up and activate file window */
        clear_menu(&Window[WINDOW_FILE]);
        set_window_color(&Window[WINDOW_FILE], GUI_BG, GUI_FG, GUI_HBG, GUI_HFG, GUI_MHBG, GUI_MHFG);
        add_menu_item(&Window[WINDOW_FILE], "Import", -1, be_import);
        add_menu_item(&Window[WINDOW_FILE], "Export", -1, be_export);
        add_menu_item(&Window[WINDOW_FILE], "Grab", -1, be_grab);
        set_window_position(&Window[WINDOW_FILE], screen_buffer->w - Window[WINDOW_FILE].w - 10, 35);
        select_window(&Window[WINDOW_FILE]);
        selected_window = WINDOW_FILE;
        make_closest(ce_zbuffer, WINDOW_FILE, WINDOWS);
        activate_window(&Window[WINDOW_FILE]);

        /* get editor windows ready */
        destroy_window(&Window[WINDOW_ISELECT]);
        create_window(&Window[WINDOW_ISELECT], TYPE_IMAGE, "Pics");
        import_image(&Window[WINDOW_ISELECT], create_bitmap(NUM_BLOCK_TYPES * Theme.BlockWidth, 2 * Theme.BlockHeight));
        clear(Window[WINDOW_ISELECT].dat.iw.image);
        destroy_window(&Window[WINDOW_IEDIT]);
        create_window(&Window[WINDOW_IEDIT], TYPE_IMAGE, "Edit");
        import_image(&Window[WINDOW_IEDIT], create_bitmap(Theme.BlockWidth * edit_scale, Theme.BlockHeight * edit_scale));
        clear(Window[WINDOW_IEDIT].dat.iw.image);

        /* activate the editor windows */
        set_window_position(&Window[WINDOW_ISELECT], 47, 35);
        activate_window(&Window[WINDOW_ISELECT]);
        set_window_position(&Window[WINDOW_IEDIT], Window[WINDOW_ISELECT].x + Window[WINDOW_ISELECT].w + 1, Window[WINDOW_ISELECT].y);
        activate_window(&Window[WINDOW_IEDIT]);
        unselect_palette();

        /* set other variables */
        selected_image = 0;
        copy_image = 0;
        selected_tool = TOOLTYPE_BRUSH;

        update_proc();
        fade_in(Theme.Palette, 3);

        edited = 1;
}


void be_exit(void)
{
        fade_out(3);

        /* reset editor */
        reset_ce();
        update_proc();
        fade_in(ce_palette, 3);

        /* grab escape press */
        while(key[KEY_ESC])

                update_proc();
}


/* function called by the edit menu */
void edit_block(void)
{
        be_init();
        while(!key[KEY_ESC])
        {
                ce_control();
                be_control();
                update_proc();
        }
        while(key[KEY_ESC]);

        be_exit();
}


void be_update(void)
{
        int i;

        clear(Window[WINDOW_ISELECT].dat.iw.image);

        for(i = 0; i < NUM_BLOCK_TYPES; i++)
        {
                blit(Theme.Block[i], Window[WINDOW_ISELECT].dat.iw.image, 0, 0, i * Theme.BlockWidth, 0, Window[WINDOW_ISELECT].dat.iw.image->w, Window[WINDOW_ISELECT].dat.iw.image->h);
                blit(Theme.BlockErase[i], Window[WINDOW_ISELECT].dat.iw.image, 0, 0, i * Theme.BlockWidth, Theme.BlockHeight, Window[WINDOW_ISELECT].dat.iw.image->w, Window[WINDOW_ISELECT].dat.iw.image->h);
        }
        if(highlight)

                rect(Window[WINDOW_ISELECT].dat.iw.image, selected_image % NUM_BLOCK_TYPES * Theme.BlockWidth, selected_image / NUM_BLOCK_TYPES * Theme.BlockHeight, selected_image % NUM_BLOCK_TYPES * Theme.BlockWidth + Theme.BlockWidth - 1, selected_image / NUM_BLOCK_TYPES * Theme.BlockHeight + Theme.BlockHeight - 1, Window[selected_window].bg);

        highlight ^= 1;

        stretch_blit(blpts[selected_image], Window[WINDOW_IEDIT].dat.iw.image, 0, 0, Theme.BlockWidth, Theme.BlockHeight, 0, 0, Theme.BlockWidth * edit_scale, Theme.BlockHeight * edit_scale);

        redraw_gui_edit();
}


void be_control(void)
{
        int pegx, pegy;

        /* update pegs for drawing tools */
        pegx = mouse_x;
        pegy = mouse_y;

        select_tool();
        select_color();

        if(mouse_b & 1)
        {

                /* select tile if clicking on tile display window */
                if(selected_window == WINDOW_ISELECT && mouse_x > Window[WINDOW_ISELECT].x && mouse_x < Window[WINDOW_ISELECT].x + Window[WINDOW_ISELECT].w && mouse_y > Window[WINDOW_ISELECT].y + 10 && mouse_y < Window[WINDOW_ISELECT].y + Window[WINDOW_ISELECT].h)
                {
                        selected_image = (mouse_x - (Window[WINDOW_ISELECT].x + 1)) / Theme.BlockWidth + (((mouse_y - (Window[WINDOW_ISELECT].y + 11)) / Theme.BlockHeight) * NUM_BLOCK_TYPES);
                        if(selected_image >= NUM_BLOCK_TYPES * 2)

                                selected_image = NUM_BLOCK_TYPES * 2 - 1;
                }

                /* draw using selected tool if clicking on edit window */
                if(selected_window == WINDOW_IEDIT && mouse_x > Window[WINDOW_IEDIT].x + 1 && mouse_x < Window[WINDOW_IEDIT].x + Window[WINDOW_IEDIT].w - 1 && mouse_y > Window[WINDOW_IEDIT].y + 11 && mouse_y < Window[WINDOW_IEDIT].y + Window[WINDOW_IEDIT].h - 1)
                {
                        if(selected_tool == TOOLTYPE_BRUSH)

                                DoBrush(blpts[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, left_color);

                        else if(selected_tool == TOOLTYPE_DROPPER)

                                left_color = DoDropper(blpts[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale);

                        else if(selected_tool == TOOLTYPE_ERASE)

                                DoErase(blpts[selected_image], left_color);

                        else if(selected_tool == TOOLTYPE_FILL)

                                DoFill(blpts[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, left_color);

                        else if(selected_tool == TOOLTYPE_REPLACE)

                                DoReplace(blpts[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, left_color);

                        else if(selected_tool == TOOLTYPE_LINE)

                                DoLine(blpts[selected_image], 1, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, left_color, update_proc);

                        else if(selected_tool == TOOLTYPE_RECT)

                                DoRect(blpts[selected_image], 1, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, left_color, update_proc);

                        else if(selected_tool == TOOLTYPE_FRECT)

                                DoFRect(blpts[selected_image], 1, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, left_color, update_proc);

                        else if(selected_tool == TOOLTYPE_CIRCLE)

                                DoCircle(blpts[selected_image], 1, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, left_color, update_proc);

                        else if(selected_tool == TOOLTYPE_FCIRCLE)

                                DoFCircle(blpts[selected_image], 1, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, left_color, update_proc);
                }
        }
        if(mouse_b & 2)
        {
                /* draw using selected tool if clicking on edit window */
                if(selected_window == WINDOW_IEDIT && mouse_x > Window[WINDOW_IEDIT].x + 1 && mouse_x < Window[WINDOW_IEDIT].x + Window[WINDOW_IEDIT].w - 1 && mouse_y > Window[WINDOW_IEDIT].y + 11 && mouse_y < Window[WINDOW_IEDIT].y + Window[WINDOW_IEDIT].h - 1)
                {
                        if(selected_tool == TOOLTYPE_BRUSH)

                                DoBrush(blpts[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, right_color);

                        else if(selected_tool == TOOLTYPE_DROPPER)

                                right_color = DoDropper(blpts[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale);

                        else if(selected_tool == TOOLTYPE_ERASE)

                                DoErase(blpts[selected_image], right_color);

                        else if(selected_tool == TOOLTYPE_FILL)

                                DoFill(blpts[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, right_color);

                        else if(selected_tool == TOOLTYPE_REPLACE)

                                DoReplace(blpts[selected_image], (mouse_x - (Window[WINDOW_IEDIT].x + 1)) / edit_scale, (mouse_y - (Window[WINDOW_IEDIT].y + 11)) / edit_scale, right_color);

                        else if(selected_tool == TOOLTYPE_LINE)

                                DoLine(blpts[selected_image], 2, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, right_color, update_proc);

                        else if(selected_tool == TOOLTYPE_RECT)

                                DoRect(blpts[selected_image], 2, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, right_color, update_proc);

                        else if(selected_tool == TOOLTYPE_FRECT)

                                DoFRect(blpts[selected_image], 2, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, right_color, update_proc);

                        else if(selected_tool == TOOLTYPE_CIRCLE)

                                DoCircle(blpts[selected_image], 2, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, right_color, update_proc);

                        else if(selected_tool == TOOLTYPE_FCIRCLE)

                                DoFCircle(blpts[selected_image], 2, pegx, pegy, (Window[WINDOW_IEDIT].x + 1), (Window[WINDOW_IEDIT].y + 11), edit_scale, right_color, update_proc);
                }
        }

        if(key[KEY_C])

                copy_image = selected_image;

        if(key[KEY_P])

                blit(blpts[copy_image], blpts[selected_image], 0, 0, 0, 0, Theme.BlockWidth, Theme.BlockHeight);

        if(key[KEY_MINUS] && edit_scale > 4)
        {
                edit_scale--;
                delete_image(&Window[WINDOW_IEDIT]);
                import_image(&Window[WINDOW_IEDIT], create_bitmap(Theme.BlockWidth * edit_scale, Theme.BlockHeight * edit_scale));
                deselect_all();
                select_window(&Window[WINDOW_IEDIT]);
                selected_window = WINDOW_IEDIT;
                make_closest(ce_zbuffer, WINDOW_IEDIT, WINDOWS);
                while(key[KEY_MINUS]);
        }
        if(key[KEY_EQUALS])
        {
                edit_scale++;
                delete_image(&Window[WINDOW_IEDIT]);
                import_image(&Window[WINDOW_IEDIT], create_bitmap(Theme.BlockHeight * edit_scale, Theme.BlockWidth * edit_scale));
                deselect_all();
                select_window(&Window[WINDOW_IEDIT]);
                selected_window = WINDOW_IEDIT;
                make_closest(ce_zbuffer, WINDOW_IEDIT, WINDOWS);
                while(key[KEY_EQUALS]);
        }
        if(key[KEY_UP])
        {
                if(selected_image >= NUM_BLOCK_TYPES)

                        selected_image -= NUM_BLOCK_TYPES;

                while(key[KEY_UP]);
        }
        if(key[KEY_DOWN])
        {
                if(selected_image < NUM_BLOCK_TYPES)

                        selected_image += NUM_BLOCK_TYPES;

                while(key[KEY_DOWN]);
        }
        if(key[KEY_LEFT])
        {
                if(selected_image > 0)

                        selected_image--;

                while(key[KEY_LEFT]);
        }
        if(key[KEY_RIGHT])
        {
                if(selected_image < NUM_BLOCK_TYPES * 2 - 1)

                        selected_image++;

                while(key[KEY_RIGHT]);
        }
}
