#include <stdio.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>
#if defined(__DECC) && defined(VMS)
#include <unixlib.h>
static char *vms_to_unix_buffer = NULL;
static int convert_vms_to_unix(char *vms_dir_name)
{
	vms_to_unix_buffer = vms_dir_name;
}
#endif

/* 
 * Locate user's home directory.
 */
char *get_home_dir(void)
{
	struct passwd *pw;

	if (!(pw = getpwuid(getuid())))
	{ 
		fprintf(stderr, "Who are you? Not found in passwd database!!\n");
		return NULL;
	}

#if defined(__DECC) && defined(VMS)
	/* Convert The OpenVMS Formatted "$HOME" Directory Path Into Unix
	   Format. */
	decc$from_vms(pw->pw_dir, convert_vms_to_unix, 1);
	return vms_to_unix_buffer;
#else
	return pw->pw_dir;
#endif
}
