/* Routines for displaying the T^3 Logo and Crystal Stacker */
/* title screen (c)2000 T^3 Software.                       */

#include "includes.h"
#include "externs.h"


/* logo data */
BITMAP * t3_logo_bg_image;
BITMAP * t3_logo_flash_image[2];
PALETTE  t3_logo_palette;
char     logo_done = 0;
int      logo_frame = 0;


/* sound to play on logo screen */
MSAMPLE * t3_logo_sound;

/* get ready to show the logo screen */
void initialize_logo(void)
{
    /* sets graphics mode (320x200) */
    cs_gfx_mode(320, 240, black_palette);
    screen_buffer = create_bitmap(320, 240);
    clear(screen_buffer);
    clear(screen);

    /* load logo images */
    t3_logo_bg_image = load_pcx(DATADIR "cs.dat#t3logo", t3_logo_palette);
    t3_logo_flash_image[0] = load_pcx(DATADIR "cs.dat#t3logoa", NULL);
    t3_logo_flash_image[1] = load_pcx(DATADIR "cs.dat#t3logob", NULL);

    /* load logo sound effect */
    t3_logo_sound = t3ss_load_wav_fn(DATADIR "cs.dat#logo_sound");
}


/* get ready to go to something else */
void exit_logo(void)
{
    /* free logo images */
    destroy_bitmap(t3_logo_bg_image);
    destroy_bitmap(t3_logo_flash_image[0]);
    destroy_bitmap(t3_logo_flash_image[1]);

    /* free data from memory */
    t3ss_free_wav(t3_logo_sound);
}


/* go to next frame of logo animation */
void logo_step(void)
{
    /* increase the frame */
    logo_frame++;

    /* set done after all frames are done */
    if(logo_frame >= 240)
    {
        logo_done = 1;
    }
}


/* draw stuff on the screen */
void update_logo_screen(void)
{
    /* sync drawing with monitor */
    vsync();

    /* play the logo sound on frame 161 */
    if(logo_frame == 161)
    {
        t3ss_play_sound(t3_logo_sound, 128, 22050);
    }

    /* display appropriate logo pic for frame */
    if(logo_frame > 160 && logo_frame <= 165)
    {
        blit(t3_logo_flash_image[1], screen_buffer, 0, 0, 0, LOGO_Y, 320, 240);
    }

    else if(logo_frame > 165 && logo_frame <= 170)
    {
        blit(t3_logo_flash_image[0], screen_buffer, 0, 0, 0, LOGO_Y, 320, 240);
    }
    else if(logo_frame > 170 && logo_frame <= 175)
    {
        blit(t3_logo_flash_image[1], screen_buffer, 0, 0, 0, LOGO_Y, 320, 240);
    }
    else if(logo_frame > 175 && logo_frame <= 180)
    {
        blit(t3_logo_flash_image[0], screen_buffer, 0, 0, 0, LOGO_Y, 320, 240);
    }
    cs_screen_blit(screen_buffer, 0, 0);
}


/* function to call when wanting to display logo screen */
/* does everything                                      */
void t3_logo(void)
{
	int i;

    /* get system ready */
    initialize_logo();

    /* draw the logo and do fade */
//    set_palette(t3_logo_palette);
//    gef_smear_in(t3_logo_bg_image);
    blit(t3_logo_bg_image, screen_buffer, 0, 0, 0, 0, 320, 240);
    cs_screen_blit(screen_buffer, 0, 0);
    t3ss_play_sound(t3_logo_sound, 128, 22050);
    fade_in(t3_logo_palette, 2);
    i = 0;
    while(!key[KEY_ESC] && !key[KEY_ENTER] && !key[KEY_SPACE] && !ncd_joy_button(0, 0) && i < 120)
    {
        ncd_joy_poll();
	    i++;
	    vsync();
    }

    /* step through the logo animation until done or key pressed */
//    while(!key[KEY_ESC] && !key[KEY_ENTER] && !key[KEY_SPACE] && !ncd_joy_button(0, 0) && !logo_done)
//    {
//        ncd_joy_poll();
//        logo_step();
//        update_logo_screen();
//    }

    /* do the transition effect */
    if(cs_options.transitions)
    {
        t3ss_play_sound(cs_sound[SOUND_MENU_SWOOSH], 128, 22050);
        gef_split_out_horizontal(t3_logo_bg_image);
    }
    else
    {
        fade_out(3);
    }

    /* unload logo data */
    exit_logo();
}
