#include "includes.h"
#include "externs.h"

unsigned long Scores[10] = {4000, 3000, 2500, 1800, 1400, 1000, 800, 600, 400, 200};
unsigned long IScores[10] = {300, 250, 200, 180, 160, 140, 100, 80, 60, 40};
int Seconds[10] = {40, 50, 70, 90, 120, 150, 190, 230, 280, 330};
int fred = 0;
int fdark = 0;

/* loads high score file */
int cs_load_scores(CS_TOP10 * Scores, char * fn)
{
    PACKFILE * file;
    int i, j;
    char Header[4];

    file = pack_fopen(fn, "r");
    if(file == NULL)
    {
        return 0;
    }

    /* check header */
    pack_fread(&Header, 4, file);
    if(Header[0] != 'H' || Header[1] != 'S' || Header[2] != 'C' || Header[3] != 21)
    {
        pack_fclose(file);
        return 0;
    }

    /* load normal top 10 */
    for(i = 0; i < 10; i++)
    {
        Scores->classic_name[i] = malloc(21);
        memset(Scores->classic_name[i], 0, 21);
        pack_fread(Scores->classic_name[i], 21, file);
        Scores->classic_score[i] = pack_igetl(file);
    }

    /* load frenzy top 10s */
    for(i = 0; i < 10; i++)
    {
        for(j = 0; j < 10; j++)
        {
            Scores->frenzy_name[i][j] = malloc(21);
            memset(Scores->frenzy_name[i][j], 0, 21);
            pack_fread(Scores->frenzy_name[i][j], 21, file);
            Scores->frenzy_score[i][j] = pack_igetl(file);
        }
    }

    /* load destroyer top 10s */
    for(i = 0; i < 10; i++)
    {
        for(j = 0; j < 10; j++)
        {
            Scores->destroyer_name[i][j] = malloc(21);
            memset(Scores->destroyer_name[i][j], 0, 21);
            pack_fread(Scores->destroyer_name[i][j], 21, file);
            Scores->destroyer_minutes[i][j] = pack_getc(file);
            Scores->destroyer_seconds[i][j] = pack_getc(file);
        }
    }
    pack_fclose(file);

    return 1;
}

/* saves high score file */
int cs_save_scores(CS_TOP10 * Scores, char * fn)
{
    PACKFILE * file;
    int i, j;
    char Header[4] = {'H', 'S', 'C', 21};

    file = pack_fopen(fn, "w");
    if(file == NULL)
    {
        return 0;
    }

    /* write header */
    pack_fwrite(&Header, 4, file);

    /* write normal top 10 */
    for(i = 0; i < 10; i++)
    {
        pack_fwrite(Scores->classic_name[i], 21, file);
        pack_iputl(Scores->classic_score[i], file);
    }

    /* write frenzy top 10s */
    for(i = 0; i < 10; i++)
    {
        for(j = 0; j < 10; j++)
        {
            pack_fwrite(Scores->frenzy_name[i][j], 21, file);
            pack_iputl(Scores->frenzy_score[i][j], file);
        }
    }

    /* write destroyer top 10s */
    for(i = 0; i < 10; i++)
    {
        for(j = 0; j < 10; j++)
        {
            pack_fwrite(Scores->destroyer_name[i][j], 21, file);
            pack_putc(Scores->destroyer_minutes[i][j], file);
            pack_putc(Scores->destroyer_seconds[i][j], file);
        }
    }
    pack_fclose(file);

    return 1;
}

/* free high scores from memory */
void cs_destroy_scores(CS_TOP10 * sp)
{
    int i, j;

    for(i = 0; i < 10; i++)
    {
        free(sp->classic_name[i]);
    }
    for(i = 0; i < 10; i++)
    {
        for(j = 0; j < 10; j++)
        {
            free(sp->frenzy_name[i][j]);
            free(sp->destroyer_name[i][j]);
        }
    }
}

/* allow player to enter their name on the high score table */
char * cs_get_string(BITMAP * bp, NCDFONT * fp, CS_TOP10 * sp, int mode, int x, int y)
{
    char * TempString;
    char TempKey = 0x0;
    int CurrentChar = 0;
    int loop_done = 0;

//    text_mode(-1);

    /* make sure we can type normally */
    clear_keybuf();

    /* allocate string */
    TempString = malloc(256);
    memset(TempString, 0, 256);

    /* stay in loop until enter pressed */
    while(!loop_done)
    {
   		/* redraw the current string */
   		blit(cs_menu_bg_image, bp, 0, 0, 0, 0, 320, 240);
 		draw_sprite(bp, cs_high_score_image, 0, MLOGO_Y);
   		draw_high_scores_pos(bp, fp, sp, mode, 0, 0, 2);
   		ncd_textout(bp, fred ? &cs_big_menu_font_red : &cs_big_menu_font_green, x, y, TempString);
   		ncd_textout(bp, fred ? &cs_big_menu_font_red : &cs_big_menu_font_green, x + strlen(TempString) * cs_big_menu_font_green.w, y, "_");
   		cs_vsync();
   		cs_screen_blit(bp, 0, 0);

	    if(keypressed())
	    {
       		/* retrieve the next key */
       		TempKey = readkey() & 0xFF;
       		t3ss_play_sound(cs_sound[SOUND_MENU_TYPE], 128, 22050);

       		/* handle backspace */
       		if(TempKey == 0x8)
       		{
           		TempString[CurrentChar] = '\0';
           		if(CurrentChar > 0)
           		{
               		CurrentChar--;
               		TempString[CurrentChar] = '\0';
           		}
       		}

       		/* tag NULL at end so string is complete */
       		else if(TempKey != 0xD && TempKey != 0x1B && CurrentChar < 20)
       		{
           		TempString[CurrentChar] = TempKey;
           		CurrentChar++;
           		TempString[CurrentChar] = '\0';
       		}
       		
       		else if(TempKey == 0xD || TempKey == 0x1B)
       		{
           		loop_done = 1;
       		}
		}
	}
    t3ss_play_sound(cs_sound[SOUND_ENTER_NAME], 128, 22050);

    /* return the string */
    return TempString;
}

/* create a blank score table */
void cs_clear_scores(void)
{
    int i, j;

    for(i = 0; i < 10; i++)
    {
        cs_scores.classic_name[i] = malloc(21);
        memset(cs_scores.classic_name[i], 0, 21);
    }

    /* load frenzy top 10s */
    for(i = 0; i < 10; i++)
    {
        for(j = 0; j < 10; j++)
        {
            cs_scores.frenzy_name[i][j] = malloc(21);
            memset(cs_scores.frenzy_name[i][j], 0, 21);
        }
    }

    /* load destroyer top 10s */
    for(i = 0; i < 10; i++)
    {
        for(j = 0; j < 10; j++)
        {
            cs_scores.destroyer_name[i][j] = malloc(21);
            memset(cs_scores.destroyer_name[i][j], 0, 21);
        }
    }
}

/* make default scores table */
void cs_reset_scores(void)
{
    int i, j;

    cs_clear_scores();
    for(i = 0; i < 10; i++)
    {
        strcpy(cs_scores.classic_name[i], "T3 Software");
        cs_scores.classic_score[i] = Scores[i];
    }
    for(i = 0; i < 10; i++)
    {
        for(j = 0; j < 10; j++)
        {
            strcpy(cs_scores.frenzy_name[i][j], "T3 Software");
            cs_scores.frenzy_score[i][j] = IScores[j] * (i + 1);
        }
    }
    for(i = 0; i < 10; i++)
    {
        for(j = 0; j < 10; j++)
        {
            strcpy(cs_scores.destroyer_name[i][j], "T3 Software");
            cs_scores.destroyer_minutes[i][j] = (Seconds[j] * (i + 1)) / 60;
            cs_scores.destroyer_seconds[i][j] = (Seconds[j] * (i + 1)) % 60;
        }
    }
}

/* set up high score mode */
void cs_initialize_scores(CS_TOP10 * Scores)
{
    cs_gfx_mode(320, 240, cs_options.transitions ? screen_palette : black_palette);
}

/* ready to go back to menu */
void cs_exit_scores(CS_TOP10 * Scores)
{
    cs_save_scores(Scores, cs_get_config_file_name("hs"));
}

/* see what place a score is on the table */
int cs_place_score(CS_GAME * gp, CS_TOP10 * sp)
{
    int i;

    /* classic mode scores */
    if(gp->mode == CS_1NS)
    {
        for(i = 0; i < 10; i++)
        {
            if(gp->score >= sp->classic_score[i])
            {
                return i;
            }
        }
        return 10;
    }

    /* frenzy mode scores */
    else if(gp->mode == CS_1TF)
    {
        for(i = 0; i < 10; i++)
        {
            if(gp->score >= sp->frenzy_score[cs_options.time_index][i])
            {
                return i;
            }
        }
        return 10;
    }

    /* destroyer mode times */
    else if(gp->mode == CS_1TD)
    {
        for(i = 0; i < 10; i++)
        {
            if(cs_clock.minutes * 60 + cs_clock.seconds <= sp->destroyer_minutes[cs_options.block_index][i] * 60 + sp->destroyer_seconds[cs_options.block_index][i])
            {
                return i;
            }
        }
        return 10;
    }
    return 10;
}

/* make room for player to enter name */
void cs_make_room(CS_GAME * gp, CS_TOP10 * sp, int place)
{
    int i;

    /* classic mode */
    if(gp->mode == CS_1NS)
    {
        /* move scores down */
        for(i = 8; i >= place; i--)
        {
            strcpy(sp->classic_name[i + 1], sp->classic_name[i]);
            sp->classic_score[i + 1] = sp->classic_score[i];
        }

        /* blank the name (ready for user to type theirs) */
        strcpy(sp->classic_name[place], "");

        /* get the player's score */
        sp->classic_score[place] = gp->score;
    }

    /* frenzy mode */
    else if(gp->mode == CS_1TF)
    {
        /* move scores down */
        for(i = 8; i >= place; i--)
        {
            strcpy(sp->frenzy_name[cs_options.time_index][i + 1], sp->frenzy_name[cs_options.time_index][i]);
            sp->frenzy_score[cs_options.time_index][i + 1] = sp->frenzy_score[cs_options.time_index][i];
        }

        /* blank the name */
        strcpy(sp->frenzy_name[cs_options.time_index][place], "");

        /* get the player's score */
        sp->frenzy_score[cs_options.time_index][place] = gp->score;
    }

    /* destroyer mode */
    else if(gp->mode == CS_1TD)
    {
        /* moves scores down */
        for(i = 8; i >= place; i--)
        {
            strcpy(sp->destroyer_name[cs_options.block_index][i + 1], sp->destroyer_name[cs_options.block_index][i]);
            sp->destroyer_minutes[cs_options.block_index][i + 1] = sp->destroyer_minutes[cs_options.block_index][i];
            sp->destroyer_seconds[cs_options.block_index][i + 1] = sp->destroyer_seconds[cs_options.block_index][i];
        }

        /* blank name */
        strcpy(sp->destroyer_name[cs_options.block_index][place], "");

        /* get player's time */
        sp->destroyer_minutes[cs_options.block_index][place] = cs_clock.minutes;
        sp->destroyer_seconds[cs_options.block_index][place] = cs_clock.seconds;
    }
}

/* allow user to enter name */
void cs_enter_name(CS_GAME * gp, CS_TOP10 * Scores, int place, int mode)
{
    char * TempString = NULL;

    /* show green text if in top 3 */
    if(place < 3)
    {
        fred = 0;
    }

    /* otherwise show red text */
    else
    {
        fred = 1;
    }

    /* classic mode */
    if(gp->mode == CS_1NS)
    {
        TempString = cs_get_string(screen_buffer, &cs_menu_font, Scores, 0, 34, HISCORE_Y + place * cs_big_menu_font_green.h);
        strcpy(Scores->classic_name[place], TempString);
    }

    /* destroyer mode */
    else if(gp->mode == CS_1TD)
    {
        TempString = cs_get_string(screen_buffer, &cs_menu_font, Scores, 1 + cs_options.block_index, 34, HISCORE_Y + place * cs_big_menu_font_green.h);
        strcpy(Scores->destroyer_name[cs_options.block_index][place], TempString);
    }

    /* frenzy mode */
    else if(gp->mode == CS_1TF)
    {
        TempString = cs_get_string(screen_buffer, &cs_menu_font, Scores, 11 + cs_options.time_index, 34, HISCORE_Y + place * cs_big_menu_font_green.h);
        strcpy(Scores->frenzy_name[cs_options.time_index][place], TempString);
    }

    /* free the string (allocated in cs_get_string()) */
    free(TempString);

    /* so scores don't appear dark unless they're supposed to */
    fdark = 0;
}

/* draw the scores */
void draw_high_scores(BITMAP * bp, NCDFONT * fp, CS_TOP10 * sp, int mode)
{
    int i;

    /* classic mode */
    if(mode == 0)
    {
        for(i = 0; i < 10; i++)
        {
            ncd_textout(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34, HISCORE_Y + i * cs_big_menu_font_green.h, sp->classic_name[i]);
            ncd_draw_number_right(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + 16 * cs_big_menu_font_green.w, HISCORE_Y + i * cs_big_menu_font_green.h, sp->classic_score[i], 5);
        }
        ncd_textout_center(bp, &cs_menu_font, 0, 231, "Classic Mode");
    }

    /* destroyer_mode */
    else if(mode < 11)
    {
        for(i = 0; i < 10; i++)
        {
            ncd_textout(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34, HISCORE_Y + i * cs_big_menu_font_green.h, sp->destroyer_name[mode - 1][i]);
            ncd_draw_number(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + 16 * cs_big_menu_font_green.w, HISCORE_Y + i * cs_big_menu_font_green.h, sp->destroyer_minutes[mode - 1][i], 2);
            ncd_textout(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + 18 * cs_big_menu_font_green.w, HISCORE_Y + i * cs_big_menu_font_green.h, ":");
            ncd_draw_number(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + 19 * cs_big_menu_font_green.w, HISCORE_Y + i * cs_big_menu_font_green.h, sp->destroyer_seconds[mode - 1][i], 2);
        }
        ncd_printf_center(bp, &cs_menu_font, 0, 231, "Destroyer Mode (%d Blocks)", block_chart[mode - 1]);
    }

    /* frenzy mode */
    else if(mode < 21)
    {
        for(i = 0; i < 10; i++)
        {
            ncd_textout(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34, HISCORE_Y + i * cs_big_menu_font_green.w, sp->frenzy_name[mode - 11][i]);
            ncd_draw_number_right(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + 16 * cs_big_menu_font_green.w, HISCORE_Y + i * cs_big_menu_font_green.h, sp->frenzy_score[mode - 11][i], 5);
        }
        ncd_printf_center(bp, &cs_menu_font, 0, 231, "Frenzy Mode (  :  )");
        ncd_draw_number(bp, &cs_menu_font, 192, 231, time_minutes_chart[mode - 11], 2);
        ncd_draw_number(bp, &cs_menu_font, 216, 231, time_seconds_chart[mode - 11], 2);
    }
}

/* draws the scores at the specified location */
void draw_high_scores_pos(BITMAP * bp, NCDFONT * fp, CS_TOP10 * sp, int mode, int ox, int oy, int sub)
{
    int i;

    /* classic mode */
    if(mode == 0)
    {
        for(i = 0; i < 10; i++)
        {
            /* draw normal if it's not set to be dark */
            if(i == fdark - 1 || fdark <= 0)
            {
                ncd_textout(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy, sp->classic_name[i]);
                ncd_draw_number_right(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + 16 * cs_big_menu_font_green.w + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy, sp->classic_score[i], 5);
            }

            /* draw it dark otherwise */
            else
            {
                ncd_textout(bp, i < 3 ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, 34 + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy + 2, sp->classic_name[i]);
                ncd_draw_number_right(bp, i < 3 ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, 34 + 16 * cs_big_menu_font_green.w + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy + 2, sp->classic_score[i], 5);
            }
        }

        /* display subtitle */
        if(sub)
        {
            ncd_textout_center(bp, &cs_menu_font, ox, 231 + oy, "Classic Mode");
        }
    }

    /* destroyer mode */
    else if(mode < 11)
    {
        for(i = 0; i < 10; i++)
        {
            /* draw normal if it's not set to be dark */
            if(i == fdark - 1 || fdark <= 0)
            {
                ncd_textout(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy, sp->destroyer_name[mode - 1][i]);
                ncd_draw_number(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + 16 * cs_big_menu_font_green.w + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy, sp->destroyer_minutes[mode - 1][i], 2);
                ncd_textout(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + 18 * cs_big_menu_font_green.w + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy, ":");
                ncd_draw_number(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + 19 * cs_big_menu_font_green.w + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy, sp->destroyer_seconds[mode - 1][i], 2);
            }

            /* draw it dark otherwise */
            else
            {
                ncd_textout(bp, i < 3 ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, 34 + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy + 2, sp->destroyer_name[mode - 1][i]);
                ncd_draw_number(bp, i < 3 ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, 34 + 16 * cs_big_menu_font_green.w + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy + 2, sp->destroyer_minutes[mode - 1][i], 2);
                ncd_textout(bp, i < 3 ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, 34 + 18 * cs_big_menu_font_green.w + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy + 2, ":");
                ncd_draw_number(bp, i < 3 ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, 34 + 19 * cs_big_menu_font_green.w + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy + 2, sp->destroyer_seconds[mode - 1][i], 2);
            }
        }

        /* display subtitle */
        if(sub)
        {
            ncd_printf_center(bp, &cs_menu_font, ox, 231 + oy, "Destroyer Mode (%d Blocks)", block_chart[mode - 1]);
        }
    }

    /* frenzy mode */
    else if(mode < 21)
    {
        for(i = 0; i < 10; i++)
        {
            /* draw normal if it's not set to be dark */
            if(i == fdark - 1 || fdark <= 0)
            {
                ncd_textout(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + ox, HISCORE_Y + i * cs_big_menu_font_green.w + oy, sp->frenzy_name[mode - 11][i]);
                ncd_draw_number_right(bp, i < 3 ? &cs_big_menu_font_green : &cs_big_menu_font_red, 34 + 16 * cs_big_menu_font_green.w + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy, sp->frenzy_score[mode - 11][i], 5);
            }

            /* draw it dark otherwise */
            else
            {
                ncd_textout(bp, i < 3 ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, 34 + ox, HISCORE_Y + i * cs_big_menu_font_green.w + oy + 2, sp->frenzy_name[mode - 11][i]);
                ncd_draw_number_right(bp, i < 3 ? &cs_big_menu_font_green_un : &cs_big_menu_font_red_un, 34 + 16 * cs_big_menu_font_green.w + ox, HISCORE_Y + i * cs_big_menu_font_green.h + oy + 2, sp->frenzy_score[mode - 11][i], 5);
            }
        }

        /* display subtitle */
        if(sub)
        {
            ncd_printf_center(bp, &cs_menu_font, ox, 231 + oy, "Frenzy Mode (  :  )");
            ncd_draw_number(bp, &cs_menu_font, 192 + ox, 231 + oy, time_minutes_chart[mode - 11], 2);
            ncd_draw_number(bp, &cs_menu_font, 216 + ox, 231 + oy, time_seconds_chart[mode - 11], 2);
        }
    }
}

/* does the high score screen */
void high_scores(BITMAP * bp, CS_GAME * gp, NCDFONT * fp, CS_TOP10 * sp)
{
    /* initialize */
    cs_initialize_scores(sp);

    /* set dark flag to off */
    fdark = 0;

    /* see what place the player is in the table */
    cs_place = cs_place_score(gp, sp);

    /* if player placed, get player name */
    if(cs_place < 10 && !(gp->mode == CS_1TD && (game_quit || gp->state == STATE_GAMEOVER)))
    {
        /* so we know what name to draw bright when player is entering name */
        fdark = cs_place + 1;

        /* update the background */
        blit(cs_menu_bg_image, bp, 0, 0, 0, 0, 320, 240);
        draw_sprite(bp, cs_high_score_image, 0, MLOGO_Y);

        /* make room */
        cs_make_room(gp, sp, cs_place);

        /* draw the scores table */
        if(gp->mode == CS_1NS)
        {
            draw_high_scores_pos(bp, fp, sp, 0, 0, 0, 1);
        }
        else if(gp->mode == CS_1TD)
        {
            draw_high_scores_pos(bp, fp, sp, 1 + cs_options.block_index, 0, 0, 1);
        }
        else if(gp->mode == CS_1TF)
        {
            draw_high_scores_pos(bp, fp, sp, 11 + cs_options.time_index, 0, 0, 1);
        }

        /* do transition effect */
        if(cs_options.transitions)
        {
            t3ss_play_sound(cs_sound[SOUND_FADE_IN], 128, 22050);
            gef_pixelize_in(screen_buffer);
        }
        else
        {
            cs_screen_blit(screen_buffer, 0, 0);
            fade_in(screen_palette, 3);
        }
        t3ss_play_mod(DATADIR "cs.dat#highs_music");

        /* get player name */
        cs_enter_name(gp, sp, cs_place, 0);

        /* show scores until player exits screen */
        if(gp->mode == CS_1NS)
        {
            show_scores_immediate(0);
        }
        if(gp->mode == CS_1TD)
        {
            show_scores_immediate(1 + cs_options.block_index);
        }
        if(gp->mode == CS_1TF)
        {
            show_scores_immediate(11 + cs_options.time_index);
        }
    }

    /* otherwise just draw the scores */
    else
    {
        fdark = 0;

        /* update the background */
        blit(cs_menu_bg_image, bp, 0, 0, 0, 0, 320, 240);
        draw_sprite(bp, cs_high_score_image, 0, MLOGO_Y);

        /* draw the scores */
        if(gp->mode == CS_1NS)
        {
            draw_high_scores(bp, fp, sp, 0);
        }
        else if(gp->mode == CS_1TD)
        {
            draw_high_scores(bp, fp, sp, 1 + cs_options.block_index);
        }
        else if(gp->mode == CS_1TF)
        {
            draw_high_scores(bp, fp, sp, 11 + cs_options.time_index);
        }

        /* do transition effect */
        if(cs_options.transitions)
        {
            t3ss_play_sound(cs_sound[SOUND_FADE_IN], 128, 22050);
            gef_pixelize_in(screen_buffer);
        }
        else
        {
            cs_screen_blit(screen_buffer, 0, 0);
            fade_in(screen_palette, 3);
        }
        t3ss_play_mod(DATADIR "cs.dat#menu_music");

        /* show scores until player exits screen */
        if(gp->mode == CS_1NS)
        {
            show_scores_immediate(0);
        }
        if(gp->mode == CS_1TD)
        {
            show_scores_immediate(1 + cs_options.block_index);
        }
        if(gp->mode == CS_1TF)
        {
            show_scores_immediate(11 + cs_options.time_index);
        }
    }

    /* yup */
    cs_exit_scores(sp);
}
