#include <allegro.h>
#include "cs.h"
#include "gef.h"

/* temporary screen for effects to draw to */
BITMAP * gef_screen;

/* vsync flag */
int      gef_vsync = 1;

void gef_init(int w, int h)
{
    gef_screen = create_bitmap(w, h);
}

void gef_exit(void)
{
    destroy_bitmap(gef_screen);
}

void gef_draw_hline(BITMAP * sbp, BITMAP * dbp, int sy, int dy)
{
	int i;

	for(i = 0; i < sbp->w; i++)
	{
		putpixel(dbp, i, dy, getpixel(sbp, i, sy));
	}
}

void gef_smear_in(BITMAP * bp)
{
	int i, j;

	for(i = 0; i < 240; i++)
	{
		for(j = i; j < 240; j++)
		{
			gef_draw_hline(bp, gef_screen, i, j);
		}
        cs_vsync();
        cs_screen_blit(gef_screen, 0, 0);
	}
	clear_bitmap(screen);
}

void gef_split_out_horizontal(BITMAP * bp)
{
    int i;
    int speed = 1;

    for(i = 0; i < gef_screen->h / 2; i += speed / 4)
    {
        speed++;
    }
    speed++;
    for(i = 0; i < gef_screen->h / 2; i += speed / 4)
    {
        clear(gef_screen);
        blit(bp, gef_screen, 0, 0, 0, -i, gef_screen->w, gef_screen->h / 2);
        blit(bp, gef_screen, 0, gef_screen->h / 2, 0, i + gef_screen->h / 2, gef_screen->w, gef_screen->h);
        speed--;

        cs_vsync();
        cs_screen_blit(gef_screen, 0, 0);
//        blit(gef_screen, screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
    }
    clear(screen);
}

void gef_split_out_horizontal_b(BITMAP * bp)
{
    int i;
    int speed = 1;

    for(i = 0; i < gef_screen->w; i += speed / 4)
    {
        speed++;
    }
    speed++;
    for(i = 0; i < gef_screen->w; i += speed / 4)
    {
        clear(gef_screen);
        blit(bp, gef_screen, 0, 0, -i, 0, gef_screen->w, gef_screen->h / 2);
        blit(bp, gef_screen, 0, gef_screen->h / 2, i, gef_screen->h / 2, gef_screen->w, gef_screen->h);
        speed--;

        cs_vsync();
        cs_screen_blit(gef_screen, 0, 0);
//        blit(gef_screen, screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
    }
    clear(screen);
}

void gef_split_in_horizontal(BITMAP * bp)
{
    int i;
    int speed = 1;

    for(i = 0; i < gef_screen->h / 2; i += speed / 4)
    {
        speed++;
    }
    speed++;
    blit(screen, gef_screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
    for(i = 0; i < gef_screen->h / 2; i += speed / 4)
    {
        blit(bp, gef_screen, 0, 0, 0, -(gef_screen->h / 2) + i, gef_screen->w, gef_screen->h / 2);
        blit(bp, gef_screen, 0, gef_screen->h / 2, 0, gef_screen->h - i, gef_screen->w, gef_screen->h);
        speed--;

        cs_vsync();
        cs_screen_blit(gef_screen, 0, 0);
//        blit(gef_screen, screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
    }
}

void gef_split_out_vertical(BITMAP * bp)
{
    int i;
    int speed = 1;

    for(i = 0; i < gef_screen->w / 2; i += speed / 4)
    {
        speed++;
    }
    speed++;
    for(i = 0; i < gef_screen->w / 2; i += speed / 4)
    {
        clear(gef_screen);
        blit(bp, gef_screen, 0, 0, -i, 0, gef_screen->w / 2, gef_screen->h);
        blit(bp, gef_screen, gef_screen->w / 2, 0, i + gef_screen->w / 2, 0, gef_screen->w, gef_screen->h);
        speed--;

        cs_vsync();
        cs_screen_blit(gef_screen, 0, 0);
//        blit(gef_screen, screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
    }
    clear(screen);
}

void gef_split_in_vertical(BITMAP * bp)
{
    int i;
    int speed = 1;

    for(i = 0; i < gef_screen->w / 2; i += speed / 4)
    {
        speed++;
    }
    speed++;
    blit(screen, gef_screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
    for(i = 0; i < gef_screen->w / 2; i += speed / 4)
    {
        blit(bp, gef_screen, 0, 0, -(gef_screen->w / 2) + i, 0, gef_screen->w / 2, gef_screen->h);
        blit(bp, gef_screen, gef_screen->w / 2, 0, gef_screen->w - i, 0, gef_screen->w, gef_screen->h);
        speed--;

        cs_vsync();
        cs_screen_blit(gef_screen, 0, 0);
//        blit(gef_screen, screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
    }
}

void gef_stretch_pixel(BITMAP * bp, int x, int y, int size)
{
    rectfill(bp, x, y, x + size - 1, y + size - 1, bp->line[y][x]);
}

void gef_pixelize_out(BITMAP * bp)
{
    int i, j, k;

    for(i = 2; i < gef_screen->w; i += i / 2)
    {
        blit(bp, gef_screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
        for(j = 0; j < gef_screen->h; j += i)
        {
            for(k = 0; k < gef_screen->w; k += i)
            {
                gef_stretch_pixel(gef_screen, k, j, i);
            }
        }
        cs_vsync();
        cs_vsync();
        cs_vsync();
        cs_vsync();
        cs_screen_blit(gef_screen, 0, 0);
//        blit(gef_screen, screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
    }
}

void gef_pixelize_in(BITMAP * bp)
{
    int i, j, k;

    for(i = gef_screen->w; i >= 2; i -= i / 2)
    {
        blit(bp, gef_screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
        for(j = 0; j < gef_screen->h; j += i)
        {
            for(k = 0; k < gef_screen->w; k += i)
            {
                gef_stretch_pixel(gef_screen, k, j, i);
            }
        }
        cs_vsync();
        cs_vsync();
        cs_vsync();
        cs_vsync();
        cs_screen_blit(gef_screen, 0, 0);
//        blit(gef_screen, screen, 0, 0, 0, 0, gef_screen->w, gef_screen->h);
    }
}
