#ifndef EXTERNS_H
#define EXTERNS_H

#include "includes.h"

/* stuff used by the game engine */
extern CS_THEME      cs_theme;
extern CS_GAME       cs_game[MAX_PLAYERS];
extern CS_CLOCK      cs_clock;
extern EFFECT_BLOCKS cs_effects_blocks;
extern int           cs_panning[3][MAX_PLAYERS];

/* data used by the game */
extern CS_OPTIONS    cs_options;
extern CS_TOP10      cs_scores;
extern CKEYS         cs_controls[2];

/* data used in the menu */
extern CS_MENU       cs_menu[TOTAL_MENUS];
extern NCDFONT       cs_menu_font;
extern NCDFONT       cs_big_menu_font;
extern NCDFONT       cs_big_menu_font_un;
extern NCDFONT       cs_big_menu_font_green;
extern NCDFONT       cs_big_menu_font_green_un;
extern NCDFONT       cs_big_menu_font_red;
extern NCDFONT       cs_big_menu_font_red_un;

extern int           current_menu;
extern BITMAP *      cs_menu_bg_image;
extern BITMAP *      cs_logo_image;
extern BITMAP *      cs_high_score_image;
extern CS_SPRITE     cs_select_sprite;
extern ANIMATION     cs_select_animation;
//char *        MenuText[TOTAL_MENUS][MAX_MENU_ITEMS];
extern char *        sound_quality_text[5];
extern char *        toggle_text[2];
extern char *        stereo_mode_text[3];
extern char *        screen_mode_text[3];
extern char          cs_game_mode;
extern MSAMPLE *     cs_sound[MAX_CS_SOUNDS];
extern char          menu_quit;

/* store filenames used by the program */
extern char          music_name[256];

/* charts used to set things up */
extern const int     block_chart[10];
extern const int     time_minutes_chart[10];
extern const int     time_seconds_chart[10];
extern const int     sound_quality_chart[5];
//extern const int     BufferChart[5];

/* variables use by game modules */
extern char          game_quit;
extern char          beat_score;

/* stuff used by the high score routines */
extern int           cs_place;

/* lookup chart used to find drop times */
extern int           level_chart[20];

/* screen buffer and palette */
extern BITMAP *      screen_buffer;
extern PALETTE       screen_palette;
extern BITMAP *      mouse_image;

/* miscellaneous variables */
extern char          nosound;
extern char          cs_screen_mode;
extern int           drop_amount[MAX_PLAYERS];
extern unsigned long cs_frame;

extern char * key_names[112];
extern BITMAP * gef_screen;

#endif
