#include "includes.h"
#include "externs.h"

#define DOUBLE_FRAMES 8

/* reset the effect blocks */
void initialize_effect_blocks(EFFECT_BLOCKS * bp)
{
    int i;

    for(i = 0; i < MAX_EFFECTS_BLOCKS; i++)
    {
        bp->block[i].active = 0;
        bp->current_block = 0;
    }
}

/* moves an effect block along arcing path */
void move_effect_block(CS_THEME * tp, EFFECT_BLOCK * bp)
{
    if(bp->active)
    {
        /* move across */
        bp->fx += (bp->fvx);
        bp->dx += (bp->dvx);
        bp->dvx = (bp->dx / DOUBLE_FRAMES);

        if(bp->fx < -bp->fsize || bp->fx > tp->rx)
        {
            bp->active = 0;
        }

        /* move down */
        bp->fy += (bp->fvy);
        bp->dy += (bp->dvy);
        bp->dvy = (bp->dy / DOUBLE_FRAMES);
        if(bp->fy > tp->ry)
        {
            bp->active = 0;
        }

        /* adjust x- and y-coordinates to keep block centered */
        bp->fx -= bp->ds / 2;
        bp->fy -= bp->ds / 2;

        /* set correct integer values so we can draw it */
        bp->x = bp->fx;
        bp->y = bp->fy;

        /* increase y-speed and size */
        bp->fvy += bp->dy;
        bp->fsize += bp->ds;
        bp->ds += bp->dvs;
        bp->dvs = (bp->ds / DOUBLE_FRAMES);
        bp->size = bp->fsize;
    }
}

/* draw an effect block at its current location */
void draw_effect_block(CS_THEME * tp, EFFECT_BLOCK * bp)
{
    /* only draw when active */
    if(bp->active)
    {
        stretch_sprite(tp->screen, get_ani(tp->block_image[bp->color], cs_frame), bp->x, bp->y, bp->size, bp->size);
    }
}

/* generate an effect block at specified location */
void generate_effect_block(CS_THEME * tp, EFFECT_BLOCKS * bp, int x, int y, int boardx, int boardy, char color)
{
    bp->block[bp->current_block].color = color;
    bp->block[bp->current_block].x = x;
    bp->block[bp->current_block].fx = x;
    bp->block[bp->current_block].y = y;
    bp->block[bp->current_block].fy = y;
    bp->block[bp->current_block].ds = tp->block_w / DOUBLE_FRAMES;
    bp->block[bp->current_block].dvs = (bp->block[bp->current_block].ds / DOUBLE_FRAMES);
    bp->block[bp->current_block].dx = tp->rx / 320;
    bp->block[bp->current_block].dvx = (bp->block[bp->current_block].dx / DOUBLE_FRAMES);
    bp->block[bp->current_block].dy = tp->ry / 240;
    bp->block[bp->current_block].dvy = (bp->block[bp->current_block].dy / (DOUBLE_FRAMES / 2));
    if(x < tp->board_w >> 1)
    {
        bp->block[bp->current_block].fvx = (boardx - (tp->board_w >> 1) + (ncd_random() % 2) - 1) * bp->block[bp->current_block].dx;
    }
    else
    {
        bp->block[bp->current_block].fvx = (boardx - (tp->board_w >> 1) + ncd_random() % 2) * bp->block[bp->current_block].dx;
    }
    bp->block[bp->current_block].fvy = ((ncd_random() % 3) - 4) * bp->block[bp->current_block].dy;
    bp->block[bp->current_block].size = tp->block_w;
    bp->block[bp->current_block].fsize = tp->block_w;
    bp->block[bp->current_block].active = 1;
    bp->current_block--;
    if(bp->current_block < 0)
    {
        bp->current_block = MAX_EFFECTS_BLOCKS - 1;
    }
}

/* move all active effect blocks */
void move_effect_blocks(CS_THEME * tp, EFFECT_BLOCKS * bp)
{
    int i;

    for(i = 0; i < MAX_EFFECTS_BLOCKS; i++)
    {
        move_effect_block(tp, &bp->block[i]);
    }
}

/* draw all active effect blocks */
void draw_effect_blocks(CS_THEME * tp, EFFECT_BLOCKS * bp)
{
    int i;

    for(i = 0; i < MAX_EFFECTS_BLOCKS; i++)
    {
        draw_effect_block(tp, &bp->block[i]);
    }
}
